/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.KeepForSubclassing;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.origin.ArchiveEntryOrigin;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.ZipUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

@KeepForSubclassing
public class ArchiveProgramResourceProvider
implements ProgramResourceProvider {
    private final Origin origin;
    private final ZipFileSupplier supplier;
    private final Predicate<String> include;

    public static boolean includeClassFileEntries(String entry) {
        return ZipUtils.isClassFile(entry);
    }

    public static boolean includeDexEntries(String entry) {
        return ZipUtils.isDexFile(entry);
    }

    public static boolean includeClassFileOrDexEntries(String entry) {
        return ZipUtils.isClassFile(entry) || ZipUtils.isDexFile(entry);
    }

    public static ArchiveProgramResourceProvider fromArchive(Path archive) {
        return ArchiveProgramResourceProvider.fromArchive(archive, ArchiveProgramResourceProvider::includeClassFileOrDexEntries);
    }

    public static ArchiveProgramResourceProvider fromArchive(Path archive, Predicate<String> include) {
        return ArchiveProgramResourceProvider.fromSupplier(new PathOrigin(archive), () -> FileUtils.createZipFile(archive.toFile(), StandardCharsets.UTF_8), include);
    }

    public static ArchiveProgramResourceProvider fromSupplier(Origin origin, ZipFileSupplier supplier) {
        return ArchiveProgramResourceProvider.fromSupplier(origin, supplier, ArchiveProgramResourceProvider::includeClassFileOrDexEntries);
    }

    public static ArchiveProgramResourceProvider fromSupplier(Origin origin, ZipFileSupplier supplier, Predicate<String> include) {
        return new ArchiveProgramResourceProvider(origin, supplier, include);
    }

    private ArchiveProgramResourceProvider(Origin origin, ZipFileSupplier supplier, Predicate<String> include) {
        assert (origin != null);
        assert (supplier != null);
        assert (include != null);
        this.origin = origin;
        this.supplier = supplier;
        this.include = include;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void readArchive(ArchiveEntryConsumer consumer) throws IOException {
        try {
            ZipFile zipFile = this.supplier.open();
            Throwable throwable = null;
            try {
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    InputStream stream = zipFile.getInputStream(entry);
                    Throwable throwable2 = null;
                    try {
                        consumer.accept(new ArchiveEntryOrigin(entry.getName(), this.origin), stream);
                        if (stream == null) continue;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (stream == null) throw throwable4;
                            ArchiveProgramResourceProvider.$closeResource(throwable2, stream);
                            throw throwable4;
                        }
                    }
                    ArchiveProgramResourceProvider.$closeResource(throwable2, stream);
                }
                if (zipFile == null) return;
            }
            catch (Throwable throwable5) {
                try {
                    throwable = throwable5;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    if (zipFile == null) throw throwable6;
                    ArchiveProgramResourceProvider.$closeResource(throwable, zipFile);
                    throw throwable6;
                }
            }
            ArchiveProgramResourceProvider.$closeResource(throwable, zipFile);
            return;
        }
        catch (ZipException e) {
            throw new CompilationError("Zip error while reading archive" + e.getMessage(), e, this.origin);
        }
    }

    @Override
    public Collection<ProgramResource> getProgramResources() throws ResourceException {
        try {
            ArrayList<ProgramResource> dexResources = new ArrayList<ProgramResource>();
            ArrayList classResources = new ArrayList();
            this.readArchive((entry, stream) -> {
                String name = entry.getEntryName();
                if (this.include.test(name)) {
                    if (ZipUtils.isDexFile(name)) {
                        dexResources.add(ProgramResource.fromBytes(entry, ProgramResource.Kind.DEX, ByteStreams.toByteArray(stream), null));
                    } else if (ZipUtils.isClassFile(name)) {
                        String descriptor = DescriptorUtils.guessTypeDescriptor(name);
                        classResources.add(ProgramResource.fromBytes(entry, ProgramResource.Kind.CF, ByteStreams.toByteArray(stream), Collections.singleton(descriptor)));
                    }
                }
            });
            if (!dexResources.isEmpty() && !classResources.isEmpty()) {
                throw new CompilationError("Cannot create android app from an archive containing both DEX and Java-bytecode content.", this.origin);
            }
            return !dexResources.isEmpty() ? dexResources : classResources;
        }
        catch (IOException e) {
            throw new ResourceException(this.origin, (Throwable)e);
        }
    }

    @KeepForSubclassing
    public static interface ZipFileSupplier {
        public ZipFile open() throws IOException;
    }

    static interface ArchiveEntryConsumer {
        public void accept(ArchiveEntryOrigin var1, InputStream var2) throws IOException;
    }
}

