/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BackportedMethodListCommand;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.Keep;
import com.android.tools.r8.Version;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.desugar.BackportedMethodRewriter;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.concurrent.ExecutorService;

@Keep
public class BackportedMethodList {
    static final String USAGE_MESSAGE = StringUtils.joinLines("Usage: BackportedMethodList [options]", " Options are:", "  --output <file>         # Output result in <file>.", "  --min-api <number>      # Minimum Android API level for the application", "  --desugared-lib <file>  # Desugared library configuration (JSON from the", "                          # configuration)", "  --lib <file>            # The compilation SDK library (android.jar)", "  --version               # Print the version of BackportedMethodList.", "  --help                  # Print this message.");

    private static String formatMethod(DexMethod method) {
        return DescriptorUtils.getClassBinaryNameFromDescriptor(method.holder.descriptor.toString()) + '#' + method.name + method.proto.toDescriptorString();
    }

    public static void run(BackportedMethodListCommand command) throws CompilationFailedException {
        if (command.isPrintHelp()) {
            System.out.println(USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("BackportedMethodList " + Version.getVersionString());
            return;
        }
        InternalOptions options = command.getInternalOptions();
        ExecutorService executorService = ThreadUtils.getExecutorService(options);
        try {
            ExceptionUtils.withD8CompilationHandler(command.getReporter(), () -> {
                BackportedMethodRewriter.generateListOfBackportedMethods(command.getInputApp(), options, executorService).stream().map(BackportedMethodList::formatMethod).sorted().forEach(formattedMethod -> command.getBackportedMethodListConsumer().accept((String)formattedMethod, command.getReporter()));
                command.getBackportedMethodListConsumer().finished(command.getReporter());
            });
        }
        finally {
            executorService.shutdown();
        }
    }

    public static void run(String[] args2) throws CompilationFailedException {
        BackportedMethodList.run(BackportedMethodListCommand.parse(args2).build());
    }

    public static void main(String[] args2) {
        ExceptionUtils.withMainProgramHandler(() -> BackportedMethodList.run(args2));
    }
}

