/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.Keep;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.StringResource;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.ir.desugar.desugaredlibrary.DesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.desugaredlibrary.DesugaredLibrarySpecificationParser;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanDesugaredLibrarySpecification;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@Keep
public class BackportedMethodListCommand {
    private final boolean printHelp;
    private final boolean printVersion;
    private final Reporter reporter;
    private final int minApiLevel;
    private final DesugaredLibrarySpecification desugaredLibrarySpecification;
    private final AndroidApp app;
    private final StringConsumer backportedMethodListConsumer;
    private final DexItemFactory factory;

    private BackportedMethodListCommand(boolean printHelp, boolean printVersion) {
        this.printHelp = printHelp;
        this.printVersion = printVersion;
        this.reporter = new Reporter();
        this.minApiLevel = -1;
        this.desugaredLibrarySpecification = null;
        this.app = null;
        this.backportedMethodListConsumer = null;
        this.factory = null;
    }

    private BackportedMethodListCommand(Reporter reporter, int minApiLevel, DesugaredLibrarySpecification desugaredLibrarySpecification, AndroidApp app, StringConsumer backportedMethodListConsumer, DexItemFactory factory) {
        this.printHelp = false;
        this.printVersion = false;
        this.reporter = reporter;
        this.minApiLevel = minApiLevel;
        this.desugaredLibrarySpecification = desugaredLibrarySpecification;
        this.app = app;
        this.backportedMethodListConsumer = backportedMethodListConsumer;
        this.factory = factory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    public static Builder parse(String[] args2) {
        ImmutableSet<String> OPTIONS_WITH_PARAMETER = ImmutableSet.of("--output", "--min-api", "--desugared-lib", "--lib");
        boolean hasDefinedApiLevel = false;
        Builder builder = BackportedMethodListCommand.builder();
        for (int i = 0; i < args2.length; ++i) {
            String arg = args2[i].trim();
            String nextArg = null;
            if (OPTIONS_WITH_PARAMETER.contains(arg)) {
                if (++i < args2.length) {
                    nextArg = args2[i];
                } else {
                    builder.error(new StringDiagnostic("Missing parameter for " + args2[i - 1] + "."));
                    break;
                }
            }
            if (arg.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (arg.equals("--version")) {
                builder.setPrintVersion(true);
                continue;
            }
            if (arg.equals("--min-api")) {
                if (hasDefinedApiLevel) {
                    builder.error(new StringDiagnostic("Cannot set multiple --min-api options"));
                    continue;
                }
                BackportedMethodListCommand.parseMinApi(builder, nextArg);
                hasDefinedApiLevel = true;
                continue;
            }
            if (arg.equals("--desugared-lib")) {
                builder.addDesugaredLibraryConfiguration(StringResource.fromFile(Paths.get(nextArg, new String[0])));
                continue;
            }
            if (arg.equals("--lib")) {
                builder.addLibraryFiles(Paths.get(nextArg, new String[0]));
                continue;
            }
            if (arg.equals("--output")) {
                builder.setOutputPath(Paths.get(nextArg, new String[0]));
                continue;
            }
            builder.error(new StringDiagnostic("Unknown option: " + arg));
        }
        return builder;
    }

    private static void parseMinApi(Builder builder, String minApiString) {
        int minApi;
        try {
            minApi = Integer.parseInt(minApiString);
        }
        catch (NumberFormatException e) {
            builder.error(new StringDiagnostic("Invalid argument to --min-api: " + minApiString));
            return;
        }
        if (minApi < 1) {
            builder.error(new StringDiagnostic("Invalid argument to --min-api: " + minApiString));
            return;
        }
        builder.setMinApiLevel(minApi);
    }

    public boolean isPrintHelp() {
        return this.printHelp;
    }

    public boolean isPrintVersion() {
        return this.printVersion;
    }

    Reporter getReporter() {
        return this.reporter;
    }

    public int getMinApiLevel() {
        return this.minApiLevel;
    }

    public DesugaredLibrarySpecification getDesugaredLibraryConfiguration() {
        return this.desugaredLibrarySpecification;
    }

    public StringConsumer getBackportedMethodListConsumer() {
        return this.backportedMethodListConsumer;
    }

    AndroidApp getInputApp() {
        return this.app;
    }

    InternalOptions getInternalOptions() {
        InternalOptions options = new InternalOptions(this.factory, this.getReporter());
        options.setMinApiLevel(AndroidApiLevel.getAndroidApiLevel(this.minApiLevel));
        options.setDesugaredLibrarySpecification(this.desugaredLibrarySpecification);
        return options;
    }

    @Keep
    public static class Builder {
        private final Reporter reporter;
        private int minApiLevel = AndroidApiLevel.B.getLevel();
        private List<StringResource> desugaredLibrarySpecificationResources = new ArrayList<StringResource>();
        private final AndroidApp.Builder app = AndroidApp.builder();
        private StringConsumer backportedMethodListConsumer;
        private boolean printHelp = false;
        private boolean printVersion = false;

        private Builder() {
            this(new DiagnosticsHandler(){});
        }

        private Builder(DiagnosticsHandler diagnosticsHandler) {
            this.reporter = new Reporter(diagnosticsHandler);
        }

        private void error(Diagnostic diagnostic) {
            this.reporter.error(diagnostic);
        }

        public Builder setMinApiLevel(int minApiLevel) {
            if (minApiLevel <= 0) {
                this.reporter.error(new StringDiagnostic("Invalid minApiLevel: " + minApiLevel));
            } else {
                this.minApiLevel = minApiLevel;
            }
            return this;
        }

        public int getMinApiLevel() {
            return this.minApiLevel;
        }

        public Builder addDesugaredLibraryConfiguration(StringResource configuration) {
            this.desugaredLibrarySpecificationResources.add(configuration);
            return this;
        }

        public Builder addDesugaredLibraryConfiguration(String configuration) {
            return this.addDesugaredLibraryConfiguration(StringResource.fromString(configuration, Origin.unknown()));
        }

        public Builder addLibraryResourceProvider(ClassFileResourceProvider provider) {
            this.app.addLibraryResourceProvider(provider);
            return this;
        }

        public Builder addLibraryFiles(Path ... files) {
            this.addLibraryFiles(Arrays.asList(files));
            return this;
        }

        public Builder addLibraryFiles(Collection<Path> files) {
            for (Path path : files) {
                this.app.addLibraryFile(path);
            }
            return this;
        }

        DesugaredLibrarySpecification getDesugaredLibraryConfiguration(DexItemFactory factory) {
            if (this.desugaredLibrarySpecificationResources.isEmpty()) {
                return HumanDesugaredLibrarySpecification.empty();
            }
            if (this.desugaredLibrarySpecificationResources.size() > 1) {
                this.reporter.fatalError("Only one desugared library configuration is supported.");
            }
            StringResource desugaredLibrarySpecificationResource = this.desugaredLibrarySpecificationResources.get(0);
            return DesugaredLibrarySpecificationParser.parseDesugaredLibrarySpecification(desugaredLibrarySpecificationResource, factory, null, false, this.getMinApiLevel());
        }

        public Builder setOutputPath(Path outputPath) {
            this.backportedMethodListConsumer = new StringConsumer.FileConsumer(outputPath){

                @Override
                public void accept(String string, DiagnosticsHandler handler) {
                    super.accept(string, handler);
                    super.accept(System.lineSeparator(), handler);
                }
            };
            return this;
        }

        public Builder setConsumer(StringConsumer consumer) {
            this.backportedMethodListConsumer = consumer;
            return this;
        }

        public boolean isPrintHelp() {
            return this.printHelp;
        }

        public Builder setPrintHelp(boolean printHelp) {
            this.printHelp = printHelp;
            return this;
        }

        public boolean isPrintVersion() {
            return this.printVersion;
        }

        public Builder setPrintVersion(boolean printVersion) {
            this.printVersion = printVersion;
            return this;
        }

        public BackportedMethodListCommand build() {
            AndroidApp library = this.app.build();
            if (!this.desugaredLibrarySpecificationResources.isEmpty() && library.getLibraryResourceProviders().isEmpty()) {
                this.reporter.error(new StringDiagnostic("With desugared library configuration a library is required"));
            }
            if (this.isPrintHelp() || this.isPrintVersion()) {
                return new BackportedMethodListCommand(this.isPrintHelp(), this.isPrintVersion());
            }
            if (this.backportedMethodListConsumer == null) {
                this.backportedMethodListConsumer = new StringConsumer(){

                    @Override
                    public void accept(String string, DiagnosticsHandler handler) {
                        System.out.println(string);
                    }

                    @Override
                    public void finished(DiagnosticsHandler handler) {
                    }
                };
            }
            DexItemFactory factory = new DexItemFactory();
            return new BackportedMethodListCommand(this.reporter, this.minApiLevel, this.getDesugaredLibraryConfiguration(factory), library, this.backportedMethodListConsumer, factory);
        }
    }
}

