/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.AssertionsConfiguration;
import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.InternalProgramOutputPathConsumer;
import com.android.tools.r8.Keep;
import com.android.tools.r8.MapIdProvider;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.SourceFileProvider;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.StringResource;
import com.android.tools.r8.dump.DumpOptions;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.inspector.Inspector;
import com.android.tools.r8.ir.desugar.desugaredlibrary.DesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.desugaredlibrary.DesugaredLibrarySpecificationParser;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanDesugaredLibrarySpecification;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.DumpInputFlags;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;

@Keep
public abstract class BaseCompilerCommand
extends BaseCommand {
    private final CompilationMode mode;
    private final ProgramConsumer programConsumer;
    private final StringConsumer mainDexListConsumer;
    private final int minApiLevel;
    private final Reporter reporter;
    private final InternalOptions.DesugarState desugarState;
    private final boolean includeClassesChecksum;
    private final boolean optimizeMultidexForLinearAlloc;
    private final BiPredicate<String, Long> dexClassChecksumFilter;
    private final List<AssertionsConfiguration> assertionsConfiguration;
    private final List<Consumer<Inspector>> outputInspections;
    private final int threadCount;
    private final DumpInputFlags dumpInputFlags;
    private final MapIdProvider mapIdProvider;
    private final SourceFileProvider sourceFileProvider;

    BaseCompilerCommand(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
        this.programConsumer = null;
        this.mainDexListConsumer = null;
        this.mode = null;
        this.minApiLevel = 0;
        this.reporter = new Reporter();
        this.desugarState = InternalOptions.DesugarState.ON;
        this.includeClassesChecksum = false;
        this.optimizeMultidexForLinearAlloc = false;
        this.dexClassChecksumFilter = (name, checksum) -> true;
        this.assertionsConfiguration = new ArrayList<AssertionsConfiguration>();
        this.outputInspections = null;
        this.threadCount = -1;
        this.dumpInputFlags = DumpInputFlags.noDump();
        this.mapIdProvider = null;
        this.sourceFileProvider = null;
    }

    BaseCompilerCommand(AndroidApp app, CompilationMode mode, ProgramConsumer programConsumer, StringConsumer mainDexListConsumer, int minApiLevel, Reporter reporter, InternalOptions.DesugarState desugarState, boolean optimizeMultidexForLinearAlloc, boolean includeClassesChecksum, BiPredicate<String, Long> dexClassChecksumFilter, List<AssertionsConfiguration> assertionsConfiguration, List<Consumer<Inspector>> outputInspections, int threadCount, DumpInputFlags dumpInputFlags, MapIdProvider mapIdProvider, SourceFileProvider sourceFileProvider) {
        super(app);
        assert (minApiLevel > 0);
        assert (mode != null);
        this.mode = mode;
        this.programConsumer = programConsumer;
        this.mainDexListConsumer = mainDexListConsumer;
        this.minApiLevel = minApiLevel;
        this.reporter = reporter;
        this.desugarState = desugarState;
        this.optimizeMultidexForLinearAlloc = optimizeMultidexForLinearAlloc;
        this.includeClassesChecksum = includeClassesChecksum;
        this.dexClassChecksumFilter = dexClassChecksumFilter;
        this.assertionsConfiguration = assertionsConfiguration;
        this.outputInspections = outputInspections;
        this.threadCount = threadCount;
        this.dumpInputFlags = dumpInputFlags;
        this.mapIdProvider = mapIdProvider;
        this.sourceFileProvider = sourceFileProvider;
    }

    public CompilationMode getMode() {
        return this.mode;
    }

    public int getMinApiLevel() {
        return this.minApiLevel;
    }

    void dumpBaseCommandOptions(DumpOptions.Builder builder) {
        builder.setCompilationMode(this.getMode()).setMinApi(this.getMinApiLevel()).setOptimizeMultidexForLinearAlloc(this.isOptimizeMultidexForLinearAlloc()).setThreadCount(this.getThreadCount()).setDesugarState(this.getDesugarState());
    }

    public ProgramConsumer getProgramConsumer() {
        return this.programConsumer;
    }

    public StringConsumer getMainDexListConsumer() {
        return this.mainDexListConsumer;
    }

    public boolean getEnableDesugaring() {
        return this.desugarState == InternalOptions.DesugarState.ON;
    }

    InternalOptions.DesugarState getDesugarState() {
        return this.desugarState;
    }

    public MapIdProvider getMapIdProvider() {
        return this.mapIdProvider;
    }

    public SourceFileProvider getSourceFileProvider() {
        return this.sourceFileProvider;
    }

    public boolean getIncludeClassesChecksum() {
        return this.includeClassesChecksum;
    }

    public BiPredicate<String, Long> getDexClassChecksumFilter() {
        return this.dexClassChecksumFilter;
    }

    public boolean isOptimizeMultidexForLinearAlloc() {
        return this.optimizeMultidexForLinearAlloc;
    }

    public List<AssertionsConfiguration> getAssertionsConfiguration() {
        return Collections.unmodifiableList(this.assertionsConfiguration);
    }

    public Collection<Consumer<Inspector>> getOutputInspections() {
        return Collections.unmodifiableList(this.outputInspections);
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    DumpInputFlags getDumpInputFlags() {
        return this.dumpInputFlags;
    }

    Reporter getReporter() {
        return this.reporter;
    }

    @Keep
    public static abstract class Builder<C extends BaseCompilerCommand, B extends Builder<C, B>>
    extends BaseCommand.Builder<C, B> {
        private ProgramConsumer programConsumer = null;
        private StringConsumer mainDexListConsumer = null;
        private Path outputPath = null;
        private OutputMode outputMode = OutputMode.DexIndexed;
        private CompilationMode mode;
        private int minApiLevel = 0;
        private int threadCount = -1;
        protected InternalOptions.DesugarState desugarState = InternalOptions.DesugarState.ON;
        private List<StringResource> desugaredLibrarySpecificationResources = new ArrayList<StringResource>();
        private boolean includeClassesChecksum = false;
        private boolean lookupLibraryBeforeProgram = true;
        private boolean optimizeMultidexForLinearAlloc = false;
        private BiPredicate<String, Long> dexClassChecksumFilter = (name, checksum) -> true;
        private List<AssertionsConfiguration> assertionsConfiguration = new ArrayList<AssertionsConfiguration>();
        private List<Consumer<Inspector>> outputInspections = new ArrayList<Consumer<Inspector>>();
        protected StringConsumer proguardMapConsumer = null;
        private DumpInputFlags dumpInputFlags = DumpInputFlags.noDump();
        private MapIdProvider mapIdProvider = null;
        private SourceFileProvider sourceFileProvider = null;

        Builder() {
            this.mode = this.defaultCompilationMode();
        }

        Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
            this.mode = this.defaultCompilationMode();
        }

        Builder(AndroidApp app) {
            super(AndroidApp.builder(app));
            this.mode = this.defaultCompilationMode();
        }

        Builder(AndroidApp app, DiagnosticsHandler diagnosticsHandler) {
            super(AndroidApp.builder(app, new Reporter(diagnosticsHandler)));
            this.mode = this.defaultCompilationMode();
        }

        abstract CompilationMode defaultCompilationMode();

        public CompilationMode getMode() {
            return this.mode;
        }

        public B setMode(CompilationMode mode) {
            assert (mode != null);
            this.mode = mode;
            return (B)((Builder)this.self());
        }

        public Path getOutputPath() {
            return this.outputPath;
        }

        public OutputMode getOutputMode() {
            return this.outputMode;
        }

        public ProgramConsumer getProgramConsumer() {
            return this.programConsumer;
        }

        B setProguardMapOutputPath(Path proguardMapOutput) {
            assert (proguardMapOutput != null);
            return this.setProguardMapConsumer(new StringConsumer.FileConsumer(proguardMapOutput));
        }

        B setProguardMapConsumer(StringConsumer proguardMapConsumer) {
            this.proguardMapConsumer = proguardMapConsumer;
            return (B)((Builder)this.self());
        }

        public StringConsumer getMainDexListConsumer() {
            return this.mainDexListConsumer;
        }

        public BiPredicate<String, Long> getDexClassChecksumFilter() {
            return this.dexClassChecksumFilter;
        }

        public B setOptimizeMultidexForLinearAlloc(boolean optimizeMultidexForLinearAlloc) {
            this.optimizeMultidexForLinearAlloc = optimizeMultidexForLinearAlloc;
            return (B)((Builder)this.self());
        }

        protected boolean isOptimizeMultidexForLinearAlloc() {
            return this.optimizeMultidexForLinearAlloc;
        }

        public B setProgramConsumer(ProgramConsumer programConsumer) {
            this.outputPath = null;
            this.outputMode = null;
            this.programConsumer = programConsumer;
            return (B)((Builder)this.self());
        }

        public B setMainDexListOutputPath(Path mainDexListOutputPath) {
            this.mainDexListConsumer = new StringConsumer.FileConsumer(mainDexListOutputPath);
            return (B)((Builder)this.self());
        }

        public B setMainDexListConsumer(StringConsumer mainDexListConsumer) {
            this.mainDexListConsumer = mainDexListConsumer;
            return (B)((Builder)this.self());
        }

        public B setOutput(Path outputPath, OutputMode outputMode) {
            return this.setOutput(outputPath, outputMode, false);
        }

        protected B setOutput(Path outputPath, OutputMode outputMode, boolean includeDataResources) {
            assert (outputPath != null);
            assert (outputMode != null);
            this.outputPath = outputPath;
            this.outputMode = outputMode;
            this.programConsumer = this.createProgramOutputConsumer(outputPath, outputMode, includeDataResources);
            return (B)((Builder)this.self());
        }

        public B setDexClassChecksumFilter(BiPredicate<String, Long> filter) {
            assert (filter != null);
            this.dexClassChecksumFilter = filter;
            return (B)((Builder)this.self());
        }

        protected InternalProgramOutputPathConsumer createProgramOutputConsumer(Path path, OutputMode mode, boolean consumeDataResources) {
            if (mode == OutputMode.DexIndexed) {
                return FileUtils.isArchive(path) ? new DexIndexedConsumer.ArchiveConsumer(path, consumeDataResources) : new DexIndexedConsumer.DirectoryConsumer(path, consumeDataResources);
            }
            if (mode == OutputMode.DexFilePerClass) {
                if (FileUtils.isArchive(path)) {
                    return new DexFilePerClassFileConsumer.ArchiveConsumer(path, consumeDataResources){

                        @Override
                        public boolean combineSyntheticClassesWithPrimaryClass() {
                            return false;
                        }
                    };
                }
                return new DexFilePerClassFileConsumer.DirectoryConsumer(path, consumeDataResources){

                    @Override
                    public boolean combineSyntheticClassesWithPrimaryClass() {
                        return false;
                    }
                };
            }
            if (mode == OutputMode.DexFilePerClassFile) {
                return FileUtils.isArchive(path) ? new DexFilePerClassFileConsumer.ArchiveConsumer(path, consumeDataResources) : new DexFilePerClassFileConsumer.DirectoryConsumer(path, consumeDataResources);
            }
            if (mode == OutputMode.ClassFile) {
                return FileUtils.isArchive(path) ? new ClassFileConsumer.ArchiveConsumer(path, consumeDataResources) : new ClassFileConsumer.DirectoryConsumer(path, consumeDataResources);
            }
            throw new Unreachable("Unexpected output mode: " + (Object)((Object)mode));
        }

        public int getMinApiLevel() {
            return this.isMinApiLevelSet() ? this.minApiLevel : AndroidApiLevel.getDefault().getLevel();
        }

        boolean isMinApiLevelSet() {
            return this.minApiLevel != 0;
        }

        public B setMinApiLevel(int minApiLevel) {
            if (minApiLevel <= 0) {
                this.getReporter().error("Invalid minApiLevel: " + minApiLevel);
            } else {
                this.minApiLevel = minApiLevel;
            }
            return (B)((Builder)this.self());
        }

        @Deprecated
        public B setEnableDesugaring(boolean enableDesugaring) {
            this.desugarState = enableDesugaring ? InternalOptions.DesugarState.ON : InternalOptions.DesugarState.OFF;
            return (B)((Builder)this.self());
        }

        public B setDisableDesugaring(boolean disableDesugaring) {
            this.desugarState = disableDesugaring ? InternalOptions.DesugarState.OFF : InternalOptions.DesugarState.ON;
            return (B)((Builder)this.self());
        }

        public boolean getDisableDesugaring() {
            return this.desugarState == InternalOptions.DesugarState.OFF;
        }

        InternalOptions.DesugarState getDesugaringState() {
            return this.desugarState;
        }

        public B setMapIdProvider(MapIdProvider mapIdProvider) {
            this.mapIdProvider = mapIdProvider;
            return (B)((Builder)this.self());
        }

        public MapIdProvider getMapIdProvider() {
            return this.mapIdProvider;
        }

        public B setSourceFileProvider(SourceFileProvider sourceFileProvider) {
            this.sourceFileProvider = sourceFileProvider;
            return (B)((Builder)this.self());
        }

        public SourceFileProvider getSourceFileProvider() {
            return this.sourceFileProvider;
        }

        @Deprecated
        public B addSpecialLibraryConfiguration(String configuration) {
            return this.addDesugaredLibraryConfiguration(configuration);
        }

        public B addDesugaredLibraryConfiguration(String configuration) {
            this.desugaredLibrarySpecificationResources.add(StringResource.fromString(configuration, Origin.unknown()));
            return (B)((Builder)this.self());
        }

        public B addDesugaredLibraryConfiguration(StringResource configuration) {
            this.desugaredLibrarySpecificationResources.add(configuration);
            return (B)((Builder)this.self());
        }

        DesugaredLibrarySpecification getDesugaredLibraryConfiguration(DexItemFactory factory, boolean libraryCompilation) {
            if (this.desugaredLibrarySpecificationResources.isEmpty()) {
                return HumanDesugaredLibrarySpecification.empty();
            }
            if (this.desugaredLibrarySpecificationResources.size() > 1) {
                throw new CompilationError("Only one desugared library configuration is supported.");
            }
            StringResource desugaredLibrarySpecificationResource = this.desugaredLibrarySpecificationResources.get(0);
            return DesugaredLibrarySpecificationParser.parseDesugaredLibrarySpecification(desugaredLibrarySpecificationResource, factory, this.getReporter(), libraryCompilation, this.getMinApiLevel());
        }

        boolean hasDesugaredLibraryConfiguration() {
            return !this.desugaredLibrarySpecificationResources.isEmpty();
        }

        public B setIncludeClassesChecksum(boolean enabled) {
            this.includeClassesChecksum = enabled;
            return (B)((Builder)this.self());
        }

        B setThreadCount(int threadCount) {
            if (threadCount <= 0) {
                this.getReporter().error("Invalid threadCount: " + threadCount);
            } else {
                this.threadCount = threadCount;
            }
            return (B)((Builder)this.self());
        }

        int getThreadCount() {
            return this.threadCount;
        }

        public boolean getIncludeClassesChecksum() {
            return this.includeClassesChecksum;
        }

        List<AssertionsConfiguration> getAssertionsConfiguration() {
            return this.assertionsConfiguration;
        }

        public B addAssertionsConfiguration(Function<AssertionsConfiguration.Builder, AssertionsConfiguration> assertionsConfigurationGenerator) {
            this.assertionsConfiguration.add(assertionsConfigurationGenerator.apply(AssertionsConfiguration.builder(this.getReporter())));
            return (B)((Builder)this.self());
        }

        B dumpInputToFile(Path file) {
            this.dumpInputFlags = DumpInputFlags.dumpToFile(file);
            return (B)((Builder)this.self());
        }

        B dumpInputToDirectory(Path directory) {
            this.dumpInputFlags = DumpInputFlags.dumpToDirectory(directory);
            return (B)((Builder)this.self());
        }

        DumpInputFlags getDumpInputFlags() {
            return this.dumpInputFlags;
        }

        @Override
        void validate() {
            Reporter reporter = this.getReporter();
            if (this.mode == null) {
                reporter.error("Expected valid compilation mode, was null");
            }
            FileUtils.validateOutputFile(this.outputPath, reporter);
            if (this.getProgramConsumer() == null) {
                reporter.error("A ProgramConsumer or Output is required for compilation");
            }
            ArrayList<Class<ClassFileConsumer>> programConsumerClasses = new ArrayList<Class<ClassFileConsumer>>(3);
            if (this.programConsumer instanceof DexIndexedConsumer) {
                programConsumerClasses.add(DexIndexedConsumer.class);
            }
            if (this.programConsumer instanceof DexFilePerClassFileConsumer) {
                programConsumerClasses.add(DexFilePerClassFileConsumer.class);
            }
            if (this.programConsumer instanceof ClassFileConsumer) {
                programConsumerClasses.add(ClassFileConsumer.class);
            }
            if (programConsumerClasses.size() > 1) {
                StringBuilder builder = new StringBuilder().append("Invalid program consumer.").append(" A program consumer can implement at most one consumer type but ").append(this.programConsumer.getClass().getName()).append(" implements types:");
                for (Class clazz : programConsumerClasses) {
                    builder.append(" ").append(clazz.getName());
                }
                reporter.error(builder.toString());
            }
            if (this.getMinApiLevel() > AndroidApiLevel.LATEST.getLevel() && this.getMinApiLevel() != AndroidApiLevel.ANDROID_PLATFORM.getLevel()) {
                reporter.warning("An API level of " + this.getMinApiLevel() + " is not supported by this compiler. Please use an API level of " + AndroidApiLevel.LATEST.getLevel() + " or earlier");
            }
            super.validate();
        }

        public B addOutputInspection(Consumer<Inspector> inspection) {
            this.outputInspections.add(inspection);
            return (B)((Builder)this.self());
        }

        List<Consumer<Inspector>> getOutputInspections() {
            return this.outputInspections;
        }
    }
}

