/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.GenerateMainDexList;
import com.android.tools.r8.Keep;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.Version;
import com.android.tools.r8.androidapi.ApiReferenceStubber;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.ApplicationWriter;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppServices;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.analysis.ClassInitializerAssertionEnablingAnalysis;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.inspector.internal.InspectorImpl;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.desugar.TypeRewriter;
import com.android.tools.r8.ir.desugar.desugaredlibrary.DesugaredLibraryAmender;
import com.android.tools.r8.ir.optimize.AssertionsRewriter;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import com.android.tools.r8.jar.CfApplicationWriter;
import com.android.tools.r8.kotlin.KotlinMetadataRewriter;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.PrefixRewritingNamingLens;
import com.android.tools.r8.naming.RecordRewritingNamingLens;
import com.android.tools.r8.naming.signature.GenericSignatureRewriter;
import com.android.tools.r8.origin.CommandLineOrigin;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.MainDexInfo;
import com.android.tools.r8.synthesis.SyntheticFinalization;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.AssertionUtils;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

@Keep
public final class D8 {
    private D8() {
    }

    public static void run(D8Command command) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        ExceptionUtils.withD8CompilationHandler(command.getReporter(), () -> {
            try {
                D8.run(app, options, executor);
            }
            finally {
                executor.shutdown();
            }
        });
    }

    public static void run(D8Command command, ExecutorService executor) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        ExceptionUtils.withD8CompilationHandler(command.getReporter(), () -> D8.run(app, options, executor));
    }

    private static void run(String[] args2) throws CompilationFailedException {
        D8Command command = (D8Command)D8Command.parse(args2, CommandLineOrigin.INSTANCE).build();
        if (command.isPrintHelp()) {
            System.out.println(D8Command.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("D8 " + Version.getVersionString());
            return;
        }
        InternalOptions options = command.getInternalOptions();
        AndroidApp app = command.getInputApp();
        D8.runForTesting(app, options);
    }

    public static void main(String[] args2) {
        if (args2.length == 0) {
            throw new RuntimeException(StringUtils.joinLines("Invalid invocation.", D8Command.USAGE_MESSAGE));
        }
        ExceptionUtils.withMainProgramHandler(() -> D8.run(args2));
    }

    static void runForTesting(AndroidApp inputApp, InternalOptions options) throws CompilationFailedException {
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        ExceptionUtils.withD8CompilationHandler(options.reporter, () -> {
            try {
                D8.run(inputApp, options, executor);
            }
            finally {
                executor.shutdown();
            }
        });
    }

    private static AppView<AppInfo> readApp(AndroidApp inputApp, InternalOptions options, ExecutorService executor, Timing timing) throws IOException {
        timing.begin("Application read");
        ApplicationReader applicationReader = new ApplicationReader(inputApp, options, timing);
        LazyLoadedDexApplication app = applicationReader.read(executor);
        timing.end();
        timing.begin("Load desugared lib");
        options.loadMachineDesugaredLibrarySpecification(timing, app);
        timing.end();
        TypeRewriter typeRewriter = options.getTypeRewriter();
        AppInfo appInfo = timing.time("Create app-info", () -> AppInfo.createInitialAppInfo(app, applicationReader.readMainDexClasses(app)));
        return timing.time("Create app-view", () -> AppView.createForD8(appInfo, typeRewriter, timing));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void run(AndroidApp inputApp, InternalOptions options, ExecutorService executor) throws IOException {
        if (options.printMemory) {
            System.gc();
            System.gc();
            Runtime runtime = Runtime.getRuntime();
            System.out.println("D8 is running with total memory:" + runtime.totalMemory());
            System.out.println("D8 is running with free memory:" + runtime.freeMemory());
            System.out.println("D8 is running with max memory:" + runtime.maxMemory());
        }
        Timing timing = Timing.create("D8", options);
        try {
            CfgPrinter printer;
            assert (AssertionUtils.forTesting(options, () -> !options.testing.testEnableTestAssertions));
            timing.begin("Read input app");
            AppView<AppInfo> appView = D8.readApp(inputApp, options, executor, timing);
            timing.end();
            timing.begin("Desugared library amend");
            DesugaredLibraryAmender.run(appView);
            timing.end();
            timing.begin("Collect input synthetics");
            SyntheticItems.collectSyntheticInputs(appView);
            timing.end();
            CfgPrinter cfgPrinter = printer = options.printCfg ? new CfgPrinter() : null;
            if (AssertionsRewriter.isEnabled(options)) {
                ClassInitializerAssertionEnablingAnalysis analysis = new ClassInitializerAssertionEnablingAnalysis(appView, OptimizationFeedbackSimple.getInstance());
                ThreadUtils.processItems(appView.appInfo().classes(), clazz -> {
                    ProgramMethod classInitializer = clazz.getProgramClassInitializer();
                    if (classInitializer != null) {
                        analysis.processNewlyLiveMethod(classInitializer, (ProgramDefinition)clazz, null, null);
                    }
                }, executor);
            }
            if (options.testing.enableD8ResourcesPassThrough) {
                appView.setAppServices(AppServices.builder(appView).build());
            }
            new IRConverter(appView, timing, printer).convert(appView, executor);
            if (options.printCfg) {
                if (options.printCfgFile == null || options.printCfgFile.isEmpty()) {
                    System.out.print(printer.toString());
                } else {
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(options.printCfgFile), StandardCharsets.UTF_8);
                    Throwable throwable = null;
                    try {
                        writer.write(printer.toString());
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            D8.$closeResource(throwable, writer);
                            throw throwable3;
                        }
                    }
                    D8.$closeResource(throwable, writer);
                }
            }
            inputApp.closeInternalArchiveProviders();
            if (options.hasMethodsFilter()) {
                System.out.println("Finished compilation with method filter: ");
                options.methodsFilter.forEach(m3 -> System.out.println("  - " + m3));
            }
            boolean hasClassResources = appView.appInfo().app().getFlags().hasReadProgramClassFromCf();
            boolean hasDexResources = appView.appInfo().app().getFlags().hasReadProgramClassFromDex();
            Marker marker = options.getMarker(Marker.Tool.D8);
            HashSet<Marker> markers = new HashSet<Marker>(appView.dexItemFactory().extractMarkers());
            if (hasClassResources && (options.desugarState != InternalOptions.DesugarState.OFF || markers.isEmpty() || markers.size() == 1 && ((Marker)markers.iterator().next()).isL8())) {
                markers.add(marker);
            }
            Marker.checkCompatibleDesugaredLibrary(markers, options.reporter);
            InspectorImpl.runInspections(options.outputInspections, appView.appInfo().classes());
            NamingLens namingLens = NamingLens.getIdentityLens();
            namingLens = PrefixRewritingNamingLens.createPrefixRewritingNamingLens(appView, namingLens);
            namingLens = RecordRewritingNamingLens.createRecordRewritingNamingLens(appView, namingLens);
            if (options.isGeneratingDex() && hasDexResources && hasClassResources && appView.typeRewriter.isRewriting()) {
                timing.begin("Rewrite non-dex inputs");
                DexApplication app = D8.rewriteNonDexInputs(appView, inputApp, options, executor, timing, appView.appInfo().app(), namingLens);
                timing.end();
                appView.setAppInfo(new AppInfo(appView.appInfo().getSyntheticItems().commit(app), appView.appInfo().getMainDexInfo()));
                namingLens = NamingLens.getIdentityLens();
            } else if (options.isGeneratingDex() && hasDexResources) {
                namingLens = NamingLens.getIdentityLens();
            }
            if (options.isGeneratingDex() && !options.mainDexKeepRules.isEmpty()) {
                appView.dexItemFactory().clearTypeElementsCache();
                MainDexInfo mainDexInfo = new GenerateMainDexList(options).traceMainDex(executor, appView.appInfo().app(), appView.appInfo().getMainDexInfo());
                appView.setAppInfo(appView.appInfo().rebuildWithMainDexInfo(mainDexInfo));
            }
            D8.finalizeApplication(appView, executor);
            HorizontalClassMerger.createForD8ClassMerging(appView).runIfNecessary(executor, timing);
            new GenericSignatureRewriter(appView, namingLens).runForD8(appView.appInfo().classes(), executor);
            new KotlinMetadataRewriter(appView, namingLens).runForD8(executor);
            if (options.isGeneratingClassFiles()) {
                new CfApplicationWriter(appView, marker, namingLens).write(options.getClassFileConsumer(), inputApp);
            } else {
                if (options.apiModelingOptions().enableStubbingOfClasses) {
                    new ApiReferenceStubber(appView).run(executor);
                }
                new ApplicationWriter(appView, marker == null ? null : ImmutableList.copyOf(markers), namingLens).write(executor, inputApp);
            }
            options.printWarnings();
            return;
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.unwrapExecutionException(e);
        }
        finally {
            options.signalFinishedToConsumers();
            if (options.printTimes) {
                timing.report();
            }
        }
    }

    private static void finalizeApplication(AppView<AppInfo> appView, ExecutorService executorService) throws ExecutionException {
        SyntheticFinalization.finalize(appView, executorService);
    }

    private static DexApplication rewriteNonDexInputs(AppView<AppInfo> appView, AndroidApp inputApp, InternalOptions options, ExecutorService executor, Timing timing, DexApplication app, NamingLens desugaringLens) throws IOException, ExecutionException {
        appView.options().reporter.warning(new StringDiagnostic("The compilation is slowed down due to a mix of class file and dex file inputs in the context of desugared library. This can be fixed by pre-compiling to dex the class file inputs and dex merging only dex files."));
        ArrayList<DexProgramClass> dexProgramClasses = new ArrayList<DexProgramClass>();
        ArrayList<DexProgramClass> nonDexProgramClasses = new ArrayList<DexProgramClass>();
        for (DexProgramClass aClass : app.classes()) {
            if (aClass.originatesFromDexResource()) {
                dexProgramClasses.add(aClass);
                continue;
            }
            nonDexProgramClasses.add(aClass);
        }
        DexApplication cfApp = ((DexApplication.Builder)app.builder().replaceProgramClasses(nonDexProgramClasses)).build();
        appView.setAppInfo(new AppInfo(appView.appInfo().getSyntheticItems().commit(cfApp), appView.appInfo().getMainDexInfo()));
        ConvertedCfFiles convertedCfFiles = new ConvertedCfFiles();
        new GenericSignatureRewriter(appView, desugaringLens).run(appView.appInfo().classes(), executor);
        new KotlinMetadataRewriter(appView, desugaringLens).runForD8(executor);
        new ApplicationWriter(appView, null, desugaringLens, convertedCfFiles).write(executor);
        AndroidApp.Builder builder = AndroidApp.builder(inputApp);
        builder.getProgramResourceProviders().clear();
        builder.addProgramResourceProvider(convertedCfFiles);
        AndroidApp newAndroidApp = builder.build();
        LazyLoadedDexApplication newApp = new ApplicationReader(newAndroidApp, options, timing).read(executor);
        DexApplication.Builder<?> finalDexApp = ((DexApplication)newApp).builder();
        for (DexProgramClass dexProgramClass : dexProgramClasses) {
            finalDexApp.addProgramClass(dexProgramClass);
        }
        return finalDexApp.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void optimize(AppView<AppInfo> appView, InternalOptions options, Timing timing, ExecutorService executor) throws IOException, ExecutionException {
        CfgPrinter printer = options.printCfg ? new CfgPrinter() : null;
        new IRConverter(appView, timing, printer).convert(appView, executor);
        if (!options.printCfg) return;
        if (options.printCfgFile == null || options.printCfgFile.isEmpty()) {
            System.out.print(printer.toString());
            return;
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(options.printCfgFile), StandardCharsets.UTF_8);
        Throwable throwable = null;
        try {
            writer.write(printer.toString());
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                D8.$closeResource(throwable, writer);
                throw throwable3;
            }
        }
        D8.$closeResource(throwable, writer);
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    static class ConvertedCfFiles
    implements DexIndexedConsumer,
    ProgramResourceProvider {
        private final List<ProgramResource> resources = new ArrayList<ProgramResource>();

        ConvertedCfFiles() {
        }

        @Override
        public synchronized void accept(int fileIndex, ByteDataView data2, Set<String> descriptors, DiagnosticsHandler handler) {
            this.resources.add(ProgramResource.fromBytes(Origin.unknown(), ProgramResource.Kind.DEX, data2.copyByteData(), descriptors));
        }

        @Override
        public Collection<ProgramResource> getProgramResources() throws ResourceException {
            return this.resources;
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
        }
    }
}

