/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ByteBufferProvider;
import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.DataDirectoryResource;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DataResourceConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.InternalProgramOutputPathConsumer;
import com.android.tools.r8.Keep;
import com.android.tools.r8.KeepForSubclassing;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.Resource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.utils.ArchiveBuilder;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.DirectoryBuilder;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.OutputBuilder;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ZipUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipOutputStream;

@KeepForSubclassing
public interface DexFilePerClassFileConsumer
extends ProgramConsumer,
ByteBufferProvider {
    public static final boolean SHOULD_COMBINE_SYNTHETIC_CLASSES = true;

    public static DexFilePerClassFileConsumer emptyConsumer() {
        return ForwardingConsumer.EMPTY_CONSUMER;
    }

    default public void accept(String primaryClassDescriptor, ByteDataView data2, Set<String> descriptors, DiagnosticsHandler handler) {
        this.accept(primaryClassDescriptor, data2.copyByteData(), descriptors, handler);
    }

    @Deprecated
    default public void accept(String primaryClassDescriptor, byte[] data2, Set<String> descriptors, DiagnosticsHandler handler) {
        handler.error(new StringDiagnostic("Deprecated use of DexFilePerClassFileConsumer::accept(..., byte[], ...)"));
    }

    default public boolean combineSyntheticClassesWithPrimaryClass() {
        return true;
    }

    @Keep
    public static class DirectoryConsumer
    extends ForwardingConsumer
    implements DataResourceConsumer,
    InternalProgramOutputPathConsumer {
        private final OutputBuilder outputBuilder;
        protected final boolean consumeDataResouces;

        private static String getDexFileName(String classDescriptor) {
            assert (classDescriptor != null && DescriptorUtils.isClassDescriptor(classDescriptor));
            return DescriptorUtils.getClassBinaryNameFromDescriptor(classDescriptor) + ".dex";
        }

        public DirectoryConsumer(Path directory) {
            this(directory, null, false);
        }

        public DirectoryConsumer(Path directory, boolean consumeDataResouces) {
            this(directory, null, consumeDataResouces);
        }

        public DirectoryConsumer(Path directory, DexFilePerClassFileConsumer consumer) {
            this(directory, consumer, false);
        }

        public DirectoryConsumer(Path directory, DexFilePerClassFileConsumer consumer, boolean consumeDataResouces) {
            super(consumer);
            this.outputBuilder = new DirectoryBuilder(directory);
            this.consumeDataResouces = consumeDataResouces;
        }

        public static void writeResources(Path directory, List<ProgramResource> resources, Map<Resource, String> primaryClassDescriptors) throws IOException, ResourceException {
            block12: {
                Closer closer;
                block13: {
                    closer = Closer.create();
                    Throwable throwable = null;
                    try {
                        for (ProgramResource resource : resources) {
                            String primaryClassDescriptor = primaryClassDescriptors.get(resource);
                            Path target = DirectoryConsumer.getTargetDexFile(directory, primaryClassDescriptor);
                            DirectoryConsumer.writeFile(ByteStreams.toByteArray(closer.register(resource.getByteStream())), target);
                        }
                        if (closer == null) break block12;
                        if (throwable == null) break block13;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (closer != null) {
                                if (throwable != null) {
                                    try {
                                        closer.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    closer.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                    try {
                        closer.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    break block12;
                }
                closer.close();
            }
        }

        private static Path getTargetDexFile(Path directory, String primaryClassDescriptor) {
            return directory.resolve(ArchiveConsumer.getDexFileName(primaryClassDescriptor));
        }

        private static void writeFile(byte[] contents, Path target) throws IOException {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            FileUtils.writeToFile(target, null, contents);
        }

        @Override
        public void accept(String primaryClassDescriptor, ByteDataView data2, Set<String> descriptors, DiagnosticsHandler handler) {
            super.accept(primaryClassDescriptor, data2, descriptors, handler);
            this.outputBuilder.addFile(DirectoryConsumer.getDexFileName(primaryClassDescriptor), data2, handler);
        }

        @Override
        public void accept(DataDirectoryResource directory, DiagnosticsHandler handler) {
            this.outputBuilder.addDirectory(directory.getName(), handler);
        }

        @Override
        public void accept(DataEntryResource file, DiagnosticsHandler handler) {
            this.outputBuilder.addFile(file.getName(), file, handler);
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
        }

        @Override
        public Path internalGetOutputPath() {
            return this.outputBuilder.getPath();
        }
    }

    @Keep
    public static class ArchiveConsumer
    extends ForwardingConsumer
    implements DataResourceConsumer,
    InternalProgramOutputPathConsumer {
        private final OutputBuilder outputBuilder;
        protected final boolean consumeDataResources;

        private static String getDexFileName(String classDescriptor) {
            assert (classDescriptor != null && DescriptorUtils.isClassDescriptor(classDescriptor));
            return DescriptorUtils.getClassBinaryNameFromDescriptor(classDescriptor) + ".dex";
        }

        public ArchiveConsumer(Path archive) {
            this(archive, null, false);
        }

        public ArchiveConsumer(Path archive, boolean consumeDataResouces) {
            this(archive, null, consumeDataResouces);
        }

        public ArchiveConsumer(Path archive, DexFilePerClassFileConsumer consumer) {
            this(archive, consumer, false);
        }

        public ArchiveConsumer(Path archive, DexFilePerClassFileConsumer consumer, boolean consumeDataResouces) {
            super(consumer);
            this.outputBuilder = new ArchiveBuilder(archive);
            this.consumeDataResources = consumeDataResouces;
            this.outputBuilder.open();
            if (this.getDataResourceConsumer() != null) {
                this.outputBuilder.open();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void writeResources(Path archive, List<ProgramResource> resources, Map<Resource, String> primaryClassDescriptors) throws IOException, ResourceException {
            OpenOption[] options = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
            Closer closer = Closer.create();
            Throwable throwable = null;
            try {
                ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(archive, options)));
                Throwable throwable2 = null;
                try {
                    for (ProgramResource resource : resources) {
                        String primaryClassDescriptor = primaryClassDescriptors.get(resource);
                        String entryName = ArchiveConsumer.getDexFileName(primaryClassDescriptor);
                        byte[] bytes = ByteStreams.toByteArray(closer.register(resource.getByteStream()));
                        ZipUtils.writeToZipStream(out, entryName, bytes, 0);
                    }
                }
                catch (Throwable throwable3) {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        ArchiveConsumer.$closeResource(throwable2, out);
                        throw throwable4;
                    }
                }
                ArchiveConsumer.$closeResource(throwable2, out);
                if (closer == null) return;
            }
            catch (Throwable throwable5) {
                try {
                    throwable = throwable5;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    if (closer == null) throw throwable6;
                    ArchiveConsumer.$closeResource(throwable, closer);
                    throw throwable6;
                }
            }
            ArchiveConsumer.$closeResource(throwable, closer);
        }

        private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
            if (x0 != null) {
                try {
                    x1.close();
                }
                catch (Throwable throwable) {
                    x0.addSuppressed(throwable);
                }
            } else {
                x1.close();
            }
        }

        @Override
        public DataResourceConsumer getDataResourceConsumer() {
            return this.consumeDataResources ? this : null;
        }

        @Override
        public void accept(String primaryClassDescriptor, ByteDataView data2, Set<String> descriptors, DiagnosticsHandler handler) {
            super.accept(primaryClassDescriptor, data2, descriptors, handler);
            this.outputBuilder.addFile(ArchiveConsumer.getDexFileName(primaryClassDescriptor), data2, handler);
        }

        @Override
        public void accept(DataDirectoryResource directory, DiagnosticsHandler handler) {
            this.outputBuilder.addDirectory(directory.getName(), handler);
        }

        @Override
        public void accept(DataEntryResource file, DiagnosticsHandler handler) {
            this.outputBuilder.addFile(file.getName(), file, handler);
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
            this.outputBuilder.close(handler);
        }

        @Override
        public Path internalGetOutputPath() {
            return this.outputBuilder.getPath();
        }
    }

    @Keep
    public static class ForwardingConsumer
    implements DexFilePerClassFileConsumer {
        private static final DexFilePerClassFileConsumer EMPTY_CONSUMER = new ForwardingConsumer(null);
        private final DexFilePerClassFileConsumer consumer;

        public ForwardingConsumer(DexFilePerClassFileConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public DataResourceConsumer getDataResourceConsumer() {
            return this.consumer != null ? this.consumer.getDataResourceConsumer() : null;
        }

        @Override
        public void accept(String primaryClassDescriptor, ByteDataView data2, Set<String> descriptors, DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.accept(primaryClassDescriptor, data2, descriptors, handler);
            }
        }

        @Override
        public boolean combineSyntheticClassesWithPrimaryClass() {
            if (this.consumer == null) {
                return true;
            }
            return this.consumer.combineSyntheticClassesWithPrimaryClass();
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.finished(handler);
            }
        }
    }
}

