/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.dex.DexParser;
import com.android.tools.r8.dex.DexSection;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceLinkedOpenHashMap;
import com.android.tools.r8.origin.CommandLineOrigin;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Map;

public class DexSegments {
    public static void main(String[] args2) throws IOException, CompilationFailedException, ResourceException {
        Command.Builder builder = Command.parse(args2);
        Map<Integer, SegmentInfo> result = DexSegments.run((Command)builder.build());
        if (result == null) {
            return;
        }
        System.out.println("Segments in dex application (name: size / items):");
        result.forEach((key, value) -> System.out.println(" - " + DexSection.typeName(key) + ": " + ((SegmentInfo)value).size + " / " + ((SegmentInfo)value).items));
    }

    public static Map<Integer, SegmentInfo> run(Command command) throws CompilationFailedException, IOException, ResourceException {
        Int2ReferenceLinkedOpenHashMap<SegmentInfo> result;
        block15: {
            Closer closer;
            block16: {
                int[] benchmarks;
                if (command.isPrintHelp()) {
                    System.out.println(Command.USAGE_MESSAGE);
                    return null;
                }
                AndroidApp app = command.getInputApp();
                result = new Int2ReferenceLinkedOpenHashMap<SegmentInfo>();
                for (int benchmark : benchmarks = new int[]{8197, 0, 8195, 4, 4098, 1, 4096, 3, 5, 2, 8194, 8192, 4097, 8198, 8196, 4099, 6}) {
                    result.computeIfAbsent(benchmark, key -> new SegmentInfo());
                }
                closer = Closer.create();
                Throwable throwable = null;
                try {
                    for (ProgramResource resource : app.computeAllProgramResources()) {
                        if (resource.getKind() != ProgramResource.Kind.DEX) continue;
                        for (DexSection dexSection : DexParser.parseMapFrom(closer.register(resource.getByteStream()), resource.getOrigin())) {
                            SegmentInfo info = result.computeIfAbsent(dexSection.type, key -> new SegmentInfo());
                            info.increment(dexSection.length, dexSection.size());
                        }
                    }
                    if (closer == null) break block15;
                    if (throwable == null) break block16;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (closer != null) {
                            if (throwable != null) {
                                try {
                                    closer.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                closer.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                try {
                    closer.close();
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                break block15;
            }
            closer.close();
        }
        return result;
    }

    public static class SegmentInfo {
        private int items = 0;
        private int size = 0;

        SegmentInfo() {
        }

        void increment(int items, int size) {
            this.items += items;
            this.size += size;
        }

        public int getItemCount() {
            return this.items;
        }

        public int getSegmentSize() {
            return this.size;
        }
    }

    public static class Command
    extends BaseCommand {
        static final String USAGE_MESSAGE = String.join((CharSequence)"\n", ImmutableList.of("Usage: dexsegments [options] <input-files>", " where <input-files> are dex files", "  --version               # Print the version of r8.", "  --help                  # Print this message."));

        public static Builder builder() {
            return new Builder();
        }

        public static Builder parse(String[] args2) {
            Builder builder = Command.builder();
            Command.parse(args2, builder);
            return builder;
        }

        private static void parse(String[] args2, Builder builder) {
            for (int i = 0; i < args2.length; ++i) {
                String arg = args2[i].trim();
                if (arg.length() == 0) continue;
                if (arg.equals("--help")) {
                    builder.setPrintHelp(true);
                    continue;
                }
                if (arg.startsWith("--")) {
                    builder.getReporter().error(new StringDiagnostic("Unknown option: " + arg, CommandLineOrigin.INSTANCE));
                }
                builder.addProgramFiles(Paths.get(arg, new String[0]));
            }
        }

        private Command(AndroidApp inputApp) {
            super(inputApp);
        }

        private Command(boolean printHelp) {
            super(printHelp, false);
        }

        @Override
        InternalOptions getInternalOptions() {
            return new InternalOptions();
        }

        public static class Builder
        extends BaseCommand.Builder<Command, Builder> {
            @Override
            Builder self() {
                return this;
            }

            @Override
            protected Command makeCommand() {
                if (this.isPrintHelp()) {
                    return new Command(this.isPrintHelp());
                }
                return new Command(this.getAppBuilder().build());
            }
        }
    }
}

