/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.Keep;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.ApplicationWriter;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.MainDexInfo;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.FeatureClassMapping;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

@Keep
public final class DexSplitterHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(D8Command command, FeatureClassMapping featureClassMapping, String output, String proguardMap) throws CompilationFailedException {
        ExecutorService executor = ThreadUtils.getExecutorService(-1);
        try {
            ExceptionUtils.withCompilationHandler(command.getReporter(), () -> DexSplitterHelper.run(command, featureClassMapping, output, proguardMap, executor));
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(D8Command command, FeatureClassMapping featureClassMapping, String output, String proguardMap, ExecutorService executor) throws IOException {
        InternalOptions options = command.getInternalOptions();
        options.desugarState = InternalOptions.DesugarState.OFF;
        options.enableMainDexListCheck = false;
        options.ignoreMainDexMissingClasses = true;
        options.minimalMainDex = false;
        assert (!options.isMinifying());
        options.inlinerOptions().enableInlining = false;
        options.outline.enabled = false;
        try {
            Timing timing = new Timing("DexSplitter");
            ApplicationReader applicationReader = new ApplicationReader(command.getInputApp(), options, timing);
            LazyLoadedDexApplication app = applicationReader.read(executor);
            MainDexInfo mainDexInfo = applicationReader.readMainDexClasses(app);
            List<Marker> markers = app.dexItemFactory.extractMarkers();
            ClassNameMapper mapper = null;
            if (proguardMap != null) {
                mapper = ClassNameMapper.mapperFromFile(Paths.get(proguardMap, new String[0]));
            }
            Map<String, LazyLoadedDexApplication.Builder> applications = DexSplitterHelper.getDistribution(app, featureClassMapping, mapper);
            for (Map.Entry<String, LazyLoadedDexApplication.Builder> entry : applications.entrySet()) {
                String feature = entry.getKey();
                timing.begin("Feature " + feature);
                LazyLoadedDexApplication featureApp = entry.getValue().build();
                assert (!options.hasMethodsFilter());
                AppInfo appInfo = feature.equals(featureClassMapping.getBaseName()) ? AppInfo.createInitialAppInfo(featureApp, mainDexInfo) : AppInfo.createInitialAppInfo(featureApp);
                AppView<AppInfo> appView = AppView.createForD8(appInfo);
                D8.optimize(appView, options, timing, executor);
                Path outputDir = Paths.get(output, new String[0]).resolve(entry.getKey());
                if (!Files.exists(outputDir, new LinkOption[0])) {
                    Files.createDirectory(outputDir, new FileAttribute[0]);
                }
                DexIndexedConsumer.DirectoryConsumer consumer = new DexIndexedConsumer.DirectoryConsumer(outputDir);
                try {
                    new ApplicationWriter(appView, markers, NamingLens.getIdentityLens(), consumer).write(executor);
                    options.printWarnings();
                }
                finally {
                    consumer.finished(options.reporter);
                }
                timing.end();
            }
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.unwrapExecutionException(e);
        }
        catch (FeatureClassMapping.FeatureMappingException e) {
            options.reporter.error(e.getMessage());
        }
        finally {
            options.signalFinishedToConsumers();
        }
    }

    private static Map<String, LazyLoadedDexApplication.Builder> getDistribution(DexApplication app, FeatureClassMapping featureClassMapping, ClassNameMapper mapper) throws FeatureClassMapping.FeatureMappingException {
        HashMap<String, LazyLoadedDexApplication.Builder> applications = new HashMap<String, LazyLoadedDexApplication.Builder>();
        for (DexProgramClass clazz : app.classes()) {
            String clazzName = mapper != null ? mapper.deobfuscateClassName(clazz.toString()) : clazz.toString();
            String feature = featureClassMapping.featureForClass(clazzName);
            LazyLoadedDexApplication.Builder featureApplication = (LazyLoadedDexApplication.Builder)applications.get(feature);
            if (featureApplication == null) {
                featureApplication = DexApplication.builder(app.options, app.timing);
                applications.put(feature, featureApplication);
            }
            featureApplication.addProgramClass(clazz);
        }
        return applications;
    }

    public static void runD8ForTesting(D8Command command, boolean dontCreateMarkerInD8) throws CompilationFailedException {
        InternalOptions options = command.getInternalOptions();
        options.testing.dontCreateMarkerInD8 = dontCreateMarkerInD8;
        D8.runForTesting(command.getInputApp(), options);
    }
}

