/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.StringResource;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.graph.AssemblyWriter;
import com.android.tools.r8.graph.DexByteCodeWriter;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.graph.SmaliWriter;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.origin.CommandLineOrigin;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.ConsumerUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class Disassemble {
    public static void main(String[] args2) throws IOException, ExecutionException, CompilationFailedException {
        DisassembleCommand.Builder builder = DisassembleCommand.parse(args2);
        DisassembleCommand command = (DisassembleCommand)builder.build();
        if (command.isPrintHelp()) {
            System.out.println("Usage: disasm [options] <input-files>\n where <input-files> are dex files\n and options are:\n  --all                       # Include all information in disassembly.\n  --smali                     # Disassemble using smali syntax.\n  --ir                        # Print IR before and after optimization.\n  --nocode                    # No printing of code objects.\n  --pg-map <file>             # Proguard map <file> for mapping names.\n  --pg-map-charset <charset>  # Charset for Proguard map file.\n  --output                    # Specify a file or directory to write to.\n  --version                   # Print the version of r8.\n  --help                      # Print this message.");
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("Disassemble (R8) main");
            return;
        }
        Disassemble.disassemble(command);
    }

    public static void disassemble(DisassembleCommand command) throws IOException, ExecutionException {
        block14: {
            AndroidApp app = command.getInputApp();
            InternalOptions options = command.getInternalOptions();
            try {
                OutputWriter outputWriter;
                block15: {
                    outputWriter = Disassemble.getOutputWriter(command);
                    Throwable throwable = null;
                    try {
                        for (ProgramResource computeAllProgramResource : app.computeAllProgramResources()) {
                            Disassemble.disassembleResource(command, outputWriter, computeAllProgramResource, options);
                        }
                        if (outputWriter == null) break block14;
                        if (throwable == null) break block15;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (outputWriter != null) {
                                if (throwable != null) {
                                    try {
                                        outputWriter.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    outputWriter.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                    try {
                        outputWriter.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    break block14;
                }
                outputWriter.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static OutputWriter getOutputWriter(DisassembleCommand command) throws Exception {
        if (command.getOutputPath() == null) {
            return SystemOutOutputWriter.create();
        }
        if (Files.isDirectory(command.getOutputPath(), new LinkOption[0])) {
            return DirectoryWriter.create(command.getOutputPath(), command.useSmali() ? SmaliWriter.getFileEnding() : AssemblyWriter.getFileEnding());
        }
        return FileWriter.create(command.getOutputPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void disassembleResource(DisassembleCommand command, OutputWriter outputWriter, ProgramResource programResource, InternalOptions options) throws IOException {
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        try {
            DexByteCodeWriter writer;
            LazyLoadedDexApplication application = new ApplicationReader(AndroidApp.builder().addProgramResourceProvider(() -> Collections.singletonList(programResource)).build(), options, Timing.empty()).read(command.proguardMap, executor);
            DexByteCodeWriter dexByteCodeWriter = command.useSmali() ? new SmaliWriter(application, options) : (writer = new AssemblyWriter(application, options, command.allInfo, command.useIr(), !command.noCode()));
            if (outputWriter.extractMarkers()) {
                writer.writeMarkers(outputWriter.outputStreamProvider(application.getProguardMap()).get(null));
            }
            writer.write(outputWriter.outputStreamProvider(application.getProguardMap()), outputWriter.closer());
        }
        finally {
            executor.shutdown();
        }
    }

    private static class FileWriter
    implements OutputWriter {
        private final PrintStream fileStream;

        private FileWriter(PrintStream fileStream) {
            this.fileStream = fileStream;
        }

        private static FileWriter create(Path path) throws IOException {
            Path parent = path.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            return new FileWriter(new PrintStream(Files.newOutputStream(path, new OpenOption[0])));
        }

        @Override
        public boolean extractMarkers() {
            return true;
        }

        @Override
        public DexByteCodeWriter.OutputStreamProvider outputStreamProvider(ClassNameMapper classNameMapper) {
            return clazz -> this.fileStream;
        }

        @Override
        public Consumer<PrintStream> closer() {
            return ConsumerUtils.emptyConsumer();
        }

        @Override
        public void close() throws IOException {
            this.fileStream.flush();
            this.fileStream.close();
        }
    }

    private static class DirectoryWriter
    implements OutputWriter {
        private final Path parent;
        private final String fileEnding;

        public DirectoryWriter(Path parent, String fileEnding) {
            this.parent = parent;
            this.fileEnding = fileEnding;
        }

        private static DirectoryWriter create(Path path, String fileEnding) throws IOException {
            Path parent = path.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            return new DirectoryWriter(path, fileEnding);
        }

        @Override
        public boolean extractMarkers() {
            return false;
        }

        @Override
        public DexByteCodeWriter.OutputStreamProvider outputStreamProvider(ClassNameMapper classNameMapper) {
            return DexByteCodeWriter.oneFilePerClass(classNameMapper, this.parent, this.fileEnding);
        }

        @Override
        public Consumer<PrintStream> closer() {
            return PrintStream::close;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class SystemOutOutputWriter
    implements OutputWriter {
        private SystemOutOutputWriter() {
        }

        static SystemOutOutputWriter create() {
            return new SystemOutOutputWriter();
        }

        @Override
        public boolean extractMarkers() {
            return true;
        }

        @Override
        public DexByteCodeWriter.OutputStreamProvider outputStreamProvider(ClassNameMapper classNameMapper) {
            return clazz -> System.out;
        }

        @Override
        public Consumer<PrintStream> closer() {
            return ConsumerUtils.emptyConsumer();
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static interface OutputWriter
    extends Closeable {
        public boolean extractMarkers();

        public DexByteCodeWriter.OutputStreamProvider outputStreamProvider(ClassNameMapper var1);

        public Consumer<PrintStream> closer();
    }

    public static class DisassembleCommand
    extends BaseCommand {
        static final String USAGE_MESSAGE = "Usage: disasm [options] <input-files>\n where <input-files> are dex files\n and options are:\n  --all                       # Include all information in disassembly.\n  --smali                     # Disassemble using smali syntax.\n  --ir                        # Print IR before and after optimization.\n  --nocode                    # No printing of code objects.\n  --pg-map <file>             # Proguard map <file> for mapping names.\n  --pg-map-charset <charset>  # Charset for Proguard map file.\n  --output                    # Specify a file or directory to write to.\n  --version                   # Print the version of r8.\n  --help                      # Print this message.";
        private final Path outputPath;
        private final StringResource proguardMap;
        private final boolean allInfo;
        private final boolean useSmali;
        private final boolean useIr;
        private final boolean noCode;

        public static Builder builder() {
            return new Builder();
        }

        public static Builder parse(String[] args2) {
            Builder builder = DisassembleCommand.builder();
            DisassembleCommand.parse(args2, builder);
            return builder;
        }

        private static void parse(String[] args2, Builder builder) {
            for (int i = 0; i < args2.length; ++i) {
                String arg = args2[i].trim();
                if (arg.length() == 0) continue;
                if (arg.equals("--help")) {
                    builder.setPrintHelp(true);
                    continue;
                }
                if (arg.equals("--version")) {
                    builder.setPrintVersion(true);
                    continue;
                }
                if (arg.equals("--all")) {
                    builder.setAllInfo(true);
                    continue;
                }
                if (arg.equals("--smali")) {
                    builder.setUseSmali(true);
                    continue;
                }
                if (arg.equals("--ir")) {
                    builder.setUseIr(true);
                    continue;
                }
                if (arg.equals("--nocode")) {
                    builder.setNoCode(true);
                    continue;
                }
                if (arg.equals("--pg-map")) {
                    builder.setProguardMapFile(Paths.get(args2[++i], new String[0]));
                    continue;
                }
                if (arg.equals("--pg-map-charset")) {
                    String charset = args2[++i];
                    try {
                        Charset.forName(charset);
                    }
                    catch (UnsupportedCharsetException e) {
                        builder.getReporter().error(new StringDiagnostic("Unsupported charset: " + charset + "." + System.lineSeparator() + "Supported charsets are: " + String.join((CharSequence)", ", Charset.availableCharsets().keySet()), CommandLineOrigin.INSTANCE));
                    }
                    continue;
                }
                if (arg.equals("--output")) {
                    String outputPath = args2[++i];
                    builder.setOutputPath(Paths.get(outputPath, new String[0]));
                    continue;
                }
                if (arg.startsWith("--")) {
                    builder.getReporter().error(new StringDiagnostic("Unknown option: " + arg, CommandLineOrigin.INSTANCE));
                }
                builder.addProgramFiles(Paths.get(arg, new String[0]));
            }
        }

        private DisassembleCommand(AndroidApp inputApp, Path outputPath, StringResource proguardMap, boolean allInfo, boolean useSmali, boolean useIr, boolean noCode) {
            super(inputApp);
            this.outputPath = outputPath;
            this.proguardMap = proguardMap;
            this.allInfo = allInfo;
            this.useSmali = useSmali;
            this.useIr = useIr;
            this.noCode = noCode;
        }

        private DisassembleCommand(boolean printHelp, boolean printVersion) {
            super(printHelp, printVersion);
            this.outputPath = null;
            this.proguardMap = null;
            this.allInfo = false;
            this.useSmali = false;
            this.useIr = false;
            this.noCode = false;
        }

        public Path getOutputPath() {
            return this.outputPath;
        }

        public boolean useSmali() {
            return this.useSmali;
        }

        public boolean useIr() {
            return this.useIr;
        }

        public boolean noCode() {
            return this.noCode;
        }

        @Override
        InternalOptions getInternalOptions() {
            InternalOptions internal = new InternalOptions();
            internal.useSmaliSyntax = this.useSmali;
            internal.readDebugSetFileEvent = true;
            return internal;
        }

        public static class Builder
        extends BaseCommand.Builder<DisassembleCommand, Builder> {
            private Path outputPath = null;
            private Path proguardMapFile = null;
            private boolean useSmali = false;
            private boolean allInfo = false;
            private boolean noCode = false;
            private boolean useIr;

            @Override
            Builder self() {
                return this;
            }

            public Builder setProguardMapFile(Path path) {
                this.proguardMapFile = path;
                return this;
            }

            public Path getOutputPath() {
                return this.outputPath;
            }

            public Builder setOutputPath(Path outputPath) {
                this.outputPath = outputPath;
                return this;
            }

            public Builder setAllInfo(boolean allInfo) {
                this.allInfo = allInfo;
                return this;
            }

            public Builder setUseSmali(boolean useSmali) {
                this.useSmali = useSmali;
                return this;
            }

            public Builder setUseIr(boolean useIr) {
                this.useIr = useIr;
                return this;
            }

            public Builder setNoCode(boolean noCode) {
                this.noCode = noCode;
                return this;
            }

            @Override
            protected DisassembleCommand makeCommand() {
                if (this.isPrintHelp() || this.isPrintVersion()) {
                    return new DisassembleCommand(this.isPrintHelp(), this.isPrintVersion());
                }
                return new DisassembleCommand(this.getAppBuilder().build(), this.getOutputPath(), this.proguardMapFile == null ? null : StringResource.fromFile(this.proguardMapFile), this.allInfo, this.useSmali, this.useIr, this.noCode);
            }
        }
    }
}

