/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ExtractMarkerCommand;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.dex.VDexParser;
import com.android.tools.r8.dex.VDexReader;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.concurrent.ExecutionException;

public class ExtractMarker {
    public static Collection<Marker> extractMarkerFromDexFile(Path file) throws IOException, ExecutionException, ResourceException {
        AndroidApp.Builder appBuilder = AndroidApp.builder();
        ExtractMarker.addDexResources(appBuilder, file);
        return ExtractMarker.extractMarker(appBuilder.build());
    }

    public static Collection<Marker> extractMarkerFromJarFile(Path file) throws IOException, ExecutionException {
        return ExtractMarker.extractMarker(AndroidApp.builder().addProgramFile(file).build());
    }

    public static int extractDexSize(Path file) throws IOException, ResourceException {
        AndroidApp.Builder appBuilder = AndroidApp.builder();
        ExtractMarker.addDexResources(appBuilder, file);
        int size = 0;
        for (ProgramResource resource : appBuilder.build().computeAllProgramResources()) {
            if (resource.getKind() != ProgramResource.Kind.DEX) continue;
            InputStream input = resource.getByteStream();
            Throwable throwable = null;
            try {
                size += ByteStreams.toByteArray(input).length;
                if (input == null) continue;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (input != null) {
                        ExtractMarker.$closeResource(throwable, input);
                    }
                    throw throwable3;
                }
            }
            ExtractMarker.$closeResource(throwable, input);
        }
        return size;
    }

    public static Collection<Marker> extractMarkerFromDexProgramData(byte[] data2) throws IOException, ExecutionException {
        AndroidApp app = AndroidApp.builder().addDexProgramData(data2, Origin.unknown()).build();
        return ExtractMarker.extractMarker(app);
    }

    public static Collection<Marker> extractMarkerFromClassProgramData(byte[] data2) throws IOException, ExecutionException {
        AndroidApp app = AndroidApp.builder().addClassProgramData(data2, Origin.unknown()).build();
        return ExtractMarker.extractMarker(app);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addDexResources(AndroidApp.Builder appBuilder, Path file) throws IOException, ResourceException {
        if (FileUtils.isVDexFile(file)) {
            PathOrigin vdexOrigin = new PathOrigin(file);
            InputStream fileInputStream = Files.newInputStream(file, new OpenOption[0]);
            Throwable throwable = null;
            try {
                VDexReader vdexReader = new VDexReader((Origin)vdexOrigin, fileInputStream);
                VDexParser vDexParser = new VDexParser(vdexReader);
                int index = 0;
                for (byte[] bytes : vDexParser.getDexFiles()) {
                    appBuilder.addDexProgramData(bytes, new VdexOrigin(vdexOrigin, index));
                    ++index;
                }
                if (fileInputStream == null) return;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (fileInputStream == null) throw throwable3;
                    ExtractMarker.$closeResource(throwable, fileInputStream);
                    throw throwable3;
                }
            }
            ExtractMarker.$closeResource(throwable, fileInputStream);
            return;
        }
        appBuilder.addProgramFiles(file);
    }

    private static Collection<Marker> extractMarker(AndroidApp app) throws IOException {
        InternalOptions options = new InternalOptions();
        options.skipReadingDexCode = true;
        options.setMinApiLevel(AndroidApiLevel.P);
        LazyLoadedDexApplication dexApp = new ApplicationReader(app, options, new Timing("ExtractMarker")).read();
        return dexApp.dexItemFactory.extractMarkers();
    }

    public static void main(String[] args2) throws IOException, ExecutionException, ResourceException {
        ExtractMarkerCommand.Builder builder = ExtractMarkerCommand.parse(args2);
        ExtractMarkerCommand command = builder.build();
        if (command.isPrintHelp()) {
            System.out.println(ExtractMarkerCommand.USAGE_MESSAGE);
            return;
        }
        Path cwd = Paths.get(System.getProperty("user.dir"), new String[0]);
        int d8Count = 0;
        int r8Count = 0;
        int otherCount = 0;
        for (Path programFile : command.getProgramFiles()) {
            Collection<Marker> markers;
            try {
                markers = ExtractMarker.extractMarkerFromDexFile(programFile);
            }
            catch (CompilationError e) {
                System.out.println("Failed to read dex/vdex file `" + programFile + "`: '" + e.getMessage() + "'");
                continue;
            }
            System.out.print("In file: " + cwd.toAbsolutePath().relativize(programFile.toAbsolutePath()));
            System.out.println(", " + ExtractMarker.extractDexSize(programFile) + " bytes:");
            for (Marker marker : markers) {
                if (marker == null) {
                    ++otherCount;
                    if (!command.getIncludeOther()) {
                        continue;
                    }
                } else if (marker.isD8()) {
                    ++d8Count;
                } else {
                    ++r8Count;
                }
                if (command.getCSV()) {
                    System.out.print("\"" + programFile + "\"");
                    System.out.print(", ");
                    if (marker == null) {
                        System.out.print("\"no marker\"");
                    } else {
                        System.out.print("\"" + (marker.isD8() ? "D8" : "R8") + "\"");
                    }
                    System.out.print(", ");
                    System.out.print(ExtractMarker.extractDexSize(programFile));
                } else {
                    if (command.getVerbose()) {
                        System.out.print(programFile);
                        System.out.print(": ");
                    }
                    System.out.print(marker == null ? "D8/R8 marker not found" : marker);
                }
                System.out.println();
            }
        }
        if (command.getSummary()) {
            System.out.println("D8: " + d8Count);
            System.out.println("R8: " + r8Count);
            System.out.println("Other: " + otherCount);
            System.out.println("Total: " + (d8Count + r8Count + otherCount));
        }
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    public static class VdexOrigin
    extends Origin {
        private final int index;

        public VdexOrigin(Origin vdexOrigin, int index) {
            super(vdexOrigin);
            this.index = index;
        }

        @Override
        public String part() {
            return Integer.toString(this.index);
        }
    }
}

