/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.Keep;
import com.android.tools.r8.L8Command;
import com.android.tools.r8.R8;
import com.android.tools.r8.R8Command;
import com.android.tools.r8.Version;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.desugar.TypeRewriter;
import com.android.tools.r8.ir.desugar.desugaredlibrary.DesugaredLibraryAmender;
import com.android.tools.r8.jar.CfApplicationWriter;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.PrefixRewritingNamingLens;
import com.android.tools.r8.naming.signature.GenericSignatureRewriter;
import com.android.tools.r8.origin.CommandLineOrigin;
import com.android.tools.r8.shaking.AnnotationRemover;
import com.android.tools.r8.shaking.L8TreePruner;
import com.android.tools.r8.synthesis.SyntheticFinalization;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.SelfRetraceTest;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

@Keep
public class L8 {
    public static void run(L8Command command) throws CompilationFailedException {
        L8.runForTesting(command.getInputApp(), command.getInternalOptions(), command.isShrinking(), command.getD8Command(), command.getR8Command());
    }

    public static void run(L8Command command, ExecutorService executor) throws CompilationFailedException {
        L8.run(command.getInputApp(), command.getInternalOptions(), command.isShrinking(), command.getD8Command(), command.getR8Command(), executor);
    }

    static void runForTesting(AndroidApp app, InternalOptions options, boolean shrink, D8Command d8Command, R8Command r8Command) throws CompilationFailedException {
        ExecutorService executorService = ThreadUtils.getExecutorService(options);
        L8.run(app, options, shrink, d8Command, r8Command, executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(AndroidApp app, InternalOptions options, boolean shrink, D8Command d8Command, R8Command r8Command, ExecutorService executorService) throws CompilationFailedException {
        try {
            assert (!options.cfToCfDesugar);
            ExceptionUtils.withD8CompilationHandler(options.reporter, () -> {
                options.cfToCfDesugar = true;
                assert (!options.forceAnnotateSynthetics);
                options.forceAnnotateSynthetics = true;
                assert (options.enableSwitchRewriting);
                options.enableSwitchRewriting = false;
                assert (options.enableStringSwitchConversion);
                options.enableStringSwitchConversion = false;
                L8.desugar(app, options, executorService);
                options.cfToCfDesugar = false;
                options.forceAnnotateSynthetics = false;
                options.enableSwitchRewriting = true;
                options.enableStringSwitchConversion = true;
            });
            assert (!options.cfToCfDesugar);
            if (shrink) {
                R8.run(r8Command, executorService);
            } else if (d8Command != null) {
                D8.run(d8Command, executorService);
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    private static void desugar(AndroidApp inputApp, InternalOptions options, ExecutorService executor) throws IOException {
        Timing timing = Timing.create("L8 desugaring", options);
        assert (options.cfToCfDesugar);
        try {
            options.enableLoadStoreOptimization = false;
            AppView<AppInfo> appView = L8.readApp(inputApp, options, executor, timing);
            DesugaredLibraryAmender.run(appView);
            if (!options.disableL8AnnotationRemoval) {
                AnnotationRemover.clearAnnotations(appView);
            }
            new IRConverter(appView, timing).convert(appView, executor);
            SyntheticFinalization.finalize(appView, executor);
            NamingLens namingLens = PrefixRewritingNamingLens.createPrefixRewritingNamingLens(appView);
            new GenericSignatureRewriter(appView, namingLens).run(appView.appInfo().classes(), executor);
            new CfApplicationWriter(appView, options.getMarker(Marker.Tool.L8), namingLens).write(options.getClassFileConsumer());
            options.printWarnings();
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.unwrapExecutionException(e);
        }
        finally {
            options.signalFinishedToConsumers();
            if (options.printTimes) {
                timing.report();
            }
        }
    }

    private static AppView<AppInfo> readApp(AndroidApp inputApp, InternalOptions options, ExecutorService executor, Timing timing) throws IOException {
        LazyLoadedDexApplication lazyApp = new ApplicationReader(inputApp, options, timing).read(executor);
        options.loadMachineDesugaredLibrarySpecification(timing, lazyApp);
        TypeRewriter typeRewriter = options.getTypeRewriter();
        DexApplication app = new L8TreePruner(options).prune(lazyApp, typeRewriter);
        return AppView.createForL8(AppInfo.createInitialAppInfo(app), typeRewriter);
    }

    private static void run(String[] args2) throws CompilationFailedException {
        L8Command command = (L8Command)L8Command.parse(args2, CommandLineOrigin.INSTANCE).build();
        if (command.isPrintHelp()) {
            SelfRetraceTest.test();
            System.out.println(L8Command.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("L8 " + Version.getVersionString());
            return;
        }
        L8.run(command);
    }

    public static void main(String[] args2) {
        if (args2.length == 0) {
            throw new RuntimeException(StringUtils.joinLines("Invalid invocation.", L8Command.USAGE_MESSAGE));
        }
        ExceptionUtils.withMainProgramHandler(() -> L8.run(args2));
    }
}

