/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.AssertionsConfiguration;
import com.android.tools.r8.BaseCompilerCommand;
import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.Keep;
import com.android.tools.r8.L8CommandParser;
import com.android.tools.r8.MapIdProvider;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.R8Command;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.dump.DumpOptions;
import com.android.tools.r8.errors.DexFileOverflowDiagnostic;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.inspector.Inspector;
import com.android.tools.r8.ir.desugar.desugaredlibrary.DesugaredLibrarySpecification;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.AssertionConfigurationWithDefault;
import com.android.tools.r8.utils.DumpInputFlags;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Pair;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

@Keep
public final class L8Command
extends BaseCompilerCommand {
    static final String USAGE_MESSAGE = L8CommandParser.USAGE_MESSAGE;
    private final D8Command d8Command;
    private final R8Command r8Command;
    private final DesugaredLibrarySpecification desugaredLibrarySpecification;
    private final DexItemFactory factory;

    public static Builder parse(String[] args2, Origin origin) {
        return L8CommandParser.parse(args2, origin);
    }

    public static Builder parse(String[] args2, Origin origin, DiagnosticsHandler handler) {
        return L8CommandParser.parse(args2, origin, handler);
    }

    private L8Command(R8Command r8Command, D8Command d8Command, AndroidApp inputApp, CompilationMode mode, ProgramConsumer programConsumer, StringConsumer mainDexListConsumer, int minApiLevel, Reporter diagnosticsHandler, boolean encodeChecksum, BiPredicate<String, Long> dexClassChecksumFilter, DesugaredLibrarySpecification desugaredLibrarySpecification, List<AssertionsConfiguration> assertionsConfiguration, List<Consumer<Inspector>> outputInspections, int threadCount, DumpInputFlags dumpInputFlags, MapIdProvider mapIdProvider, DexItemFactory factory) {
        super(inputApp, mode, programConsumer, mainDexListConsumer, minApiLevel, diagnosticsHandler, InternalOptions.DesugarState.ON, false, encodeChecksum, dexClassChecksumFilter, assertionsConfiguration, outputInspections, threadCount, dumpInputFlags, mapIdProvider, null);
        this.d8Command = d8Command;
        this.r8Command = r8Command;
        this.desugaredLibrarySpecification = desugaredLibrarySpecification;
        this.factory = factory;
    }

    private L8Command(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
        this.r8Command = null;
        this.d8Command = null;
        this.desugaredLibrarySpecification = null;
        this.factory = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    private DumpOptions dumpOptions() {
        DumpOptions.Builder builder = DumpOptions.builder(Marker.Tool.L8).readCurrentSystemProperties();
        this.dumpBaseCommandOptions(builder);
        if (this.r8Command != null) {
            builder.setProguardConfiguration(this.r8Command.getInternalOptions().getProguardConfiguration());
        }
        return builder.setDesugaredLibraryConfiguration(this.desugaredLibrarySpecification).build();
    }

    boolean isShrinking() {
        return this.r8Command != null;
    }

    D8Command getD8Command() {
        return this.d8Command;
    }

    R8Command getR8Command() {
        return this.r8Command;
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internal = new InternalOptions(this.factory, this.getReporter());
        assert (!internal.debug);
        boolean bl = internal.debug = this.getMode() == CompilationMode.DEBUG;
        assert (internal.mainDexListConsumer == null);
        assert (!internal.minimalMainDex);
        internal.setMinApiLevel(AndroidApiLevel.getAndroidApiLevel(this.getMinApiLevel()));
        assert (!internal.intermediate);
        assert (internal.retainCompileTimeAnnotations);
        internal.programConsumer = this.getProgramConsumer();
        assert (internal.programConsumer instanceof ClassFileConsumer);
        assert (!internal.isShrinking());
        assert (!internal.isMinifying());
        assert (!internal.passthroughDexCode);
        assert (!internal.inlinerOptions().enableInlining);
        assert (!internal.enableClassInlining);
        assert (!internal.enableVerticalClassMerging);
        assert (!internal.enableEnumValueOptimization);
        assert (!internal.outline.enabled);
        assert (!internal.enableTreeShakingOfLibraryMethodOverrides);
        InternalOptions.HorizontalClassMergerOptions horizontalClassMergerOptions = internal.horizontalClassMergerOptions();
        horizontalClassMergerOptions.disable();
        assert (!horizontalClassMergerOptions.isEnabled(HorizontalClassMerger.Mode.INITIAL));
        assert (!horizontalClassMergerOptions.isEnabled(HorizontalClassMerger.Mode.FINAL));
        assert (internal.desugarState == InternalOptions.DesugarState.ON);
        assert (internal.enableInheritanceClassInDexDistributor);
        internal.enableInheritanceClassInDexDistributor = false;
        assert (this.desugaredLibrarySpecification != null);
        internal.setDesugaredLibrarySpecification(this.desugaredLibrarySpecification);
        internal.synthesizedClassPrefix = this.desugaredLibrarySpecification.getSynthesizedLibraryClassesPackagePrefix();
        assert (internal.assertionsConfiguration == null);
        internal.assertionsConfiguration = new AssertionConfigurationWithDefault(AssertionsConfiguration.builder(this.getReporter()).setTransformation(AssertionsConfiguration.AssertionTransformation.DISABLE).setScopeAll().build(), this.getAssertionsConfiguration());
        assert (internal.threadCount == -1);
        internal.threadCount = this.getThreadCount();
        internal.disableGlobalOptimizations();
        internal.setDumpInputFlags(this.getDumpInputFlags(), false);
        internal.dumpOptions = this.dumpOptions();
        return internal;
    }

    static class InMemoryJarContent
    implements ClassFileConsumer,
    ProgramResourceProvider {
        private final List<ProgramResource> resources = new ArrayList<ProgramResource>();

        InMemoryJarContent() {
        }

        @Override
        public synchronized void accept(ByteDataView data2, String descriptor, DiagnosticsHandler handler) {
            this.resources.add(ProgramResource.fromBytes(Origin.unknown(), ProgramResource.Kind.CF, data2.copyByteData(), Collections.singleton(descriptor)));
        }

        @Override
        public Collection<ProgramResource> getProgramResources() throws ResourceException {
            return this.resources;
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
        }
    }

    @Keep
    public static class Builder
    extends BaseCompilerCommand.Builder<L8Command, Builder> {
        private final List<Pair<List<String>, Origin>> proguardConfigStrings = new ArrayList<Pair<List<String>, Origin>>();
        private final List<Path> proguardConfigFiles = new ArrayList<Path>();

        private Builder() {
            this(new DefaultL8DiagnosticsHandler());
        }

        private Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
        }

        public boolean isShrinking() {
            return !this.proguardConfigStrings.isEmpty() || !this.proguardConfigFiles.isEmpty();
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        CompilationMode defaultCompilationMode() {
            return CompilationMode.DEBUG;
        }

        public Builder addProguardConfigurationFiles(Path ... paths) {
            Collections.addAll(this.proguardConfigFiles, paths);
            return this.self();
        }

        public Builder addProguardConfigurationFiles(List<Path> paths) {
            this.proguardConfigFiles.addAll(paths);
            return this.self();
        }

        public Builder addProguardConfiguration(List<String> lines, Origin origin) {
            this.proguardConfigStrings.add(new Pair<List<String>, Origin>(lines, origin));
            return this.self();
        }

        @Override
        public Builder setProguardMapOutputPath(Path proguardMapOutput) {
            return (Builder)super.setProguardMapOutputPath(proguardMapOutput);
        }

        @Override
        public Builder setProguardMapConsumer(StringConsumer proguardMapConsumer) {
            return (Builder)super.setProguardMapConsumer(proguardMapConsumer);
        }

        @Override
        void validate() {
            if (this.isPrintHelp()) {
                return;
            }
            Reporter reporter = this.getReporter();
            if (!this.hasDesugaredLibraryConfiguration()) {
                reporter.error("L8 requires a desugared library configuration");
            }
            if (this.getProgramConsumer() instanceof DexFilePerClassFileConsumer) {
                reporter.error("L8 does not support compiling to dex per class");
            }
            if (this.getAppBuilder().hasMainDexList()) {
                reporter.error("L8 does not support a main dex list");
            } else if (this.getMainDexListConsumer() != null) {
                reporter.error("L8 does not support generating a main dex list");
            }
            if (this.isShrinking() && this.getProgramConsumer() instanceof ClassFileConsumer) {
                reporter.error("L8 does not support shrinking when generating class files");
            }
            if (!this.isShrinking() && this.proguardMapConsumer != null) {
                reporter.error("L8 does not support defining a map consumer when not shrinking");
            }
            super.validate();
        }

        @Override
        L8Command makeCommand() {
            ProgramConsumer l8CfConsumer;
            if (this.isPrintHelp() || this.isPrintVersion()) {
                return new L8Command(this.isPrintHelp(), this.isPrintVersion());
            }
            if (this.getMode() == null) {
                this.setMode(this.defaultCompilationMode());
            }
            DexItemFactory factory = new DexItemFactory();
            DesugaredLibrarySpecification desugaredLibrarySpecification = this.getDesugaredLibraryConfiguration(factory, true);
            R8Command r8Command = null;
            D8Command d8Command = null;
            AndroidApp inputs = this.getAppBuilder().build();
            if (this.isShrinking()) {
                l8CfConsumer = new InMemoryJarContent();
                R8Command.Builder r8Builder = (R8Command.Builder)((R8Command.Builder)((R8Command.Builder)((R8Command.Builder)((R8Command.Builder)R8Command.builder(this.getReporter()).addProgramResourceProvider((ProgramResourceProvider)((Object)l8CfConsumer)).setSynthesizedClassesPrefix(desugaredLibrarySpecification.getSynthesizedLibraryClassesPackagePrefix()).setMinApiLevel(this.getMinApiLevel())).setMode(this.getMode())).setIncludeClassesChecksum(this.getIncludeClassesChecksum())).setDexClassChecksumFilter(this.getDexClassChecksumFilter())).setProgramConsumer(this.getProgramConsumer());
                for (ClassFileResourceProvider classFileResourceProvider : inputs.getLibraryResourceProviders()) {
                    r8Builder.addLibraryResourceProvider(classFileResourceProvider);
                }
                for (Pair pair : this.proguardConfigStrings) {
                    r8Builder.addProguardConfiguration((List)pair.getFirst(), (Origin)pair.getSecond());
                }
                if (this.proguardMapConsumer != null) {
                    r8Builder.setProguardMapConsumer(this.proguardMapConsumer);
                }
                r8Builder.addProguardConfiguration(desugaredLibrarySpecification.getExtraKeepRules(), Origin.unknown());
                r8Builder.addProguardConfiguration(ImmutableList.of("-dontwarn sun.misc.Unsafe"), Origin.unknown());
                r8Builder.addProguardConfigurationFiles(this.proguardConfigFiles);
                r8Builder.setDisableDesugaring(true);
                r8Builder.skipDump();
                r8Command = r8Builder.makeCommand();
            } else if (!(this.getProgramConsumer() instanceof ClassFileConsumer)) {
                l8CfConsumer = new InMemoryJarContent();
                D8Command.Builder d8Builder = (D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)D8Command.builder(this.getReporter()).addProgramResourceProvider((ProgramResourceProvider)((Object)l8CfConsumer))).setSynthesizedClassesPrefix(desugaredLibrarySpecification.getSynthesizedLibraryClassesPackagePrefix()).setMinApiLevel(this.getMinApiLevel())).setMode(this.getMode())).setIncludeClassesChecksum(this.getIncludeClassesChecksum())).setDexClassChecksumFilter(this.getDexClassChecksumFilter())).setProgramConsumer(this.getProgramConsumer());
                for (ClassFileResourceProvider classFileResourceProvider : inputs.getLibraryResourceProviders()) {
                    d8Builder.addLibraryResourceProvider(classFileResourceProvider);
                }
                d8Builder.setDisableDesugaring(true);
                d8Builder.skipDump();
                d8Command = d8Builder.makeCommand();
            } else {
                assert (this.getProgramConsumer() instanceof ClassFileConsumer);
                l8CfConsumer = this.getProgramConsumer();
                d8Command = null;
            }
            return new L8Command(r8Command, d8Command, inputs, this.getMode(), l8CfConsumer, this.getMainDexListConsumer(), this.getMinApiLevel(), this.getReporter(), this.getIncludeClassesChecksum(), this.getDexClassChecksumFilter(), desugaredLibrarySpecification, this.getAssertionsConfiguration(), this.getOutputInspections(), this.getThreadCount(), this.getDumpInputFlags(), this.getMapIdProvider(), factory);
        }
    }

    protected static class DefaultL8DiagnosticsHandler
    implements DiagnosticsHandler {
        protected DefaultL8DiagnosticsHandler() {
        }

        @Override
        public void error(Diagnostic error) {
            if (error instanceof DexFileOverflowDiagnostic) {
                DexFileOverflowDiagnostic overflowDiagnostic = (DexFileOverflowDiagnostic)error;
                DiagnosticsHandler.super.error(new StringDiagnostic(overflowDiagnostic.getDiagnosticMessage() + ". Library too large. L8 can only produce a single .dex file"));
                return;
            }
            DiagnosticsHandler.super.error(error);
        }
    }
}

