/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.Keep;
import com.android.tools.r8.R8Command;
import com.android.tools.r8.Version;
import com.android.tools.r8.androidapi.ApiReferenceStubber;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfPosition;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.desugar.desugaredlibrary.DesugaredLibraryKeepRuleGenerator;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.ApplicationWriter;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.errors.CheckDiscardDiagnostic;
import com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppServices;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.AppliedGraphLens;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.GenericSignatureContextBuilder;
import com.android.tools.r8.graph.GenericSignatureCorrectnessHelper;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.graph.analysis.ClassInitializerAssertionEnablingAnalysis;
import com.android.tools.r8.graph.analysis.InitializedClassesInInstanceMethodsAnalysis;
import com.android.tools.r8.graph.classmerging.VerticallyMergedClasses;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.inspector.internal.InspectorImpl;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.desugar.BackportedMethodRewriter;
import com.android.tools.r8.ir.desugar.CfClassSynthesizerDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfClassSynthesizerDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.DesugaredLibraryAmender;
import com.android.tools.r8.ir.desugar.itf.InterfaceMethodRewriter;
import com.android.tools.r8.ir.desugar.records.RecordDesugaring;
import com.android.tools.r8.ir.desugar.records.RecordFieldValuesRewriter;
import com.android.tools.r8.ir.optimize.AssertionsRewriter;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.NestReducer;
import com.android.tools.r8.ir.optimize.SwitchMapCollector;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxingCfMethods;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import com.android.tools.r8.ir.optimize.templates.CfUtilityMethodsForCodeOptimizations;
import com.android.tools.r8.jar.CfApplicationWriter;
import com.android.tools.r8.kotlin.KotlinMetadataRewriter;
import com.android.tools.r8.kotlin.KotlinMetadataUtils;
import com.android.tools.r8.naming.Minifier;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.PrefixRewritingNamingLens;
import com.android.tools.r8.naming.ProguardMapMinifier;
import com.android.tools.r8.naming.RecordRewritingNamingLens;
import com.android.tools.r8.naming.signature.GenericSignatureRewriter;
import com.android.tools.r8.optimize.ClassAndMemberPublicizer;
import com.android.tools.r8.optimize.MemberRebindingAnalysis;
import com.android.tools.r8.optimize.MemberRebindingIdentityLensFactory;
import com.android.tools.r8.optimize.VisibilityBridgeRemover;
import com.android.tools.r8.optimize.bridgehoisting.BridgeHoisting;
import com.android.tools.r8.optimize.proto.ProtoNormalizer;
import com.android.tools.r8.origin.CommandLineOrigin;
import com.android.tools.r8.repackaging.Repackaging;
import com.android.tools.r8.repackaging.RepackagingLens;
import com.android.tools.r8.shaking.AbstractMethodRemover;
import com.android.tools.r8.shaking.AnnotationRemover;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.ClassInitFieldSynthesizer;
import com.android.tools.r8.shaking.DefaultTreePrunerConfiguration;
import com.android.tools.r8.shaking.DiscardedChecker;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.EnqueuerFactory;
import com.android.tools.r8.shaking.EnqueuerResult;
import com.android.tools.r8.shaking.MainDexInfo;
import com.android.tools.r8.shaking.MainDexListBuilder;
import com.android.tools.r8.shaking.ProguardAssumeNoSideEffectRule;
import com.android.tools.r8.shaking.ProguardConfigurationUtils;
import com.android.tools.r8.shaking.RootSetUtils;
import com.android.tools.r8.shaking.RuntimeTypeCheckInfo;
import com.android.tools.r8.shaking.TreePruner;
import com.android.tools.r8.shaking.TreePrunerConfiguration;
import com.android.tools.r8.shaking.VerticalClassMerger;
import com.android.tools.r8.shaking.VerticalClassMergerGraphLens;
import com.android.tools.r8.shaking.WhyAreYouKeepingConsumer;
import com.android.tools.r8.synthesis.SyntheticFinalization;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.AssertionUtils;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.CollectionUtils;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.SelfRetraceTest;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

@Keep
public class R8 {
    private final Timing timing;
    private final InternalOptions options;

    private R8(InternalOptions options) {
        this.options = options;
        if (options.printMemory) {
            System.gc();
        }
        this.timing = Timing.create("R8", options);
    }

    public static void run(R8Command command) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        R8.runForTesting(app, options);
    }

    public static void run(R8Command command, ExecutorService executor) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        ExceptionUtils.withR8CompilationHandler(command.getReporter(), () -> R8.run(app, options, executor));
    }

    static void writeApplication(ExecutorService executorService, AppView<?> appView, NamingLens namingLens, InternalOptions options, AndroidApp inputApp) throws ExecutionException {
        InspectorImpl.runInspections(options.outputInspections, ((AppInfo)appView.appInfo()).classes());
        try {
            Marker marker = options.getMarker(Marker.Tool.R8);
            assert (marker != null);
            HashSet<Marker> markers = new HashSet<Marker>(options.itemFactory.extractMarkers());
            markers.remove(marker);
            if (options.isGeneratingClassFiles()) {
                new CfApplicationWriter(appView, marker, namingLens).write(options.getClassFileConsumer(), inputApp);
            } else {
                new ApplicationWriter(appView, (List<Marker>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(marker)).addAll(markers)).build()), namingLens).write(executorService, inputApp);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write application", e);
        }
    }

    static void runForTesting(AndroidApp app, InternalOptions options) throws CompilationFailedException {
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        ExceptionUtils.withR8CompilationHandler(options.reporter, () -> {
            try {
                R8.run(app, options, executor);
            }
            finally {
                executor.shutdown();
            }
        });
    }

    private static void run(AndroidApp app, InternalOptions options, ExecutorService executor) throws IOException {
        new R8(options).run(app, executor);
    }

    private static DirectMappedDexApplication getDirectApp(AppView<?> appView) {
        return ((AppInfo)appView.appInfo()).app().asDirect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run(AndroidApp inputApp, ExecutorService executorService) throws IOException {
        assert (this.options.programConsumer != null);
        if (this.options.quiet) {
            System.setOut(new PrintStream(ByteStreams.nullOutputStream()));
        }
        if (this.getClass().desiredAssertionStatus()) {
            this.options.reporter.info(new StringDiagnostic("Running R8 version main with assertions enabled."));
        }
        assert (AssertionUtils.forTesting(this.options, () -> !this.options.testing.testEnableTestAssertions));
        if (this.options.printMemory) {
            System.gc();
            System.gc();
            Runtime runtime = Runtime.getRuntime();
            System.out.println("R8 is running with total memory:" + runtime.totalMemory());
            System.out.println("R8 is running with free memory:" + runtime.freeMemory());
            System.out.println("R8 is running with max memory:" + runtime.maxMemory());
        }
        try {
            NamingLens namingLens;
            RecordFieldValuesRewriter recordFieldArrayRemover;
            IRConverter converter;
            Set<DexType> prunedTypes;
            AppView<AppInfoWithLiveness> appViewWithLiveness;
            RuntimeTypeCheckInfo.Builder classMergingEnqueuerExtensionBuilder;
            ArrayList<ProguardAssumeNoSideEffectRule> synthesizedProguardRules;
            AppView<AppInfoWithClassHierarchy> appView;
            block101: {
                Object application;
                ApplicationReader applicationReader = new ApplicationReader(inputApp, this.options, this.timing);
                DirectMappedDexApplication application2 = applicationReader.read(executorService).toDirect();
                this.options.loadMachineDesugaredLibrarySpecification(this.timing, application2);
                MainDexInfo mainDexInfo = applicationReader.readMainDexClassesForR8(application2);
                inputApp.closeInternalArchiveProviders();
                appView = AppView.createForR8(application2, mainDexInfo);
                appView.setAppServices(AppServices.builder(appView).build());
                SyntheticItems.collectSyntheticInputs(appView);
                boolean bl = this.options.enableCfByteCodePassThrough = this.options.isGeneratingClassFiles() && KotlinMetadataUtils.mayProcessKotlinMetadata(appView);
                if (!this.options.mainDexKeepRules.isEmpty()) {
                    MainDexListBuilder.checkForAssumedLibraryTypes(appView.appInfo());
                }
                DesugaredLibraryAmender.run(appView);
                InterfaceMethodRewriter.checkForAssumedLibraryTypes(appView.appInfo(), this.options);
                BackportedMethodRewriter.registerAssumedLibraryTypes(this.options);
                if (this.options.enableEnumUnboxing) {
                    EnumUnboxingCfMethods.registerSynthesizedCodeReferences(appView.dexItemFactory());
                }
                if (this.options.shouldDesugarRecords()) {
                    RecordDesugaring.registerSynthesizedCodeReferences(appView.dexItemFactory());
                }
                CfUtilityMethodsForCodeOptimizations.registerSynthesizedCodeReferences(appView.dexItemFactory());
                CfClassSynthesizerDesugaringEventConsumer classSynthesizerEventConsumer = new CfClassSynthesizerDesugaringEventConsumer();
                CfClassSynthesizerDesugaringCollection.create(appView).synthesizeClasses(executorService, classSynthesizerEventConsumer);
                if (appView.getSyntheticItems().hasPendingSyntheticClasses()) {
                    appView.setAppInfo(appView.appInfo().rebuildWithClassHierarchy(appView.getSyntheticItems().commit(appView.appInfo().app())));
                }
                synthesizedProguardRules = new ArrayList<ProguardAssumeNoSideEffectRule>();
                this.timing.begin("Strip unused code");
                classMergingEnqueuerExtensionBuilder = new RuntimeTypeCheckInfo.Builder(appView);
                try {
                    if (this.options.isGeneratingDex() && !ProguardConfigurationUtils.hasExplicitAssumeValuesOrAssumeNoSideEffectsRuleForMinSdk(this.options.itemFactory, this.options.getProguardConfiguration().getRules())) {
                        synthesizedProguardRules.add(ProguardConfigurationUtils.buildAssumeNoSideEffectsRuleForApiLevel(this.options.itemFactory, this.options.getMinApiLevel()));
                    }
                    SubtypingInfo subtypingInfo = SubtypingInfo.create(appView);
                    appView.setRootSet(RootSetUtils.RootSet.builder(appView, subtypingInfo, Iterables.concat(this.options.getProguardConfiguration().getRules(), synthesizedProguardRules)).build(executorService));
                    if (!this.options.mainDexKeepRules.isEmpty()) {
                        assert (appView.graphLens().isIdentityLens());
                        RootSetUtils.MainDexRootSet mainDexRootSet = RootSetUtils.MainDexRootSet.builder(appView, subtypingInfo, this.options.mainDexKeepRules).build(executorService);
                        appView.setMainDexRootSet(mainDexRootSet);
                        appView.appInfo().unsetObsolete();
                    }
                    AnnotationRemover.Builder annotationRemoverBuilder = this.options.isShrinking() ? AnnotationRemover.builder(Enqueuer.Mode.INITIAL_TREE_SHAKING) : null;
                    AppView<AppInfoWithLiveness> appViewWithLiveness2 = this.runEnqueuer(annotationRemoverBuilder, executorService, appView, subtypingInfo, classMergingEnqueuerExtensionBuilder);
                    assert (appView.rootSet().verifyKeptFieldsAreAccessedAndLive(appViewWithLiveness2));
                    assert (appView.rootSet().verifyKeptMethodsAreTargetedAndLive(appViewWithLiveness2));
                    assert (appView.rootSet().verifyKeptTypesAreLive(appViewWithLiveness2));
                    assert (appView.rootSet().verifyKeptItemsAreKept(appView));
                    appView.rootSet().checkAllRulesAreUsed(this.options);
                    if (this.options.proguardSeedsConsumer != null) {
                        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                        PrintStream out = new PrintStream(bytes);
                        RootSetUtils.RootSetBuilder.writeSeeds(appView.appInfo().withLiveness(), out, type -> true);
                        out.flush();
                        ExceptionUtils.withConsumeResourceHandler(this.options.reporter, this.options.proguardSeedsConsumer, bytes.toString());
                        ExceptionUtils.withFinishedResourceHandler(this.options.reporter, this.options.proguardSeedsConsumer);
                    }
                    if (this.options.isShrinking()) {
                        appView.withGeneratedExtensionRegistryShrinker(shrinker -> shrinker.run(Enqueuer.Mode.INITIAL_TREE_SHAKING));
                        GenericSignatureContextBuilder genericContextBuilder = GenericSignatureContextBuilder.create(appView);
                        GenericSignatureCorrectnessHelper.createForInitialCheck(appView, genericContextBuilder).run(appView.appInfo().classes());
                        TreePruner pruner = new TreePruner(appViewWithLiveness2);
                        DirectMappedDexApplication prunedApp = pruner.run(executorService);
                        Set<DexType> removedClasses = pruner.getRemovedClasses();
                        appView.pruneItems(PrunedItems.builder().setPrunedApp(prunedApp).addRemovedClasses(removedClasses).addAdditionalPinnedItems(pruner.getMethodsToKeepForConfigurationDebugging()).build(), executorService);
                        new AbstractMethodRemover(appViewWithLiveness2, appViewWithLiveness2.appInfo().computeSubtypingInfo()).run();
                        if (appView.options().protoShrinking().isEnumLiteProtoShrinkingEnabled()) {
                            appView.protoShrinker().enumLiteProtoShrinker.clearDeadEnumLiteMaps();
                        }
                        AnnotationRemover annotationRemover = annotationRemoverBuilder.build(appViewWithLiveness2, removedClasses);
                        annotationRemover.ensureValid().run(executorService);
                        new GenericSignatureRewriter(appView, NamingLens.getIdentityLens(), genericContextBuilder).run(appView.appInfo().classes(), executorService);
                        assert (appView.checkForTesting(() -> R8.allReferencesAssignedApiLevel(appViewWithLiveness2)));
                    }
                }
                finally {
                    this.timing.end();
                }
                assert (appView.appInfo().hasLiveness());
                appViewWithLiveness = appView.withLiveness();
                assert (R8.verifyNoJarApplicationReaders(appView.appInfo().classes()));
                assert (appView.checkForTesting(() -> R8.allReferencesAssignedApiLevel(appViewWithLiveness)));
                this.performInitialMainDexTracing(appView, executorService);
                appView.dexItemFactory().clearTypeElementsCache();
                if (this.options.getProguardConfiguration().isAccessModificationAllowed()) {
                    SubtypingInfo subtypingInfo = appViewWithLiveness.appInfo().computeSubtypingInfo();
                    GraphLens publicizedLens = ClassAndMemberPublicizer.run(executorService, this.timing, appViewWithLiveness.appInfo().app(), appViewWithLiveness, subtypingInfo);
                    boolean changed = appView.setGraphLens(publicizedLens);
                    if (changed) {
                        new VisibilityBridgeRemover(appView.withLiveness()).run(executorService);
                    }
                }
                new NestReducer(appViewWithLiveness).run(executorService, this.timing);
                appView.setGraphLens(new MemberRebindingAnalysis(appViewWithLiveness).run(executorService));
                appView.appInfo().withLiveness().getFieldAccessInfoCollection().restrictToProgram(appView);
                boolean isKotlinLibraryCompilationWithInlinePassThrough = this.options.enableCfByteCodePassThrough && appView.hasCfByteCodePassThroughMethods();
                RuntimeTypeCheckInfo runtimeTypeCheckInfo = classMergingEnqueuerExtensionBuilder.build(appView.graphLens());
                classMergingEnqueuerExtensionBuilder = null;
                if (!isKotlinLibraryCompilationWithInlinePassThrough && this.options.getProguardConfiguration().isOptimizing()) {
                    if (this.options.enableVerticalClassMerging) {
                        this.timing.begin("VerticalClassMerger");
                        VerticalClassMergerGraphLens lens = new VerticalClassMerger(R8.getDirectApp(appViewWithLiveness), appViewWithLiveness, executorService, this.timing).run();
                        if (lens != null) {
                            runtimeTypeCheckInfo = runtimeTypeCheckInfo.rewriteWithLens(lens);
                        }
                        this.timing.end();
                    } else {
                        appView.setVerticallyMergedClasses(VerticallyMergedClasses.empty());
                    }
                    assert (appView.verticallyMergedClasses() != null);
                    HorizontalClassMerger.createForInitialClassMerging(appViewWithLiveness).runIfNecessary(executorService, this.timing, runtimeTypeCheckInfo);
                }
                new ProtoNormalizer(appViewWithLiveness).run(executorService, this.timing);
                appView.appInfo().getMainDexInfo().clearTracedMethodRoots();
                assert (appView.dexItemFactory().verifyNoCachedTypeElements());
                assert (appView.checkForTesting(() -> R8.allReferencesAssignedApiLevel(appViewWithLiveness)));
                if (this.options.enableEnumSwitchMapRemoval) {
                    appViewWithLiveness.setAppInfo(new SwitchMapCollector(appViewWithLiveness).run());
                }
                prunedTypes = appView.withLiveness().appInfo().getPrunedTypes();
                this.timing.begin("Create IR");
                CfgPrinter printer = this.options.printCfg ? new CfgPrinter() : null;
                try {
                    converter = new IRConverter(appView, this.timing, printer);
                    application = converter.optimize(appViewWithLiveness, executorService).asDirect();
                    appView.setAppInfo(appView.appInfo().rebuildWithClassHierarchy(arg_0 -> R8.lambda$run$8((DexApplication)application, arg_0)));
                }
                finally {
                    this.timing.end();
                }
                appView.dexItemFactory().clearTypeElementsCache();
                this.timing.begin("AppliedGraphLens construction");
                appView.setGraphLens(new AppliedGraphLens((AppView<? extends AppInfoWithClassHierarchy>)appView));
                this.timing.end();
                if (this.options.printCfg) {
                    OutputStreamWriter writer;
                    block99: {
                        if (this.options.printCfgFile == null || this.options.printCfgFile.isEmpty()) {
                            System.out.print(printer.toString());
                        } else {
                            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.options.printCfgFile), StandardCharsets.UTF_8);
                            application = null;
                            try {
                                writer.write(printer.toString());
                                if (application == null) break block99;
                            }
                            catch (Throwable annotationRemover) {
                                try {
                                    application = annotationRemover;
                                    throw annotationRemover;
                                }
                                catch (Throwable throwable) {
                                    if (application == null) {
                                        writer.close();
                                        throw throwable;
                                    }
                                    try {
                                        writer.close();
                                        throw throwable;
                                    }
                                    catch (Throwable throwable2) {
                                        ((Throwable)application).addSuppressed(throwable2);
                                        throw throwable;
                                    }
                                }
                            }
                            try {
                                writer.close();
                            }
                            catch (Throwable annotationRemover) {
                                ((Throwable)application).addSuppressed(annotationRemover);
                            }
                        }
                        break block101;
                    }
                    writer.close();
                }
            }
            if (this.options.shouldRerunEnqueuer()) {
                this.timing.begin("Post optimization code stripping");
                try {
                    Enqueuer enqueuer;
                    GraphConsumer keptGraphConsumer = null;
                    WhyAreYouKeepingConsumer whyAreYouKeepingConsumer = null;
                    if (this.options.isShrinking()) {
                        keptGraphConsumer = this.options.keptGraphConsumer;
                        if (!appView.rootSet().reasonAsked.isEmpty()) {
                            whyAreYouKeepingConsumer = new WhyAreYouKeepingConsumer(keptGraphConsumer);
                            keptGraphConsumer = whyAreYouKeepingConsumer;
                        }
                    }
                    if (this.options.isClassMergingExtensionRequired((enqueuer = EnqueuerFactory.createForFinalTreeShaking(appView, executorService, SubtypingInfo.create(appView), keptGraphConsumer, prunedTypes)).getMode())) {
                        classMergingEnqueuerExtensionBuilder = new RuntimeTypeCheckInfo.Builder(appView);
                        classMergingEnqueuerExtensionBuilder.attach(enqueuer);
                    }
                    EnqueuerResult enqueuerResult = enqueuer.traceApplication(appView.rootSet(), executorService, this.timing);
                    appView.setAppInfo(enqueuerResult.getAppInfo());
                    appView.withGeneratedMessageLiteBuilderShrinker(shrinker -> shrinker.rewriteDeadBuilderReferencesFromDynamicMethods(appViewWithLiveness, executorService, this.timing));
                    if (this.options.isShrinking()) {
                        TreePrunerConfiguration treePrunerConfiguration = appView.withGeneratedExtensionRegistryShrinker(shrinker -> shrinker.run(enqueuer.getMode()), DefaultTreePrunerConfiguration.getInstance());
                        GenericSignatureContextBuilder genericContextBuilder = GenericSignatureContextBuilder.create(appView);
                        TreePruner pruner = new TreePruner(appViewWithLiveness, treePrunerConfiguration);
                        DirectMappedDexApplication application = pruner.run(executorService);
                        Set<DexType> removedClasses = pruner.getRemovedClasses();
                        if (this.options.usageInformationConsumer != null) {
                            ExceptionUtils.withFinishedResourceHandler(this.options.reporter, this.options.usageInformationConsumer);
                        }
                        appView.pruneItems(PrunedItems.builder().setPrunedApp(application).addRemovedClasses(CollectionUtils.mergeSets(prunedTypes, removedClasses)).addAdditionalPinnedItems(pruner.getMethodsToKeepForConfigurationDebugging()).build(), executorService);
                        new BridgeHoisting(appViewWithLiveness).run();
                        assert (Inliner.verifyAllSingleCallerMethodsHaveBeenPruned(appViewWithLiveness));
                        assert (Inliner.verifyAllMultiCallerInlinedMethodsHaveBeenPruned(appView));
                        assert (appView.allMergedClasses().verifyAllSourcesPruned(appViewWithLiveness));
                        assert (appView.validateUnboxedEnumsHaveBeenPruned());
                        assert (appView.withLiveness().appInfo().verifyNoIteratingOverPrunedClasses());
                        R8.processWhyAreYouKeepingAndCheckDiscarded(appView.rootSet(), () -> ((AppInfoWithClassHierarchy)appView.appInfo()).app().classesWithDeterministicOrder(), whyAreYouKeepingConsumer, appView, enqueuer, false, this.options, this.timing, executorService);
                        AnnotationRemover.builder(Enqueuer.Mode.FINAL_TREE_SHAKING).build(appView.withLiveness(), removedClasses).run(executorService);
                        new GenericSignatureRewriter(appView, NamingLens.getIdentityLens(), genericContextBuilder).run(appView.appInfo().classes(), executorService);
                        assert (appView.checkForTesting(() -> GenericSignatureCorrectnessHelper.createForVerification(appView, GenericSignatureContextBuilder.create(appView)).run(((AppInfoWithClassHierarchy)appView.appInfo()).classes()).isValid())) : "Could not validate generic signatures";
                        new ClassInitFieldSynthesizer(appViewWithLiveness).run(executorService);
                    }
                }
                finally {
                    this.timing.end();
                }
                if (appView.options().protoShrinking().isProtoShrinkingEnabled()) {
                    if (appView.options().protoShrinking().isEnumLiteProtoShrinkingEnabled()) {
                        appView.protoShrinker().enumLiteProtoShrinker.verifyDeadEnumLiteMapsAreDead();
                    }
                    converter = new IRConverter(appView, this.timing, null);
                    appView.withGeneratedMessageLiteShrinker(shrinker -> shrinker.postOptimizeDynamicMethods(converter, executorService, this.timing));
                    appView.withGeneratedExtensionRegistryShrinker(shrinker -> shrinker.postOptimizeGeneratedExtensionRegistry(converter, executorService, this.timing));
                }
            }
            this.performFinalMainDexTracing(appView, executorService);
            if (appView.appInfo().hasLiveness() && (recordFieldArrayRemover = RecordFieldValuesRewriter.create(appView.withLiveness())) != null) {
                recordFieldArrayRemover.rewriteRecordFieldValues();
            }
            if (appView.appInfo().hasLiveness()) {
                new VisibilityBridgeRemover(appView.withLiveness()).run(executorService);
            } else assert (!this.options.isShrinking());
            appView.setGraphLens(MemberRebindingIdentityLensFactory.create(appView, executorService));
            if (appView.appInfo().hasLiveness()) {
                SyntheticFinalization.finalizeWithLiveness(appView.withLiveness(), executorService);
            } else {
                SyntheticFinalization.finalizeWithClassHierarchy(appView, executorService);
            }
            this.timing.begin("read -applymapping file");
            appView.loadApplyMappingSeedMapper();
            this.timing.end();
            if (this.options.isRepackagingEnabled()) {
                DirectMappedDexApplication.Builder appBuilder = appView.appInfo().app().asDirect().builder();
                RepackagingLens lens = new Repackaging(appView.withLiveness()).run(appBuilder, executorService, this.timing);
                if (lens != null) {
                    appView.rewriteWithLensAndApplication(lens, appBuilder.build());
                }
            }
            if (appView.appInfo().hasLiveness()) assert (Repackaging.verifyIdentityRepackaging(appView.withLiveness()));
            appView.dexItemFactory().clearTypeElementsCache();
            GenericSignatureContextBuilder genericContextBuilderBeforeFinalMerging = GenericSignatureContextBuilder.create(appView);
            HorizontalClassMerger.createForFinalClassMerging(appView).runIfNecessary(executorService, this.timing, classMergingEnqueuerExtensionBuilder != null ? classMergingEnqueuerExtensionBuilder.build(appView.graphLens()) : null);
            if (this.options.getProguardConfiguration().hasApplyMappingFile()) {
                this.timing.begin("apply-mapping");
                namingLens = new ProguardMapMinifier(appView.withLiveness()).run(executorService, this.timing);
                this.timing.end();
                appView.clearApplyMappingSeedMapper();
            } else if (this.options.isMinifying()) {
                this.timing.begin("Minification");
                namingLens = new Minifier(appView.withLiveness()).run(executorService, this.timing);
                this.timing.end();
            } else {
                namingLens = NamingLens.getIdentityLens();
            }
            assert (R8.verifyMovedMethodsHaveOriginalMethodPosition(appView, R8.getDirectApp(appView)));
            if (this.options.hasMethodsFilter()) {
                System.out.println("Finished compilation with method filter: ");
                this.options.methodsFilter.forEach(m3 -> System.out.println("  - " + m3));
                return;
            }
            assert (R8.getDirectApp(appView).verifyCodeObjectsOwners());
            assert (appView.appInfo().classes().stream().allMatch(clazz -> clazz.isValid(this.options)));
            if (this.options.isShrinking() || this.options.isMinifying() || this.options.getProguardConfiguration().hasApplyMappingFile()) assert (appView.rootSet().verifyKeptItemsAreKept(appView));
            assert (this.options.testing.disableMappingToOriginalProgramVerification || appView.graphLens().verifyMappingToOriginalProgram(appView, new ApplicationReader(inputApp.withoutMainDexList(), this.options, this.timing).readWithoutDumping(executorService)));
            if (this.options.syntheticProguardRulesConsumer != null) {
                this.options.syntheticProguardRulesConsumer.accept(synthesizedProguardRules);
            }
            namingLens = PrefixRewritingNamingLens.createPrefixRewritingNamingLens(appView, namingLens);
            namingLens = RecordRewritingNamingLens.createRecordRewritingNamingLens(appView, namingLens);
            new ApiReferenceStubber(appView).run(executorService);
            this.timing.begin("MinifyKotlinMetadata");
            new KotlinMetadataRewriter(appView, namingLens).runForR8(executorService);
            this.timing.end();
            new GenericSignatureRewriter(appView, namingLens, genericContextBuilderBeforeFinalMerging).run(appView.appInfo().classes(), executorService);
            assert (appView.checkForTesting(() -> !this.options.isShrinking() || GenericSignatureCorrectnessHelper.createForVerification(appView, GenericSignatureContextBuilder.create(appView)).run(((AppInfoWithClassHierarchy)appView.appInfo()).classes()).isValid())) : "Could not validate generic signatures";
            new DesugaredLibraryKeepRuleGenerator(appView, namingLens).runIfNecessary(this.timing);
            R8.writeApplication(executorService, appView, namingLens, this.options, inputApp);
            assert (appView.getDontWarnConfiguration().validate(this.options));
            this.options.printWarnings();
            return;
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.unwrapExecutionException(e);
        }
        finally {
            this.options.signalFinishedToConsumers();
            if (this.options.printTimes) {
                this.timing.report();
            }
        }
    }

    private static boolean allReferencesAssignedApiLevel(AppView<? extends AppInfoWithClassHierarchy> appView) {
        if (!appView.options().apiModelingOptions().checkAllApiReferencesAreSet || appView.options().configurationDebugging) {
            return true;
        }
        for (DexProgramClass clazz : appView.appInfo().classesWithDeterministicOrder()) {
            clazz.forEachProgramMember(member -> {
                assert (!((DexEncodedMember)member.getDefinition()).getApiLevel().isNotSetApiLevel()) : "Every member should have been analyzed";
                assert (appView.options().apiModelingOptions().enableApiCallerIdentification || ((DexEncodedMember)member.getDefinition()).getApiLevel().isUnknownApiLevel()) : "Every member should have level UNKNOWN";
            });
        }
        return true;
    }

    private void performInitialMainDexTracing(AppView<AppInfoWithClassHierarchy> appView, ExecutorService executorService) throws ExecutionException {
        if (this.options.mainDexKeepRules.isEmpty()) {
            return;
        }
        assert (appView.graphLens().isIdentityLens());
        MainDexInfo mainDexInfo = EnqueuerFactory.createForInitialMainDexTracing(appView, executorService, SubtypingInfo.create(appView)).traceMainDex(executorService, this.timing);
        appView.setAppInfo(appView.appInfo().rebuildWithMainDexInfo(mainDexInfo));
    }

    private void performFinalMainDexTracing(AppView<AppInfoWithClassHierarchy> appView, ExecutorService executorService) throws ExecutionException {
        if (this.options.mainDexKeepRules.isEmpty()) {
            return;
        }
        assert (appView.getMainDexRootSet() != null);
        GraphConsumer mainDexKeptGraphConsumer = this.options.mainDexKeptGraphConsumer;
        WhyAreYouKeepingConsumer whyAreYouKeepingConsumer = null;
        if (!appView.getMainDexRootSet().reasonAsked.isEmpty()) {
            whyAreYouKeepingConsumer = new WhyAreYouKeepingConsumer(mainDexKeptGraphConsumer);
            mainDexKeptGraphConsumer = whyAreYouKeepingConsumer;
        }
        Enqueuer enqueuer = EnqueuerFactory.createForFinalMainDexTracing(appView, executorService, SubtypingInfo.create(appView), mainDexKeptGraphConsumer);
        MainDexInfo mainDexInfo = enqueuer.traceMainDex(executorService, this.timing);
        appView.setAppInfo(appView.appInfo().rebuildWithMainDexInfo(mainDexInfo));
        R8.processWhyAreYouKeepingAndCheckDiscarded(appView.getMainDexRootSet(), () -> {
            ArrayList classes = new ArrayList();
            mainDexInfo.forEach(type -> {
                DexClass clazz = appView.definitionFor((DexType)type);
                assert (clazz.isProgramClass());
                classes.add(clazz.asProgramClass());
            });
            return classes;
        }, whyAreYouKeepingConsumer, appView, enqueuer, true, this.options, this.timing, executorService);
    }

    private static boolean verifyMovedMethodsHaveOriginalMethodPosition(AppView<?> appView, DirectMappedDexApplication application) {
        application.classesWithDeterministicOrder().forEach(clazz -> clazz.forEachProgramMethod(method -> {
            DexMethod originalMethod = appView.graphLens().getOriginalMethodSignature((DexMethod)method.getReference());
            if (originalMethod != method.getReference()) {
                DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
                Code code = definition.getCode();
                if (code == null) {
                    return;
                }
                if (code.isCfCode() ? !$assertionsDisabled && !R8.verifyOriginalMethodInPosition(code.asCfCode(), originalMethod) : (code.isDexCode() ? !$assertionsDisabled && !R8.verifyOriginalMethodInDebugInfo(code.asDexCode(), originalMethod) : !$assertionsDisabled && !code.isDefaultInstanceInitializerCode() && !code.isThrowNullCode())) {
                    throw new AssertionError();
                }
            }
        }));
        return true;
    }

    private static boolean verifyOriginalMethodInPosition(CfCode code, DexMethod originalMethod) {
        for (CfInstruction instruction : code.getInstructions()) {
            if (!instruction.isPosition()) continue;
            CfPosition position = instruction.asPosition();
            assert (position.getPosition().getOutermostCaller().getMethod() == originalMethod);
        }
        return true;
    }

    private static boolean verifyOriginalMethodInDebugInfo(DexCode code, DexMethod originalMethod) {
        if (code.getDebugInfo() == null || code.getDebugInfo().isPcBasedInfo()) {
            return true;
        }
        for (DexDebugEvent event : code.getDebugInfo().asEventBasedInfo().events) {
            assert (!event.isSetInlineFrame() || event.asSetInlineFrame().hasOuterPosition(originalMethod));
        }
        return true;
    }

    private AppView<AppInfoWithLiveness> runEnqueuer(AnnotationRemover.Builder annotationRemoverBuilder, ExecutorService executorService, AppView<AppInfoWithClassHierarchy> appView, SubtypingInfo subtypingInfo, RuntimeTypeCheckInfo.Builder classMergingEnqueuerExtensionBuilder) throws ExecutionException {
        Enqueuer enqueuer = EnqueuerFactory.createForInitialTreeShaking(appView, executorService, subtypingInfo);
        enqueuer.setAnnotationRemoverBuilder(annotationRemoverBuilder);
        if (appView.options().enableInitializedClassesInInstanceMethodsAnalysis) {
            enqueuer.registerAnalysis(new InitializedClassesInInstanceMethodsAnalysis(appView));
        }
        if (AssertionsRewriter.isEnabled(appView.options())) {
            ClassInitializerAssertionEnablingAnalysis analysis = new ClassInitializerAssertionEnablingAnalysis(appView, OptimizationFeedbackSimple.getInstance());
            enqueuer.registerAnalysis(analysis);
            enqueuer.registerFieldAccessAnalysis(analysis);
        }
        if (this.options.isClassMergingExtensionRequired(enqueuer.getMode())) {
            classMergingEnqueuerExtensionBuilder.attach(enqueuer);
        }
        EnqueuerResult enqueuerResult = enqueuer.traceApplication(appView.rootSet(), executorService, this.timing);
        AppView<AppInfoWithLiveness> appViewWithLiveness = appView.setAppInfo(enqueuerResult.getAppInfo());
        if (InternalOptions.assertionsEnabled()) {
            appViewWithLiveness.withProtoShrinker(shrinker -> shrinker.setDeadProtoTypes(((AppInfoWithLiveness)appViewWithLiveness.appInfo()).getDeadProtoTypes()));
        }
        appView.withGeneratedMessageLiteBuilderShrinker(shrinker -> shrinker.rewriteDeadBuilderReferencesFromDynamicMethods(appViewWithLiveness, executorService, this.timing));
        return appViewWithLiveness;
    }

    static void processWhyAreYouKeepingAndCheckDiscarded(RootSetUtils.RootSet rootSet, Supplier<Iterable<DexProgramClass>> classes, WhyAreYouKeepingConsumer whyAreYouKeepingConsumer, AppView<? extends AppInfoWithClassHierarchy> appView, Enqueuer enqueuer, boolean forMainDex, InternalOptions options, Timing timing, ExecutorService executorService) throws ExecutionException {
        if (whyAreYouKeepingConsumer != null) {
            for (DexReference reference : rootSet.reasonAsked) {
                whyAreYouKeepingConsumer.printWhyAreYouKeeping(enqueuer.getGraphReporter().getGraphNode(reference), System.out);
            }
        }
        if (appView.options().testing.dontReportFailingCheckDiscarded) {
            return;
        }
        DiscardedChecker discardedChecker = forMainDex ? DiscardedChecker.createForMainDex(appView) : DiscardedChecker.create(appView);
        List<ProgramDefinition> failed = discardedChecker.run(classes.get(), executorService);
        if (failed.isEmpty()) {
            return;
        }
        if (whyAreYouKeepingConsumer == null) {
            whyAreYouKeepingConsumer = new WhyAreYouKeepingConsumer(null);
            SubtypingInfo subtypingInfo = SubtypingInfo.create(appView);
            if (forMainDex) {
                enqueuer = EnqueuerFactory.createForFinalMainDexTracing(appView, executorService, subtypingInfo, whyAreYouKeepingConsumer);
                enqueuer.traceMainDex(executorService, timing);
            } else {
                enqueuer = EnqueuerFactory.createForWhyAreYouKeeping(appView, executorService, subtypingInfo, whyAreYouKeepingConsumer);
                enqueuer.traceApplication(rootSet, executorService, timing);
            }
        }
        options.reporter.error(new CheckDiscardDiagnostic.Builder().addFailedItems(failed, enqueuer.getGraphReporter(), whyAreYouKeepingConsumer).build());
        options.reporter.failIfPendingErrors();
    }

    private static boolean verifyNoJarApplicationReaders(Collection<DexProgramClass> classes) {
        for (DexProgramClass clazz : classes) {
            for (DexEncodedMethod method : clazz.methods()) {
                if (method.getCode() != null) assert (method.getCode().verifyNoInputReaders());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(String[] args2) throws CompilationFailedException {
        R8Command command = (R8Command)R8Command.parse(args2, CommandLineOrigin.INSTANCE).build();
        if (command.isPrintHelp()) {
            SelfRetraceTest.test();
            System.out.println(R8Command.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("R8 " + Version.getVersionString());
            return;
        }
        InternalOptions options = command.getInternalOptions();
        ExecutorService executorService = ThreadUtils.getExecutorService(options);
        try {
            ExceptionUtils.withR8CompilationHandler(options.reporter, () -> R8.run(command.getInputApp(), options, executorService));
        }
        finally {
            executorService.shutdown();
        }
    }

    public static void main(String[] args2) {
        if (args2.length == 0) {
            throw new RuntimeException(StringUtils.joinLines("Invalid invocation.", R8Command.USAGE_MESSAGE));
        }
        ExceptionUtils.withMainProgramHandler(() -> R8.run(args2));
    }

    private static /* synthetic */ DexApplication lambda$run$8(DexApplication application, DexApplication previous) {
        return application;
    }
}

