/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ArchiveProgramResourceProvider;
import com.android.tools.r8.BaseCompilerCommandParser;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.R8;
import com.android.tools.r8.R8Command;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.StringResource;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.FlagFile;
import com.android.tools.r8.utils.MapIdTemplateProvider;
import com.android.tools.r8.utils.SourceFileTemplateProvider;
import com.android.tools.r8.utils.StringDiagnostic;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class R8CommandParser
extends BaseCompilerCommandParser<R8Command, R8Command.Builder> {
    private static final Set<String> OPTIONS_WITH_PARAMETER = ImmutableSet.of("--output", "--lib", "--classpath", "--min-api", "--main-dex-rules", "--main-dex-list", new String[]{"--feature", "--main-dex-list-output", "--pg-conf", "--pg-map-output", "--desugared-lib", "--desugared-lib-pg-conf-output", "--map-id-template", "--source-file-template", "--thread-count"});
    private static final Set<String> OPTIONS_WITH_TWO_PARAMETERS = ImmutableSet.of("--feature");
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", Iterables.concat(Arrays.asList("Usage: r8 [options] [@<argfile>] <input-files>", " where <input-files> are any combination of dex, class, zip, jar, or apk files", " and each <argfile> is a file containing additional arguments (one per line)", " and options are:", "  --release               # Compile without debugging information (default).", "  --debug                 # Compile with debugging information.", "  --dex                   # Compile program to DEX file format (default).", "  --classfile             # Compile program to Java classfile format.", "  --output <file>         # Output result in <file>.", "                          # <file> must be an existing directory or a zip file.", "  --lib <file|jdk-home>   # Add <file|jdk-home> as a library resource.", "  --classpath <file>      # Add <file> as a classpath resource.", "  --min-api <number>      # Minimum Android API level compatibility, default: " + AndroidApiLevel.getDefault().getLevel() + ".", "  --pg-conf <file>        # Proguard configuration <file>.", "  --pg-map-output <file>  # Output the resulting name and line mapping to <file>.", "  --desugared-lib <file>  # Specify desugared library configuration.", "                          # <file> is a desugared library configuration (json).", "  --desugared-lib-pg-conf-output <file>  # Output the Proguard configuration ", "                          # needed by L8 to <file>.", "  --no-tree-shaking       # Force disable tree shaking of unreachable classes.", "  --no-minification       # Force disable minification of names.", "  --no-data-resources     # Ignore all data resources.", "  --no-desugaring         # Force disable desugaring.", "  --main-dex-rules <file> # Proguard keep rules for classes to place in the", "                          # primary dex file.", "  --main-dex-list <file>  # List of classes to place in the primary dex file.", "  --feature <input> <output> ", "                          # Add feature <input> file to <output> file. Several ", "                          # occurrences can map to the same output.", "  --main-dex-list-output <file>  ", "                          # Output the full main-dex list in <file>."), ASSERTIONS_USAGE_MESSAGE, THREAD_COUNT_USAGE_MESSAGE, MAP_DIAGNOSTICS_USAGE_MESSAGE, Arrays.asList("  --version               # Print the version of r8.", "  --help                  # Print this message.")));

    public static void main(String[] args2) throws CompilationFailedException {
        R8Command command = (R8Command)R8CommandParser.parse(args2, Origin.root()).build();
        if (command.isPrintHelp()) {
            System.out.println(USAGE_MESSAGE);
        } else {
            R8.run(command);
        }
    }

    public static R8Command.Builder parse(String[] args2, Origin origin) {
        return new R8CommandParser().parse(args2, origin, R8Command.builder());
    }

    public static R8Command.Builder parse(String[] args2, Origin origin, DiagnosticsHandler handler) {
        return new R8CommandParser().parse(args2, origin, R8Command.builder(handler));
    }

    private R8Command.Builder parse(String[] args2, Origin origin, R8Command.Builder builder) {
        ParseState state = new ParseState();
        this.parse(args2, origin, builder, state);
        if (state.mode != null) {
            builder.setMode(state.mode);
        }
        Path outputPath = state.outputPath != null ? state.outputPath : Paths.get(".", new String[0]);
        OutputMode outputMode = state.outputMode != null ? state.outputMode : OutputMode.DexIndexed;
        builder.setOutput(outputPath, outputMode, state.includeDataResources);
        return builder;
    }

    private void parse(String[] args2, Origin argsOrigin, R8Command.Builder builder, ParseState state) {
        String[] expandedArgs = FlagFile.expandFlagFiles(args2, builder::error);
        HashMap<Path, List> featureSplitJars = new HashMap<Path, List>();
        for (int i = 0; i < expandedArgs.length; ++i) {
            String arg = expandedArgs[i].trim();
            String nextArg = null;
            String nextNextArg = null;
            if (OPTIONS_WITH_PARAMETER.contains(arg)) {
                if (++i >= expandedArgs.length) {
                    builder.error(new StringDiagnostic("Missing parameter for " + expandedArgs[i - 1] + ".", argsOrigin));
                    break;
                }
                nextArg = expandedArgs[i];
                if (OPTIONS_WITH_TWO_PARAMETERS.contains(arg)) {
                    if (++i < expandedArgs.length) {
                        nextNextArg = expandedArgs[i];
                    } else {
                        builder.error(new StringDiagnostic("Missing parameter for " + expandedArgs[i - 2] + ".", argsOrigin));
                        break;
                    }
                }
            }
            if (arg.length() == 0) continue;
            if (arg.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (arg.equals("--version")) {
                builder.setPrintVersion(true);
                continue;
            }
            if (arg.equals("--debug")) {
                if (state.mode == CompilationMode.RELEASE) {
                    builder.error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", argsOrigin));
                }
                state.mode = CompilationMode.DEBUG;
                continue;
            }
            if (arg.equals("--release")) {
                if (state.mode == CompilationMode.DEBUG) {
                    builder.error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", argsOrigin));
                }
                state.mode = CompilationMode.RELEASE;
                continue;
            }
            if (arg.equals("--dex")) {
                if (state.outputMode == OutputMode.ClassFile) {
                    builder.error(new StringDiagnostic("Cannot compile in both --dex and --classfile output mode.", argsOrigin));
                }
                state.outputMode = OutputMode.DexIndexed;
                continue;
            }
            if (arg.equals("--classfile")) {
                if (state.outputMode == OutputMode.DexIndexed) {
                    builder.error(new StringDiagnostic("Cannot compile in both --dex and --classfile output mode.", argsOrigin));
                }
                state.outputMode = OutputMode.ClassFile;
                continue;
            }
            if (arg.equals("--output")) {
                if (state.outputPath != null) {
                    builder.error(new StringDiagnostic("Cannot output both to '" + state.outputPath.toString() + "' and '" + nextArg + "'", argsOrigin));
                }
                state.outputPath = Paths.get(nextArg, new String[0]);
                continue;
            }
            if (arg.equals("--lib")) {
                R8CommandParser.addLibraryArgument(builder, argsOrigin, nextArg);
                continue;
            }
            if (arg.equals("--classpath")) {
                builder.addClasspathFiles(Paths.get(nextArg, new String[0]));
                continue;
            }
            if (arg.equals("--min-api")) {
                if (state.hasDefinedApiLevel) {
                    builder.error(new StringDiagnostic("Cannot set multiple --min-api options", argsOrigin));
                    continue;
                }
                R8CommandParser.parsePositiveIntArgument(builder::error, "--min-api", nextArg, argsOrigin, builder::setMinApiLevel);
                state.hasDefinedApiLevel = true;
                continue;
            }
            if (arg.equals("--thread-count")) {
                R8CommandParser.parsePositiveIntArgument(builder::error, "--thread-count", nextArg, argsOrigin, builder::setThreadCount);
                continue;
            }
            if (arg.equals("--no-tree-shaking")) {
                builder.setDisableTreeShaking(true);
                continue;
            }
            if (arg.equals("--no-minification")) {
                builder.setDisableMinification(true);
                continue;
            }
            if (arg.equals("--no-desugaring")) {
                builder.setDisableDesugaring(true);
                continue;
            }
            if (arg.equals("--main-dex-rules")) {
                builder.addMainDexRulesFiles(Paths.get(nextArg, new String[0]));
                continue;
            }
            if (arg.equals("--feature")) {
                featureSplitJars.computeIfAbsent(Paths.get(nextNextArg, new String[0]), k -> new ArrayList()).add(Paths.get(nextArg, new String[0]));
                continue;
            }
            if (arg.equals("--main-dex-list")) {
                builder.addMainDexListFiles(Paths.get(nextArg, new String[0]));
                continue;
            }
            if (arg.equals("--main-dex-list-output")) {
                builder.setMainDexListOutputPath(Paths.get(nextArg, new String[0]));
                continue;
            }
            if (arg.equals("--optimize-multidex-for-linearalloc")) {
                builder.setOptimizeMultidexForLinearAlloc(true);
                continue;
            }
            if (arg.equals("--pg-conf")) {
                builder.addProguardConfigurationFiles(Paths.get(nextArg, new String[0]));
                continue;
            }
            if (arg.equals("--pg-map-output")) {
                builder.setProguardMapOutputPath(Paths.get(nextArg, new String[0]));
                continue;
            }
            if (arg.equals("--desugared-lib")) {
                builder.addDesugaredLibraryConfiguration(StringResource.fromFile(Paths.get(nextArg, new String[0])));
                continue;
            }
            if (arg.equals("--desugared-lib-pg-conf-output")) {
                StringConsumer.FileConsumer consumer = new StringConsumer.FileConsumer(Paths.get(nextArg, new String[0]));
                builder.setDesugaredLibraryKeepRuleConsumer(consumer);
                continue;
            }
            if (arg.equals("--no-data-resources")) {
                state.includeDataResources = false;
                continue;
            }
            if (arg.equals("--map-id-template")) {
                builder.setMapIdProvider(MapIdTemplateProvider.create(nextArg, builder.getReporter()));
                continue;
            }
            if (arg.equals("--source-file-template")) {
                builder.setSourceFileProvider(SourceFileTemplateProvider.create(nextArg, builder.getReporter()));
                continue;
            }
            if (arg.startsWith("--")) {
                if (this.tryParseAssertionArgument(builder, arg, argsOrigin)) continue;
                int argsConsumed = this.tryParseMapDiagnostics(builder, arg, expandedArgs, i, argsOrigin);
                if (argsConsumed >= 0) {
                    i += argsConsumed;
                    continue;
                }
                argsConsumed = this.tryParseDump(builder, arg, expandedArgs, i, argsOrigin);
                if (argsConsumed >= 0) {
                    i += argsConsumed;
                    continue;
                }
                builder.error(new StringDiagnostic("Unknown option: " + arg, argsOrigin));
                continue;
            }
            if (arg.startsWith("@")) {
                builder.error(new StringDiagnostic("Recursive @argfiles are not supported: ", argsOrigin));
                continue;
            }
            builder.addProgramFiles(Paths.get(arg, new String[0]));
        }
        featureSplitJars.forEach((outputPath, inputJars) -> this.addFeatureJar(builder, (Path)outputPath, (List<Path>)inputJars));
    }

    public void addFeatureJar(R8Command.Builder builder, Path outputPath, List<Path> inputJarPaths) {
        builder.addFeatureSplit(featureSplitGenerator -> {
            featureSplitGenerator.setProgramConsumer(builder.createProgramOutputConsumer(outputPath, OutputMode.DexIndexed, true));
            for (Path inputPath : inputJarPaths) {
                featureSplitGenerator.addProgramResourceProvider(ArchiveProgramResourceProvider.fromArchive(inputPath));
            }
            return featureSplitGenerator.build();
        });
    }

    private static class ParseState {
        CompilationMode mode = null;
        OutputMode outputMode = null;
        Path outputPath = null;
        boolean hasDefinedApiLevel = false;
        private boolean includeDataResources = true;

        private ParseState() {
        }
    }
}

