/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;

public class ReadProguardMap {
    private static final String DEFAULT_MAP_FILE_NAME = "third_party/gmscore/v5/proguard.map";
    final Timing timing = Timing.empty();

    private void readProguardMapFile(String fileName) {
        try {
            System.out.println("  - reading " + fileName);
            this.timing.begin("Reading " + fileName);
            ClassNameMapper.mapperFromFile(Paths.get(fileName, new String[0]));
            this.timing.end();
        }
        catch (IOException e) {
            System.err.print("Failed to parse Proguard mapping file: " + e.getMessage());
        }
    }

    public static void main(String[] args2) {
        new ReadProguardMap().run(args2);
    }

    private void run(String[] args2) {
        System.out.println("ReadProguardMap benchmark.");
        if (args2.length == 0) {
            this.readProguardMapFile(DEFAULT_MAP_FILE_NAME);
        } else {
            Arrays.asList(args2).forEach(this::readProguardMapFile);
        }
        this.timing.report();
    }
}

