/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.androidapi;

import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.TraversalContinuation;
import java.util.ArrayList;
import java.util.function.BiFunction;

public abstract class AndroidApiClass {
    private final ClassReference classReference;

    public AndroidApiClass(ClassReference classReference) {
        this.classReference = classReference;
    }

    public abstract AndroidApiLevel getApiLevel();

    public abstract int getMemberCount();

    public TraversalContinuation<?> visitFields(BiFunction<FieldReference, AndroidApiLevel, TraversalContinuation<?>> visitor) {
        return this.visitFields(visitor, this.classReference, 1);
    }

    public TraversalContinuation<?> visitMethods(BiFunction<MethodReference, AndroidApiLevel, TraversalContinuation<?>> visitor) {
        return this.visitMethods(visitor, this.classReference, 1);
    }

    protected abstract TraversalContinuation<?> visitFields(BiFunction<FieldReference, AndroidApiLevel, TraversalContinuation<?>> var1, ClassReference var2, int var3);

    protected abstract TraversalContinuation<?> visitMethods(BiFunction<MethodReference, AndroidApiLevel, TraversalContinuation<?>> var1, ClassReference var2, int var3);

    protected TraversalContinuation<?> visitField(BiFunction<FieldReference, AndroidApiLevel, TraversalContinuation<?>> visitor, ClassReference holder, int minApiClass, int minApiField, String name, String typeDescriptor) {
        return visitor.apply(Reference.field(holder, name, Reference.typeFromDescriptor(typeDescriptor)), AndroidApiLevel.getAndroidApiLevel(Integer.max(minApiClass, minApiField)));
    }

    protected TraversalContinuation<?> visitMethod(BiFunction<MethodReference, AndroidApiLevel, TraversalContinuation<?>> visitor, ClassReference holder, int minApiClass, int minApiMethod, String name, String[] formalTypeDescriptors, String returnType) {
        ArrayList<TypeReference> typeReferenceList = new ArrayList<TypeReference>(formalTypeDescriptors.length);
        for (String formalTypeDescriptor : formalTypeDescriptors) {
            typeReferenceList.add(Reference.typeFromDescriptor(formalTypeDescriptor));
        }
        return visitor.apply(Reference.method(holder, name, typeReferenceList, returnType == null ? null : Reference.returnTypeFromDescriptor(returnType)), AndroidApiLevel.getAndroidApiLevel(Integer.max(minApiClass, minApiMethod)));
    }
}

