/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.androidapi;

import com.android.tools.r8.androidapi.AndroidApiReferenceLevelCache;
import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.InternalOptions;

public abstract class AndroidApiLevelCompute {
    private final ComputedApiLevel.KnownApiLevel[] knownApiLevelCache = new ComputedApiLevel.KnownApiLevel[AndroidApiLevel.LATEST.getLevel() + 1];

    public AndroidApiLevelCompute() {
        for (AndroidApiLevel value : AndroidApiLevel.values()) {
            if (value == AndroidApiLevel.ANDROID_PLATFORM) continue;
            this.knownApiLevelCache[value.getLevel()] = new ComputedApiLevel.KnownApiLevel(value);
        }
    }

    public static AndroidApiLevelCompute create(AppView<?> appView) {
        return appView.options().apiModelingOptions().enableApiCallerIdentification ? new DefaultAndroidApiLevelCompute(appView) : AndroidApiLevelCompute.noAndroidApiLevelCompute();
    }

    public static AndroidApiLevelCompute noAndroidApiLevelCompute() {
        return new NoAndroidApiLevelCompute();
    }

    public ComputedApiLevel.KnownApiLevel of(AndroidApiLevel apiLevel) {
        if (apiLevel == AndroidApiLevel.ANDROID_PLATFORM) {
            return ComputedApiLevel.platform();
        }
        return this.knownApiLevelCache[apiLevel.getLevel()];
    }

    public abstract ComputedApiLevel computeApiLevelForLibraryReference(DexReference var1, ComputedApiLevel var2);

    public abstract ComputedApiLevel computeApiLevelForDefinition(Iterable<DexType> var1, ComputedApiLevel var2);

    public ComputedApiLevel computeApiLevelForDefinition(DexMember<?, ?> reference, DexItemFactory factory, ComputedApiLevel unknownValue) {
        return this.computeApiLevelForDefinition(reference.getReferencedBaseTypes(factory), unknownValue);
    }

    public ComputedApiLevel computeInitialMinApiLevel(InternalOptions options) {
        return options.getMinApiLevel() == AndroidApiLevel.ANDROID_PLATFORM ? ComputedApiLevel.platform() : new ComputedApiLevel.KnownApiLevel(options.getMinApiLevel());
    }

    public ComputedApiLevel getPlatformApiLevelOrUnknown(AppView<?> appView) {
        if (appView.options().getMinApiLevel() == AndroidApiLevel.ANDROID_PLATFORM) {
            return ComputedApiLevel.platform();
        }
        return ComputedApiLevel.unknown();
    }

    public static class DefaultAndroidApiLevelCompute
    extends AndroidApiLevelCompute {
        private final AndroidApiReferenceLevelCache cache;
        private final ComputedApiLevel minApiLevel;

        public DefaultAndroidApiLevelCompute(AppView<?> appView) {
            this.cache = AndroidApiReferenceLevelCache.create(appView, this);
            this.minApiLevel = this.of(appView.options().getMinApiLevel());
        }

        @Override
        public ComputedApiLevel computeApiLevelForDefinition(Iterable<DexType> types, ComputedApiLevel unknownValue) {
            ComputedApiLevel computedLevel = this.minApiLevel;
            for (DexType type : types) {
                computedLevel = this.cache.lookupMax(type, computedLevel, unknownValue);
            }
            return computedLevel;
        }

        @Override
        public ComputedApiLevel computeApiLevelForLibraryReference(DexReference reference, ComputedApiLevel unknownValue) {
            return this.cache.lookup(reference, unknownValue);
        }
    }

    public static class NoAndroidApiLevelCompute
    extends AndroidApiLevelCompute {
        @Override
        public ComputedApiLevel computeApiLevelForDefinition(Iterable<DexType> types, ComputedApiLevel unknownValue) {
            return unknownValue;
        }

        @Override
        public ComputedApiLevel computeApiLevelForLibraryReference(DexReference reference, ComputedApiLevel unknownValue) {
            return unknownValue;
        }

        @Override
        public ComputedApiLevel computeInitialMinApiLevel(InternalOptions options) {
            return ComputedApiLevel.unknown();
        }
    }
}

