/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.androidapi;

import com.android.tools.r8.androidapi.AndroidApiLevelCompute;
import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AccessFlags;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DefaultInstanceInitializerCode;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.ThrowExceptionCode;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.synthesis.CommittedItems;
import com.android.tools.r8.synthesis.SyntheticProgramClassBuilder;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.WorkList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class ApiReferenceStubber {
    private final AppView<?> appView;
    private final Map<DexLibraryClass, Set<DexMethod>> libraryClassesToMock = new ConcurrentHashMap<DexLibraryClass, Set<DexMethod>>();
    private final Set<DexType> seenTypes = Sets.newConcurrentHashSet();
    private final AndroidApiLevelCompute apiLevelCompute;

    public ApiReferenceStubber(AppView<?> appView) {
        this.appView = appView;
        this.apiLevelCompute = appView.apiLevelCompute();
    }

    private void findReferencedLibraryMethod(DexMethod method) {
        DexType holderType = method.getHolderType();
        if (!holderType.isClassType()) {
            return;
        }
        DexType rewrittenType = this.appView.graphLens().lookupType(holderType);
        DexClass clazz = this.appView.definitionFor(rewrittenType);
        if (clazz == null || !clazz.isLibraryClass()) {
            return;
        }
        ComputedApiLevel apiLevel = this.apiLevelCompute.computeApiLevelForLibraryReference(method, ComputedApiLevel.unknown());
        if (apiLevel.isGreaterThan(this.appView.computedMinApiLevel())) {
            ComputedApiLevel holderApiLevel = this.apiLevelCompute.computeApiLevelForLibraryReference(rewrittenType, ComputedApiLevel.unknown());
            if (holderApiLevel.isUnknownApiLevel()) {
                return;
            }
            if (holderApiLevel.isGreaterThan(this.appView.computedMinApiLevel())) {
                this.libraryClassesToMock.computeIfAbsent(clazz.asLibraryClass(), ignored -> Sets.newConcurrentHashSet()).add(method);
            }
        }
    }

    private void findReferencedLibraryClasses(DexType type) {
        if (!type.isClassType()) {
            return;
        }
        WorkList<DexType> workList = WorkList.newIdentityWorkList(type, this.seenTypes);
        while (workList.hasNext()) {
            ComputedApiLevel androidApiLevel;
            DexClass clazz = this.appView.definitionFor(workList.next());
            if (clazz == null) continue;
            if (clazz.isLibraryClass() && (androidApiLevel = this.apiLevelCompute.computeApiLevelForLibraryReference(clazz.type, ComputedApiLevel.unknown())).isGreaterThan(this.appView.computedMinApiLevel()) && !androidApiLevel.isUnknownApiLevel()) {
                this.libraryClassesToMock.computeIfAbsent(clazz.asLibraryClass(), ignored -> Sets.newConcurrentHashSet());
            }
            workList.addIfNotSeen(clazz.allImmediateSupertypes());
        }
    }

    private void mockMissingLibraryClass(DexLibraryClass libraryClass, Set<DexMethod> methodsToStub, ThrowExceptionCode throwExceptionCode) {
        if (libraryClass.getType() == this.appView.dexItemFactory().objectType || libraryClass.getType().toDescriptorString().startsWith("Ljava/")) {
            return;
        }
        if (this.appView.options().machineDesugaredLibrarySpecification.isSupported(libraryClass.getType())) {
            return;
        }
        ((AppInfo)this.appView.appInfo()).getSyntheticItems().ensureFixedClassFromType(kinds -> kinds.API_MODEL_STUB, libraryClass.getType(), this.appView, classBuilder -> {
            ((SyntheticProgramClassBuilder)((SyntheticProgramClassBuilder)classBuilder.setSuperType(libraryClass.getSuperType())).setInterfaces(Arrays.asList(libraryClass.getInterfaces().values))).setVirtualMethods(this.buildLibraryMethodsForProgram(libraryClass, libraryClass.virtualMethods(), methodsToStub));
            if (libraryClass.isInterface()) {
                classBuilder.setInterface();
            }
            if (!libraryClass.isFinal()) {
                classBuilder.unsetFinal();
            }
            ArrayList<DexEncodedMethod> directMethods = !libraryClass.isInterface() || this.appView.options().canUseDefaultAndStaticInterfaceMethods() ? this.buildLibraryMethodsForProgram(libraryClass, libraryClass.directMethods(), methodsToStub) : new ArrayList<DexEncodedMethod>();
            directMethods.add(DexEncodedMethod.syntheticBuilder().setMethod(this.appView.dexItemFactory().createClassInitializer(libraryClass.getType())).setAccessFlags(MethodAccessFlags.createForClassInitializer()).setCode(throwExceptionCode).build());
            classBuilder.setDirectMethods(directMethods);
        }, ignored -> {});
    }

    private List<DexEncodedMethod> buildLibraryMethodsForProgram(DexLibraryClass clazz, Iterable<DexEncodedMethod> methods, Set<DexMethod> methodsToMock) {
        ArrayList<DexEncodedMethod> newMethods = new ArrayList<DexEncodedMethod>();
        methods.forEach(method -> {
            DexEncodedMethod newMethod;
            if (methodsToMock.contains(method.getReference()) && (newMethod = this.buildLibraryMethodForProgram(clazz, (DexEncodedMethod)method)) != null) {
                newMethods.add(newMethod);
            }
        });
        return newMethods;
    }

    private DexEncodedMethod buildLibraryMethodForProgram(DexLibraryClass clazz, DexEncodedMethod method) {
        assert (!clazz.isInterface() || !method.isStatic() || this.appView.options().canUseDefaultAndStaticInterfaceMethods());
        DexMethod newMethod = ((DexMethod)method.getReference()).withHolder(clazz.type, this.appView.dexItemFactory());
        DexEncodedMethod.Builder methodBuilder = DexEncodedMethod.syntheticBuilder(method).setMethod(newMethod).modifyAccessFlags(AccessFlags::setSynthetic);
        if (method.isInstanceInitializer()) {
            methodBuilder.setCode(DefaultInstanceInitializerCode.get());
        } else if (method.isVirtualMethod() && clazz.isInterface()) {
            methodBuilder.modifyAccessFlags(MethodAccessFlags::setAbstract);
        } else if (method.isAbstract()) {
            methodBuilder.modifyAccessFlags(MethodAccessFlags::setAbstract);
        } else {
            methodBuilder.modifyAccessFlags(MethodAccessFlags::setNative);
        }
        return methodBuilder.build();
    }

    public void run(ExecutorService executorService) throws ExecutionException {
        if (this.appView.options().isGeneratingClassFiles() || !this.appView.options().apiModelingOptions().enableStubbingOfClasses) {
            return;
        }
        ThreadUtils.processItems(((AppInfo)this.appView.appInfo()).classes(), this::processClass, executorService);
        if (this.libraryClassesToMock.isEmpty()) {
            return;
        }
        this.libraryClassesToMock.forEach((clazz, methods) -> this.mockMissingLibraryClass((DexLibraryClass)clazz, (Set<DexMethod>)methods, ThrowExceptionCode.create(this.appView.dexItemFactory().noClassDefFoundErrorType)));
        CommittedItems committedItems = this.appView.getSyntheticItems().commit(((AppInfo)this.appView.appInfo()).app());
        if (this.appView.hasLiveness()) {
            AppView<AppInfoWithLiveness> appInfoWithLivenessAppView = this.appView.withLiveness();
            appInfoWithLivenessAppView.setAppInfo(appInfoWithLivenessAppView.appInfo().rebuildWithLiveness(committedItems));
        } else if (this.appView.hasClassHierarchy()) {
            this.appView.withClassHierarchy().setAppInfo(((AppInfo)this.appView.appInfo()).withClassHierarchy().rebuildWithClassHierarchy(committedItems));
        } else {
            this.appView.withoutClassHierarchy().setAppInfo(new AppInfo(((AppInfo)this.appView.appInfo()).getSyntheticItems().commit(this.appView.app()), ((AppInfo)this.appView.appInfo()).getMainDexInfo()));
        }
    }

    public void processClass(DexProgramClass clazz) {
        if (this.appView.getSyntheticItems().isSyntheticOfKind(clazz.getType(), kinds -> kinds.API_MODEL_OUTLINE)) {
            return;
        }
        this.findReferencedLibraryClasses(clazz.type);
        clazz.forEachProgramMethodMatching(DexEncodedMethod::hasCode, method -> method.registerCodeReferences(new ReferencesToApiLevelUseRegistry((ProgramMethod)method)));
    }

    private class ReferencesToApiLevelUseRegistry
    extends UseRegistry<ProgramMethod> {
        public ReferencesToApiLevelUseRegistry(ProgramMethod context) {
            super(ApiReferenceStubber.this.appView, context);
        }

        private void checkReferenceToLibraryClass(DexReference reference) {
            DexType rewrittenType = ApiReferenceStubber.this.appView.graphLens().lookupType(reference.getContextType());
            ApiReferenceStubber.this.findReferencedLibraryClasses(rewrittenType);
            if (reference.isDexMethod()) {
                ApiReferenceStubber.this.findReferencedLibraryMethod(reference.asDexMethod());
            }
        }

        @Override
        public void registerInitClass(DexType type) {
            this.checkReferenceToLibraryClass(type);
        }

        @Override
        public void registerInvokeVirtual(DexMethod method) {
            this.checkReferenceToLibraryClass(method);
        }

        @Override
        public void registerInvokeDirect(DexMethod method) {
            this.checkReferenceToLibraryClass(method);
        }

        @Override
        public void registerInvokeStatic(DexMethod method) {
            this.checkReferenceToLibraryClass(method);
        }

        @Override
        public void registerInvokeInterface(DexMethod method) {
            this.checkReferenceToLibraryClass(method);
        }

        @Override
        public void registerInvokeSuper(DexMethod method) {
            this.checkReferenceToLibraryClass(method);
        }

        @Override
        public void registerInstanceFieldRead(DexField field) {
            this.checkReferenceToLibraryClass(field.type);
        }

        @Override
        public void registerInstanceFieldWrite(DexField field) {
            this.checkReferenceToLibraryClass(field.type);
        }

        @Override
        public void registerStaticFieldRead(DexField field) {
            this.checkReferenceToLibraryClass(field.type);
        }

        @Override
        public void registerStaticFieldWrite(DexField field) {
            this.checkReferenceToLibraryClass(field.type);
        }

        @Override
        public void registerTypeReference(DexType type) {
            this.checkReferenceToLibraryClass(type);
        }
    }
}

