/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.androidapi;

import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.structural.Equatable;
import java.util.Objects;

public interface ComputedApiLevel
extends Equatable<ComputedApiLevel> {
    public static NotSetApiLevel notSet() {
        return NotSetApiLevel.INSTANCE;
    }

    public static UnknownApiLevel unknown() {
        return UnknownApiLevel.INSTANCE;
    }

    public static KnownApiLevel platform() {
        return KnownApiLevel.PLATFORM_INSTANCE;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    default public boolean isNotSetApiLevel() {
        return false;
    }

    default public boolean isUnknownApiLevel() {
        return false;
    }

    default public ComputedApiLevel max(ComputedApiLevel other) {
        return this.isGreaterThanOrEqualTo(other) ? this : other;
    }

    default public boolean isGreaterThan(ComputedApiLevel other) {
        if (!1.$assertionsDisabled && (this.isNotSetApiLevel() || other.isNotSetApiLevel())) {
            throw new AssertionError((Object)"Cannot compute relationship for not set");
        }
        if (other.isUnknownApiLevel()) {
            return false;
        }
        if (this.isUnknownApiLevel()) {
            return true;
        }
        if (!(1.$assertionsDisabled || this.isKnownApiLevel() && other.isKnownApiLevel())) {
            throw new AssertionError();
        }
        return this.asKnownApiLevel().getApiLevel().isGreaterThan(other.asKnownApiLevel().getApiLevel());
    }

    default public boolean isGreaterThanOrEqualTo(ComputedApiLevel other) {
        if (!1.$assertionsDisabled && (this.isNotSetApiLevel() || other.isNotSetApiLevel())) {
            throw new AssertionError((Object)"Cannot compute relationship for not set");
        }
        return other.equals(this) || this.isGreaterThan(other);
    }

    default public boolean isKnownApiLevel() {
        return false;
    }

    default public KnownApiLevel asKnownApiLevel() {
        return null;
    }

    @Override
    default public boolean isEqualTo(ComputedApiLevel other) {
        return this.equals(other);
    }

    public static class KnownApiLevel
    implements ComputedApiLevel {
        private static final KnownApiLevel PLATFORM_INSTANCE = new KnownApiLevel(AndroidApiLevel.ANDROID_PLATFORM);
        private final AndroidApiLevel apiLevel;

        KnownApiLevel(AndroidApiLevel apiLevel) {
            this.apiLevel = apiLevel;
        }

        public AndroidApiLevel getApiLevel() {
            return this.apiLevel;
        }

        @Override
        public boolean isKnownApiLevel() {
            return true;
        }

        @Override
        public KnownApiLevel asKnownApiLevel() {
            return this;
        }

        public String toString() {
            return this.apiLevel.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KnownApiLevel)) {
                return false;
            }
            KnownApiLevel that = (KnownApiLevel)o;
            return this.apiLevel == that.apiLevel;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.apiLevel);
        }
    }

    public static class UnknownApiLevel
    implements ComputedApiLevel {
        private static final UnknownApiLevel INSTANCE = new UnknownApiLevel();

        private UnknownApiLevel() {
        }

        @Override
        public boolean isUnknownApiLevel() {
            return true;
        }

        public String toString() {
            return "UNKNOWN";
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }
    }

    public static class NotSetApiLevel
    implements ComputedApiLevel {
        private static final NotSetApiLevel INSTANCE = new NotSetApiLevel();

        private NotSetApiLevel() {
        }

        @Override
        public boolean isNotSetApiLevel() {
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }
    }
}

