/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.bisect;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.joptsimple.OptionParser;
import com.android.tools.r8.joptsimple.OptionSet;
import com.android.tools.r8.joptsimple.OptionSpec;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class BisectOptions {
    private static final String HELP_FLAG = "help";
    public static final String BUILD_GOOD_FLAG = "good";
    public static final String BUILD_BAD_FLAG = "bad";
    public static final String RESULT_GOOD_FLAG = "result-good";
    public static final String RESULT_BAD_FLAG = "result-bad";
    public static final String STATE_FLAG = "state";
    public static final String OUTPUT_FLAG = "output";
    public static final String COMMAND_FLAG = "command";
    public final Path goodBuild;
    public final Path badBuild;
    public final Path stateFile;
    public final Path command;
    public final Path output;
    public final Result result;

    private BisectOptions(Path goodBuild, Path badBuild, Path stateFile, Path command, Path output, Result result) {
        this.goodBuild = goodBuild;
        this.badBuild = badBuild;
        this.stateFile = stateFile;
        this.command = command;
        this.output = output;
        this.result = result;
    }

    public static BisectOptions parse(String[] args2) throws IOException {
        ParserSpec parser = new ParserSpec();
        OptionSet options = parser.parse(args2);
        if (options.has(parser.help)) {
            BisectOptions.printHelp(System.out);
            return null;
        }
        Path goodBuild = BisectOptions.exists(BisectOptions.require(options, parser.goodBuild, BUILD_GOOD_FLAG), BUILD_GOOD_FLAG);
        Path badBuild = BisectOptions.exists(BisectOptions.require(options, parser.badBuild, BUILD_BAD_FLAG), BUILD_BAD_FLAG);
        Path stateFile = null;
        if (options.valueOf(parser.stateFile) != null) {
            stateFile = BisectOptions.exists(options.valueOf(parser.stateFile), STATE_FLAG);
        }
        Path command = null;
        if (options.valueOf(parser.command) != null) {
            command = BisectOptions.exists(options.valueOf(parser.command), COMMAND_FLAG);
        }
        Path output = null;
        if (options.valueOf(parser.output) != null) {
            output = BisectOptions.directoryExists(options.valueOf(parser.output), OUTPUT_FLAG);
        }
        Result result = Result.UNKNOWN;
        if (options.has(parser.resultGood)) {
            result = Result.GOOD;
        }
        if (options.has(parser.resultBad)) {
            if (result == Result.GOOD) {
                throw new CompilationError("Cannot specify --result-good and --result-bad simultaneously");
            }
            result = Result.BAD;
        }
        return new BisectOptions(goodBuild, badBuild, stateFile, command, output, result);
    }

    private static <T> T require(OptionSet options, OptionSpec<T> option, String flag) {
        T value = options.valueOf(option);
        if (value != null) {
            return value;
        }
        throw new CompilationError("Missing required option: --" + flag);
    }

    private static Path exists(String path, String flag) {
        Path file = Paths.get(path, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            return file;
        }
        throw new CompilationError("File --" + flag + ": " + file + " does not exist");
    }

    private static Path directoryExists(String path, String flag) {
        Path file = Paths.get(path, new String[0]);
        if (Files.exists(file, new LinkOption[0]) && Files.isDirectory(file, new LinkOption[0])) {
            return file;
        }
        throw new CompilationError("File --" + flag + ": " + file + " is not a valid directory");
    }

    public static void printHelp(OutputStream out) throws IOException {
        ParserSpec.printHelp(out);
    }

    private static class ParserSpec {
        OptionSpec<String> goodBuild;
        OptionSpec<String> badBuild;
        OptionSpec<String> command;
        OptionSpec<String> stateFile;
        OptionSpec<String> output;
        OptionSpec<Void> resultGood;
        OptionSpec<Void> resultBad;
        OptionSpec<Void> help;

        private ParserSpec() {
        }

        static void printHelp(OutputStream out) throws IOException {
            OptionParser parser = new OptionParser();
            new ParserSpec().init(parser);
            parser.printHelpOn(out);
        }

        void init(OptionParser parser) {
            this.help = parser.accepts(BisectOptions.HELP_FLAG).forHelp();
            this.resultGood = parser.accepts(BisectOptions.RESULT_GOOD_FLAG, "Bisect again assuming previous run was good.");
            this.resultBad = parser.accepts(BisectOptions.RESULT_BAD_FLAG, "Bisect again assuming previous run was bad.");
            this.goodBuild = parser.accepts(BisectOptions.BUILD_GOOD_FLAG, "Known good APK.").withRequiredArg().describedAs("apk");
            this.badBuild = parser.accepts(BisectOptions.BUILD_BAD_FLAG, "Known bad APK.").withRequiredArg().describedAs("apk");
            this.stateFile = parser.accepts(BisectOptions.STATE_FLAG, "Bisection state.").requiredIf(this.resultGood, this.resultBad).withRequiredArg().describedAs("file");
            this.output = parser.accepts(BisectOptions.OUTPUT_FLAG, "Output directory.").withRequiredArg().describedAs("dir");
            this.command = parser.accepts(BisectOptions.COMMAND_FLAG, "Command to run after each bisection.").requiredUnless(this.stateFile, new OptionSpec[0]).withRequiredArg().describedAs("file");
        }

        OptionSet parse(String[] args2) {
            OptionParser parser = new OptionParser();
            this.init(parser);
            return parser.parse(args2);
        }
    }

    public static enum Result {
        UNKNOWN,
        GOOD,
        BAD;

    }
}

