/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfArithmeticBinop;
import com.android.tools.r8.cf.code.CfArrayLength;
import com.android.tools.r8.cf.code.CfArrayLoad;
import com.android.tools.r8.cf.code.CfArrayStore;
import com.android.tools.r8.cf.code.CfCheckCast;
import com.android.tools.r8.cf.code.CfCmp;
import com.android.tools.r8.cf.code.CfConstClass;
import com.android.tools.r8.cf.code.CfConstDynamic;
import com.android.tools.r8.cf.code.CfConstMethodHandle;
import com.android.tools.r8.cf.code.CfConstMethodType;
import com.android.tools.r8.cf.code.CfConstNull;
import com.android.tools.r8.cf.code.CfConstNumber;
import com.android.tools.r8.cf.code.CfConstString;
import com.android.tools.r8.cf.code.CfDexItemBasedConstString;
import com.android.tools.r8.cf.code.CfFieldInstruction;
import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfGoto;
import com.android.tools.r8.cf.code.CfIf;
import com.android.tools.r8.cf.code.CfIfCmp;
import com.android.tools.r8.cf.code.CfIinc;
import com.android.tools.r8.cf.code.CfInstanceFieldRead;
import com.android.tools.r8.cf.code.CfInstanceFieldWrite;
import com.android.tools.r8.cf.code.CfInstanceOf;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfInvokeDynamic;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfLogicalBinop;
import com.android.tools.r8.cf.code.CfMonitor;
import com.android.tools.r8.cf.code.CfMultiANewArray;
import com.android.tools.r8.cf.code.CfNeg;
import com.android.tools.r8.cf.code.CfNew;
import com.android.tools.r8.cf.code.CfNewArray;
import com.android.tools.r8.cf.code.CfNop;
import com.android.tools.r8.cf.code.CfNumberConversion;
import com.android.tools.r8.cf.code.CfPosition;
import com.android.tools.r8.cf.code.CfReturn;
import com.android.tools.r8.cf.code.CfReturnVoid;
import com.android.tools.r8.cf.code.CfStackInstruction;
import com.android.tools.r8.cf.code.CfStaticFieldRead;
import com.android.tools.r8.cf.code.CfStaticFieldWrite;
import com.android.tools.r8.cf.code.CfStore;
import com.android.tools.r8.cf.code.CfSwitch;
import com.android.tools.r8.cf.code.CfThrow;
import com.android.tools.r8.cf.code.CfTryCatch;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Monitor;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CfCodePrinter
extends CfPrinter {
    private Set<String> imports = new HashSet<String>();
    private List<String> methods = new ArrayList<String>();
    private Set<String> methodNames = new HashSet<String>();
    private Set<String> synthesizedTypes = new HashSet<String>();
    private List<CfLabel> sortedLabels = null;
    private Reference2IntMap<CfLabel> labelToIndex = null;
    private boolean pendingComma = false;
    private StringBuilder builder = null;
    private final Map<String, String> knownTypeFields = ImmutableMap.builder().put("Z", "booleanType").put("B", "byteType").put("C", "charType").put("D", "doubleType").put("F", "floatType").put("I", "intType").put("J", "longType").put("S", "shortType").put("V", "voidType").put("[Z", "booleanArrayType").put("[B", "byteArrayType").put("[C", "charArrayType").put("[D", "doubleArrayType").put("[F", "floatArrayType").put("[I", "intArrayType").put("[J", "longArrayType").put("[S", "shortArrayType").put("Ljava/lang/Object;", "objectType").put("Ljava/lang/Class;", "classType").put("Ljava/lang/Throwable;", "throwableType").put("Ljava/lang/String;", "stringType").put("Ljava/lang/Character;", "boxedCharType").put("Ljava/lang/CharSequence;", "charSequenceType").put("Ljava/lang/StringBuilder;", "stringBuilderType").put("Ljava/lang/AutoCloseable;", "autoCloseableType").build();

    private String quote(String string) {
        return "\"" + string + "\"";
    }

    private String longValue(long value) {
        return value < Integer.MIN_VALUE || Integer.MAX_VALUE < value ? value + "L" : "" + value;
    }

    private String type(String name, List<String> pkg) {
        assert (!name.contains("."));
        assert (pkg.stream().noneMatch(p -> p.contains(".")));
        this.imports.add(String.join((CharSequence)".", pkg) + "." + name);
        return name;
    }

    private String immutableListType() {
        return this.type("ImmutableList", ImmutableList.of("com", "google", "common", "collect"));
    }

    private String int2ReferenceAVLTreeMapType() {
        return this.type("Int2ReferenceAVLTreeMap", ImmutableList.of("it", "unimi", "dsi", "fastutil", "ints"));
    }

    private String frameTypeType() {
        return this.r8Type("FrameType", ImmutableList.of("cf", "code", "CfFrame"));
    }

    private String monitorType() {
        return this.r8Type("Monitor", ImmutableList.of("ir", "code"));
    }

    private String asmOpcodesType() {
        return this.type("Opcodes", ImmutableList.of("org", "objectweb", "asm"));
    }

    private String dexItemFactoryType() {
        return this.r8Type("DexItemFactory", "graph");
    }

    private String arrayDequeType() {
        return this.type("ArrayDeque", ImmutableList.of("java", "util"));
    }

    private String arraysType() {
        return this.type("Arrays", ImmutableList.of("java", "util"));
    }

    private String r8Type(String name, String pkg) {
        return this.r8Type(name, Collections.singletonList(pkg));
    }

    private String r8Type(String name, List<String> pkg) {
        return this.type(name, (List<String>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(ImmutableList.of("com", "android", "tools", "r8"))).addAll(pkg)).build()));
    }

    private String irType(String name) {
        return this.r8Type(name, ImmutableList.of("ir", "code"));
    }

    private String cfType(String name) {
        return this.r8Type(name, ImmutableList.of("cf", "code"));
    }

    private String labelName(CfLabel label) {
        return "label" + this.labelToIndex.getInt(label);
    }

    private String valueType(ValueType type) {
        return this.irType("ValueType") + "." + type.name();
    }

    private String numericType(NumericType type) {
        return this.irType("NumericType") + "." + type.name();
    }

    private String memberType(MemberType type) {
        return this.irType("MemberType") + "." + type.name();
    }

    private String ifTypeKind(If.Type kind) {
        return this.irType("If") + ".Type." + kind.name();
    }

    private String dexString(DexString string) {
        return "options.itemFactory.createString(" + this.quote(string.toString()) + ")";
    }

    private String dexType(DexType type) {
        String descriptor = type.toDescriptorString();
        String field = this.knownTypeFields.get(descriptor);
        if (field != null) {
            return "options.itemFactory." + field;
        }
        this.synthesizedTypes.add(descriptor);
        return "options.itemFactory.createType(" + this.quote(descriptor) + ")";
    }

    private String dexProto(DexProto proto) {
        StringBuilder builder = new StringBuilder().append("options.itemFactory.createProto(").append(this.dexType(proto.returnType));
        for (DexType param : proto.parameters.values) {
            builder.append(", ").append(this.dexType(param));
        }
        return builder.append(")").toString();
    }

    private String dexMethod(DexMethod method) {
        return "options.itemFactory.createMethod(" + this.dexType(method.holder) + ", " + this.dexProto(method.proto) + ", " + this.dexString(method.name) + ")";
    }

    private String dexField(DexField field) {
        return "options.itemFactory.createField(" + this.dexType(field.holder) + ", " + this.dexType(field.type) + ", " + this.dexString(field.name) + ")";
    }

    private void ensureComma() {
        if (this.pendingComma) {
            this.builder.append(",");
        }
        this.pendingComma = true;
    }

    private void printNewInstruction(String name, String ... args2) {
        this.ensureComma();
        this.builder.append("new ").append(this.cfType(name));
        StringUtils.append(this.builder, Arrays.asList(args2), ", ", StringUtils.BraceType.PARENS);
    }

    private void printNewVarInstruction(String name, ValueType type, int index) {
        this.printNewInstruction(name, this.valueType(type), "" + index);
    }

    private void printNewJumpInstruction(String name, If.Type kind, ValueType type, CfLabel target) {
        this.printNewInstruction(name, this.ifTypeKind(kind), this.valueType(type), this.labelName(target));
    }

    private String frameTypeType(CfFrame.FrameType frameType) {
        if (frameType.isTop()) {
            return this.frameTypeType() + ".top()";
        }
        if (frameType.isUninitializedThis()) {
            return this.frameTypeType() + ".uninitializedThis()";
        }
        if (frameType.isUninitializedNew()) {
            return this.frameTypeType() + ".uninitializedNew(new " + this.cfType("CfLabel") + "())";
        }
        assert (frameType.isInitialized());
        if (frameType.getInitializedType() == DexItemFactory.nullValueType) {
            return this.frameTypeType() + ".initialized(" + this.dexItemFactoryType() + ".nullValueType)";
        }
        return this.frameTypeType() + ".initialized(" + this.dexType(frameType.getInitializedType()) + ")";
    }

    public List<String> getImports() {
        ArrayList<String> sorted2 = new ArrayList<String>(this.imports);
        sorted2.sort(String::compareTo);
        return sorted2;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public void visitMethod(String methodName, CfCode code) {
        if (!this.methodNames.add(methodName)) {
            throw new IllegalStateException("Invalid attempt to visit the same method twice: " + methodName);
        }
        this.labelToIndex = new Reference2IntOpenHashMap<CfLabel>();
        this.sortedLabels = new ArrayList<CfLabel>();
        this.pendingComma = false;
        this.builder = new StringBuilder().append("public static ").append(this.r8Type("CfCode", "graph")).append(" ").append(methodName).append("(").append(this.r8Type("InternalOptions", "utils")).append(" options, ").append(this.r8Type("DexMethod", "graph")).append(" method) {");
        for (CfInstruction instruction : code.getInstructions()) {
            if (!(instruction instanceof CfLabel)) continue;
            CfLabel label = (CfLabel)instruction;
            this.labelToIndex.put(label, this.sortedLabels.size());
            this.sortedLabels.add(label);
            this.builder.append("CfLabel ").append(this.labelName(label)).append(" = new " + this.cfType("CfLabel") + "();");
        }
        this.builder.append("return new " + this.r8Type("CfCode", "graph") + "(").append("method.holder,").append(code.getMaxStack()).append(",").append(code.getMaxLocals()).append(",").append(this.immutableListType()).append(".of(");
        for (CfInstruction instruction : code.getInstructions()) {
            instruction.print(this);
        }
        this.builder.append("),").append(this.immutableListType()).append(".of(");
        this.pendingComma = false;
        for (CfTryCatch tryCatchRange : code.getTryCatchRanges()) {
            String guards = tryCatchRange.guards.stream().map(this::dexType).collect(Collectors.joining(", "));
            String targets = tryCatchRange.targets.stream().map(this::labelName).collect(Collectors.joining(", "));
            this.printNewInstruction("CfTryCatch", this.labelName(tryCatchRange.start), this.labelName(tryCatchRange.end), this.immutableListType() + ".of(" + guards + ")", this.immutableListType() + ".of(" + targets + ")");
        }
        this.builder.append("),").append(this.immutableListType()).append(".of());").append("}");
        this.methods.add(this.builder.toString());
    }

    @Override
    public void print(CfNop nop) {
    }

    @Override
    public void print(CfStackInstruction instruction) {
        this.printNewInstruction("CfStackInstruction", this.cfType("CfStackInstruction") + ".Opcode." + instruction.getOpcode().name());
    }

    @Override
    public void print(CfThrow insn) {
        this.printNewInstruction("CfThrow", new String[0]);
    }

    @Override
    public void print(CfConstNull constNull) {
        this.printNewInstruction("CfConstNull", new String[0]);
    }

    @Override
    public void print(CfConstNumber constNumber) {
        this.printNewInstruction("CfConstNumber", this.longValue(constNumber.getRawValue()), this.valueType(constNumber.getType()));
    }

    @Override
    public void print(CfConstClass constClass) {
        this.printNewInstruction("CfConstClass", this.dexType(constClass.getType()));
    }

    @Override
    public void print(CfConstDynamic constDynamic) {
        throw new Unimplemented(constDynamic.getClass().getSimpleName());
    }

    @Override
    public void print(CfReturnVoid ret) {
        this.printNewInstruction("CfReturnVoid", new String[0]);
    }

    @Override
    public void print(CfReturn ret) {
        this.printNewInstruction("CfReturn", this.valueType(ret.getType()));
    }

    @Override
    public void print(CfMonitor monitor) {
        this.printNewInstruction("CfMonitor", monitor.getType() == Monitor.Type.ENTER ? this.monitorType() + ".Type.ENTER" : this.monitorType() + ".Type.EXIT");
    }

    @Override
    public void print(CfArithmeticBinop arithmeticBinop) {
        this.printNewInstruction("CfArithmeticBinop", this.cfType("CfArithmeticBinop") + ".Opcode." + arithmeticBinop.getOpcode().name(), this.numericType(arithmeticBinop.getType()));
    }

    @Override
    public void print(CfCmp cmp) {
        this.printNewInstruction("CfCmp", this.irType("Cmp") + ".Bias." + cmp.getBias().name(), this.numericType(cmp.getType()));
    }

    @Override
    public void print(CfLogicalBinop logicalBinop) {
        this.printNewInstruction("CfLogicalBinop", this.cfType("CfLogicalBinop") + ".Opcode." + logicalBinop.getOpcode().name(), this.numericType(logicalBinop.getType()));
    }

    @Override
    public void print(CfNeg neg) {
        this.printNewInstruction("CfNeg", this.numericType(neg.getType()));
    }

    @Override
    public void print(CfNumberConversion numberConversion) {
        this.printNewInstruction("CfNumberConversion", this.numericType(numberConversion.getFromType()), this.numericType(numberConversion.getToType()));
    }

    @Override
    public void print(CfConstString constString) {
        this.printNewInstruction("CfConstString", this.dexString(constString.getString()));
    }

    @Override
    public void print(CfDexItemBasedConstString constString) {
        throw new Unimplemented(constString.getClass().getSimpleName());
    }

    @Override
    public void print(CfArrayLoad arrayLoad) {
        this.printNewInstruction("CfArrayLoad", this.memberType(arrayLoad.getType()));
    }

    @Override
    public void print(CfArrayStore arrayStore) {
        this.printNewInstruction("CfArrayStore", this.memberType(arrayStore.getType()));
    }

    @Override
    public void print(CfInvoke invoke) {
        this.printNewInstruction("CfInvoke", Integer.toString(invoke.getOpcode()), this.dexMethod(invoke.getMethod()), Boolean.toString(invoke.isInterface()));
    }

    @Override
    public void print(CfInvokeDynamic invoke) {
        throw new Unimplemented(invoke.getClass().getSimpleName());
    }

    @Override
    public void print(CfFrame frame) {
        String keys2 = StringUtils.join(",", frame.getLocals().keySet());
        String values2 = StringUtils.join(",", frame.getLocals().values(), this::frameTypeType);
        String stack = StringUtils.join(",", frame.getStack(), this::frameTypeType);
        this.printNewInstruction("CfFrame", "new " + this.int2ReferenceAVLTreeMapType() + "<>(new int[] {" + keys2 + "},new " + this.frameTypeType() + "[] { " + values2 + " })", "new " + this.arrayDequeType() + "<>(" + this.arraysType() + ".asList(" + stack + "))");
    }

    @Override
    public void print(CfInstanceOf insn) {
        this.printNewInstruction("CfInstanceOf", this.dexType(insn.getType()));
    }

    @Override
    public void print(CfCheckCast insn) {
        this.printNewInstruction("CfCheckCast", this.dexType(insn.getType()));
    }

    @Override
    public void print(CfInstanceFieldRead insn) {
        this.printNewInstruction("CfInstanceFieldRead", this.dexField(insn.getField()));
    }

    @Override
    public void print(CfInstanceFieldWrite insn) {
        this.printNewInstruction("CfInstanceFieldWrite", this.dexField(insn.getField()));
    }

    @Override
    public void print(CfStaticFieldRead insn) {
        this.printNewInstruction("CfStaticFieldRead", this.dexField(insn.getField()));
    }

    @Override
    public void print(CfStaticFieldWrite insn) {
        this.printNewInstruction("CfStaticFieldWrite", this.dexField(insn.getField()));
    }

    @Override
    public void print(CfFieldInstruction insn) {
        throw new Unreachable();
    }

    @Override
    public void print(CfNew newInstance) {
        this.printNewInstruction("CfNew", this.dexType(newInstance.getType()));
    }

    @Override
    public void print(CfNewArray newArray) {
        this.printNewInstruction("CfNewArray", this.dexType(newArray.getType()));
    }

    @Override
    public void print(CfMultiANewArray multiANewArray) {
        throw new Unimplemented(multiANewArray.getClass().getSimpleName());
    }

    @Override
    public void print(CfArrayLength arrayLength) {
        this.printNewInstruction("CfArrayLength", new String[0]);
    }

    @Override
    public void print(CfLabel label) {
        this.ensureComma();
        this.builder.append(this.labelName(label));
    }

    @Override
    public void print(CfPosition instruction) {
    }

    @Override
    public void print(CfGoto jump) {
        this.printNewInstruction("CfGoto", this.labelName(jump.getTarget()));
    }

    @Override
    public void print(CfIf conditional) {
        this.printNewJumpInstruction("CfIf", conditional.getKind(), conditional.getType(), conditional.getTarget());
    }

    @Override
    public void print(CfIfCmp conditional) {
        this.printNewJumpInstruction("CfIfCmp", conditional.getKind(), conditional.getType(), conditional.getTarget());
    }

    @Override
    public void print(CfSwitch cfSwitch) {
        throw new Unimplemented(cfSwitch.getClass().getSimpleName());
    }

    @Override
    public void print(CfLoad load) {
        this.printNewVarInstruction("CfLoad", load.getType(), load.getLocalIndex());
    }

    @Override
    public void print(CfStore store) {
        this.printNewVarInstruction("CfStore", store.getType(), store.getLocalIndex());
    }

    @Override
    public void print(CfIinc instruction) {
        this.printNewInstruction("CfIinc", Integer.toString(instruction.getLocalIndex()), Integer.toString(instruction.getIncrement()));
    }

    @Override
    public void print(CfConstMethodHandle handle) {
        throw new Unimplemented(handle.getClass().getSimpleName());
    }

    @Override
    public void print(CfConstMethodType type) {
        throw new Unimplemented(type.getClass().getSimpleName());
    }

    public Set<String> getSynthesizedTypes() {
        return this.synthesizedTypes;
    }
}

