/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.utils.structural.CompareToVisitor;

public class CfArithmeticBinop
extends CfInstruction {
    private final Opcode opcode;
    private final NumericType type;

    public CfArithmeticBinop(Opcode opcode, NumericType type) {
        assert (opcode != null);
        assert (type != null);
        this.opcode = opcode;
        this.type = type;
    }

    public static CfArithmeticBinop fromAsm(int opcode) {
        switch (opcode) {
            case 96: {
                return new CfArithmeticBinop(Opcode.Add, NumericType.INT);
            }
            case 97: {
                return new CfArithmeticBinop(Opcode.Add, NumericType.LONG);
            }
            case 98: {
                return new CfArithmeticBinop(Opcode.Add, NumericType.FLOAT);
            }
            case 99: {
                return new CfArithmeticBinop(Opcode.Add, NumericType.DOUBLE);
            }
            case 100: {
                return new CfArithmeticBinop(Opcode.Sub, NumericType.INT);
            }
            case 101: {
                return new CfArithmeticBinop(Opcode.Sub, NumericType.LONG);
            }
            case 102: {
                return new CfArithmeticBinop(Opcode.Sub, NumericType.FLOAT);
            }
            case 103: {
                return new CfArithmeticBinop(Opcode.Sub, NumericType.DOUBLE);
            }
            case 104: {
                return new CfArithmeticBinop(Opcode.Mul, NumericType.INT);
            }
            case 105: {
                return new CfArithmeticBinop(Opcode.Mul, NumericType.LONG);
            }
            case 106: {
                return new CfArithmeticBinop(Opcode.Mul, NumericType.FLOAT);
            }
            case 107: {
                return new CfArithmeticBinop(Opcode.Mul, NumericType.DOUBLE);
            }
            case 108: {
                return new CfArithmeticBinop(Opcode.Div, NumericType.INT);
            }
            case 109: {
                return new CfArithmeticBinop(Opcode.Div, NumericType.LONG);
            }
            case 110: {
                return new CfArithmeticBinop(Opcode.Div, NumericType.FLOAT);
            }
            case 111: {
                return new CfArithmeticBinop(Opcode.Div, NumericType.DOUBLE);
            }
            case 112: {
                return new CfArithmeticBinop(Opcode.Rem, NumericType.INT);
            }
            case 113: {
                return new CfArithmeticBinop(Opcode.Rem, NumericType.LONG);
            }
            case 114: {
                return new CfArithmeticBinop(Opcode.Rem, NumericType.FLOAT);
            }
            case 115: {
                return new CfArithmeticBinop(Opcode.Rem, NumericType.DOUBLE);
            }
        }
        throw new Unreachable("Wrong ASM opcode for CfArithmeticBinop " + opcode);
    }

    private int getAsmOpcodeTypeOffset() {
        switch (this.type) {
            case LONG: {
                return 1;
            }
            case FLOAT: {
                return 2;
            }
            case DOUBLE: {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public int getCompareToId() {
        return this.getAsmOpcode();
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        return CfCompareHelper.compareIdUniquelyDeterminesEquality(this, other);
    }

    public Opcode getOpcode() {
        return this.opcode;
    }

    public NumericType getType() {
        return this.type;
    }

    public int getAsmOpcode() {
        switch (this.opcode) {
            case Add: {
                return 96 + this.getAsmOpcodeTypeOffset();
            }
            case Sub: {
                return 100 + this.getAsmOpcodeTypeOffset();
            }
            case Mul: {
                return 104 + this.getAsmOpcodeTypeOffset();
            }
            case Div: {
                return 108 + this.getAsmOpcodeTypeOffset();
            }
            case Rem: {
                return 112 + this.getAsmOpcodeTypeOffset();
            }
        }
        throw new Unreachable("CfArithmeticBinop has unknown opcode " + (Object)((Object)this.opcode));
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        visitor.visitInsn(this.getAsmOpcode());
    }

    @Override
    public boolean canThrow() {
        return this.type != NumericType.FLOAT && this.type != NumericType.DOUBLE && (this.opcode == Opcode.Div || this.opcode == Opcode.Rem);
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        int right = state.pop().register;
        int left = state.pop().register;
        int dest = state.push((ValueType)ValueType.fromNumericType((NumericType)this.type)).register;
        switch (this.opcode) {
            case Add: {
                builder.addAdd(this.type, dest, left, right);
                break;
            }
            case Sub: {
                builder.addSub(this.type, dest, left, right);
                break;
            }
            case Mul: {
                builder.addMul(this.type, dest, left, right);
                break;
            }
            case Div: {
                builder.addDiv(this.type, dest, left, right);
                break;
            }
            case Rem: {
                builder.addRem(this.type, dest, left, right);
                break;
            }
            default: {
                throw new Unreachable("CfArithmeticBinop has unknown opcode " + (Object)((Object)this.opcode));
            }
        }
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        return inliningConstraints.forBinop();
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
        CfFrame.FrameType frameType = CfFrame.FrameType.fromNumericType(this.type, dexItemFactory);
        frameBuilder.popAndDiscard(frameType, frameType).push(frameType);
    }

    public static enum Opcode {
        Add,
        Sub,
        Mul,
        Div,
        Rem;

    }
}

