/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.utils.structural.CompareToVisitor;

public class CfArrayLoad
extends CfInstruction {
    private final MemberType type;

    public CfArrayLoad(MemberType type) {
        assert (type.isPrecise());
        this.type = type;
    }

    private int getLoadType() {
        switch (this.type) {
            case OBJECT: {
                return 50;
            }
            case BOOLEAN_OR_BYTE: {
                return 51;
            }
            case CHAR: {
                return 52;
            }
            case SHORT: {
                return 53;
            }
            case INT: {
                return 46;
            }
            case FLOAT: {
                return 48;
            }
            case LONG: {
                return 47;
            }
            case DOUBLE: {
                return 49;
            }
        }
        throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
    }

    @Override
    public int getCompareToId() {
        return this.getLoadType();
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        return CfCompareHelper.compareIdUniquelyDeterminesEquality(this, other);
    }

    public MemberType getType() {
        return this.type;
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        visitor.visitInsn(this.getLoadType());
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        CfState.Slot value;
        CfState.Slot index = state.pop();
        CfState.Slot array = state.pop();
        assert (array.type.isObject());
        ValueType memberType = ValueType.fromMemberType(this.type);
        if (array.preciseType != null) {
            value = state.push(array.preciseType.toArrayElementType(builder.appView.dexItemFactory()));
            assert (state.peek().type == memberType);
        } else {
            value = state.push(memberType);
        }
        builder.addArrayGet(this.type, value.register, array.register, index.register);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        return inliningConstraints.forArrayGet();
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
        frameBuilder.popAndDiscardInitialized(dexItemFactory.objectArrayType, dexItemFactory.intType);
        frameBuilder.push(CfFrame.FrameType.fromMemberType(this.type, dexItemFactory));
    }
}

