/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstanceFieldRead;
import com.android.tools.r8.cf.code.CfInstanceFieldWrite;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfStaticFieldRead;
import com.android.tools.r8.cf.code.CfStaticFieldWrite;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.utils.BiPredicateUtils;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.function.BiPredicate;

public abstract class CfFieldInstruction
extends CfInstruction {
    private final int opcode;
    private final DexField field;
    private final DexField declaringField;

    private static void specify(StructuralSpecification<CfFieldInstruction, ?> spec) {
        ((StructuralSpecification)((StructuralSpecification)spec.withInt(f -> f.opcode)).withItem(f -> f.field)).withItem(f -> f.declaringField);
    }

    public CfFieldInstruction(int opcode, DexField field) {
        this(opcode, field, field);
    }

    public CfFieldInstruction(int opcode, DexField field, DexField declaringField) {
        this.opcode = opcode;
        this.field = field;
        this.declaringField = declaringField;
        assert (field.type == declaringField.type);
    }

    public static CfFieldInstruction create(int opcode, DexField field, DexField declaringField) {
        switch (opcode) {
            case 178: {
                return new CfStaticFieldRead(field, declaringField);
            }
            case 179: {
                return new CfStaticFieldWrite(field, declaringField);
            }
            case 180: {
                return new CfInstanceFieldRead(field, declaringField);
            }
            case 181: {
                return new CfInstanceFieldWrite(field, declaringField);
            }
        }
        throw new Unreachable("Unexpected opcode " + opcode);
    }

    public DexField getField() {
        return this.field;
    }

    public int getOpcode() {
        return this.opcode;
    }

    @Override
    public int getCompareToId() {
        return this.opcode;
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        return visitor.visit(this, other.asFieldInstruction(), CfFieldInstruction::specify);
    }

    public boolean isFieldGet() {
        return this.opcode == 180 || this.opcode == 178;
    }

    public boolean isStaticFieldGet() {
        return this.opcode == 178;
    }

    @Override
    public CfFieldInstruction asFieldInstruction() {
        return this;
    }

    @Override
    public boolean isFieldInstruction() {
        return true;
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        DexField rewrittenField = graphLens.lookupField(this.field);
        DexField rewrittenDeclaringField = graphLens.lookupField(this.declaringField);
        String owner = namingLens.lookupInternalName(rewrittenField.holder);
        String name = namingLens.lookupName(rewrittenDeclaringField).toString();
        String desc = namingLens.lookupDescriptor(rewrittenField.type).toString();
        visitor.visitFieldInsn(this.opcode, owner, name, desc);
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        DexType type = this.field.type;
        switch (this.opcode) {
            case 178: {
                builder.addStaticGet(state.push((DexType)type).register, this.field);
                break;
            }
            case 179: {
                CfState.Slot value = state.pop();
                builder.addStaticPut(value.register, this.field);
                break;
            }
            case 180: {
                CfState.Slot object = state.pop();
                builder.addInstanceGet(state.push((DexType)type).register, object.register, this.field);
                break;
            }
            case 181: {
                CfState.Slot value = state.pop();
                CfState.Slot object = state.pop();
                builder.addInstancePut(value.register, object.register, this.field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected opcode " + this.opcode);
            }
        }
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        switch (this.opcode) {
            case 178: {
                return inliningConstraints.forStaticGet(this.field, context);
            }
            case 179: {
                return inliningConstraints.forStaticPut(this.field, context);
            }
            case 180: {
                return inliningConstraints.forInstanceGet(this.field, context);
            }
            case 181: {
                return inliningConstraints.forInstancePut(this.field, context);
            }
        }
        throw new Unreachable("Unexpected opcode " + this.opcode);
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
        switch (this.opcode) {
            case 180: {
                frameBuilder.popAndDiscardInitialized(this.field.holder).push(this.field.type);
                return;
            }
            case 178: {
                frameBuilder.push(this.field.type);
                return;
            }
            case 181: {
                BiPredicate[] biPredicateArray = new BiPredicate[2];
                biPredicateArray[0] = frameBuilder::isUninitializedThisAndTarget;
                biPredicateArray[1] = frameBuilder::isAssignableAndInitialized;
                frameBuilder.popAndDiscardInitialized(this.field.type).pop(this.field.holder, BiPredicateUtils.or(biPredicateArray));
                return;
            }
            case 179: {
                frameBuilder.popAndDiscardInitialized(this.field.type);
                return;
            }
        }
        throw new Unreachable("Unexpected opcode " + this.opcode);
    }
}

