/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCodeStackMapValidatingException;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.Opcodes;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.SortedMap;
import java.util.function.Function;

public class CfFrame
extends CfInstruction {
    private final Int2ReferenceSortedMap<FrameType> locals;
    private final Deque<FrameType> stack;

    public CfFrame(Int2ReferenceSortedMap<FrameType> locals, Deque<FrameType> stack) {
        assert (locals.values().stream().allMatch(Objects::nonNull));
        assert (stack.stream().allMatch(Objects::nonNull));
        this.locals = locals;
        this.stack = stack;
    }

    public CfFrame(SortedMap<Integer, FrameType> locals, Deque<FrameType> stack) {
        this((Int2ReferenceSortedMap<FrameType>)(locals instanceof Int2ReferenceAVLTreeMap ? (Int2ReferenceAVLTreeMap<Object>)locals : new Int2ReferenceAVLTreeMap<FrameType>(locals)), stack);
    }

    private int computeStackCount() {
        return this.stack.size();
    }

    private Object[] computeStackTypes(int stackCount, GraphLens graphLens, NamingLens namingLens) {
        assert (stackCount == this.stack.size());
        if (stackCount == 0) {
            return null;
        }
        Object[] stackTypes = new Object[stackCount];
        int index = 0;
        for (FrameType frameType : this.stack) {
            stackTypes[index++] = frameType.getTypeOpcode(graphLens, namingLens);
        }
        return stackTypes;
    }

    private int computeLocalsCount() {
        if (this.locals.isEmpty()) {
            return 0;
        }
        int maxRegister = this.locals.lastIntKey();
        int localsCount = 0;
        for (int i = 0; i <= maxRegister; ++i) {
            ++localsCount;
            FrameType type = (FrameType)this.locals.get(i);
            if (type == null || !type.isWide()) continue;
            ++i;
        }
        return localsCount;
    }

    private Object[] computeLocalsTypes(int localsCount, GraphLens graphLens, NamingLens namingLens) {
        if (localsCount == 0) {
            return null;
        }
        int maxRegister = this.locals.lastIntKey();
        Object[] localsTypes = new Object[localsCount];
        int localIndex = 0;
        for (int i = 0; i <= maxRegister; ++i) {
            FrameType type = (FrameType)this.locals.get(i);
            Object object = localsTypes[localIndex++] = type == null ? Opcodes.TOP : type.getTypeOpcode(graphLens, namingLens);
            if (type == null || !type.isWide()) continue;
            ++i;
        }
        return localsTypes;
    }

    private FrameType getInitializedFrameType(FrameType unInit, FrameType other, DexType newType) {
        assert (!unInit.isInitialized());
        if (other.isInitialized()) {
            return other;
        }
        if (unInit.isUninitializedThis() && other.isUninitializedThis()) {
            return FrameType.initialized(newType);
        }
        if (unInit.isUninitializedNew() && other.isUninitializedNew() && unInit.getUninitializedLabel() == other.getUninitializedLabel()) {
            return FrameType.initialized(newType);
        }
        return other;
    }

    @Override
    public boolean isFrame() {
        return true;
    }

    @Override
    public CfFrame asFrame() {
        return this;
    }

    @Override
    public int getCompareToId() {
        return CfCompareHelper.FRAME_COMPARE_ID;
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        return CfCompareHelper.compareIdUniquelyDeterminesEquality(this, other);
    }

    public Int2ReferenceSortedMap<FrameType> getLocals() {
        return this.locals;
    }

    public SortedMap<Integer, FrameType> getLocalsAsSortedMap() {
        return this.locals;
    }

    public Deque<FrameType> getStack() {
        return this.stack;
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        int stackCount = this.computeStackCount();
        Object[] stackTypes = this.computeStackTypes(stackCount, graphLens, namingLens);
        int localsCount = this.computeLocalsCount();
        Object[] localsTypes = this.computeLocalsTypes(localsCount, graphLens, namingLens);
        visitor.visitFrame(-1, localsCount, localsTypes, stackCount, stackTypes);
    }

    public int computeStackSize() {
        int size = 0;
        for (FrameType frameType : this.stack) {
            size += frameType.isWide() ? 2 : 1;
        }
        return size;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        code.setStateFromFrame(this);
    }

    @Override
    public boolean emitsIR() {
        return false;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
        frameBuilder.checkFrameAndSet(this);
    }

    public CfFrame markInstantiated(FrameType uninitializedType, DexType initType) {
        if (uninitializedType.isInitialized()) {
            throw CfCodeStackMapValidatingException.error("Cannot instantiate already instantiated type " + uninitializedType);
        }
        Int2ReferenceAVLTreeMap<FrameType> newLocals = new Int2ReferenceAVLTreeMap<FrameType>();
        IntBidirectionalIterator intBidirectionalIterator = this.locals.keySet().iterator();
        while (intBidirectionalIterator.hasNext()) {
            int var = (Integer)intBidirectionalIterator.next();
            newLocals.put(var, this.getInitializedFrameType(uninitializedType, (FrameType)this.locals.get(var), initType));
        }
        ArrayDeque<FrameType> newStack = new ArrayDeque<FrameType>();
        for (FrameType frameType : this.stack) {
            newStack.addLast(this.getInitializedFrameType(uninitializedType, frameType, initType));
        }
        return new CfFrame((Int2ReferenceSortedMap<FrameType>)newLocals, (Deque<FrameType>)newStack);
    }

    public CfFrame map(Function<DexType, DexType> func) {
        FrameType mappedType;
        int var;
        FrameType originalType;
        boolean mapped = false;
        Iterator<Integer> iterator2 = this.locals.keySet().iterator();
        while (iterator2.hasNext() && !(mapped = (originalType = (FrameType)this.locals.get(var = ((Integer)iterator2.next()).intValue())) != (mappedType = originalType.map(func)))) {
        }
        if (!mapped) {
            FrameType mappedType2;
            FrameType frameType;
            iterator2 = this.stack.iterator();
            while (iterator2.hasNext() && !(mapped = (frameType = (FrameType)((Object)iterator2.next())) != (mappedType2 = frameType.map(func)))) {
            }
        }
        if (!mapped) {
            return this;
        }
        Int2ReferenceAVLTreeMap<FrameType> newLocals = new Int2ReferenceAVLTreeMap<FrameType>();
        IntBidirectionalIterator frameType = this.locals.keySet().iterator();
        while (frameType.hasNext()) {
            int var2 = (Integer)frameType.next();
            newLocals.put(var2, ((FrameType)this.locals.get(var2)).map(func));
        }
        ArrayDeque<FrameType> newStack = new ArrayDeque<FrameType>();
        for (FrameType frameType2 : this.stack) {
            newStack.addLast(frameType2.map(func));
        }
        return new CfFrame((Int2ReferenceSortedMap<FrameType>)newLocals, (Deque<FrameType>)newStack);
    }

    private static class TwoWord
    extends FrameType {
        private static final TwoWord SINGLETON = new TwoWord();

        private TwoWord() {
        }

        @Override
        Object getTypeOpcode(GraphLens graphLens, NamingLens namingLens) {
            throw new Unreachable("Should only be used for verification");
        }

        @Override
        public boolean isWide() {
            return true;
        }

        @Override
        public boolean isTwoWord() {
            return true;
        }

        public String toString() {
            return "twoword";
        }
    }

    private static class OneWord
    extends FrameType {
        private static final OneWord SINGLETON = new OneWord();

        private OneWord() {
        }

        @Override
        Object getTypeOpcode(GraphLens graphLens, NamingLens namingLens) {
            throw new Unreachable("Should only be used for verification");
        }

        @Override
        public boolean isOneWord() {
            return true;
        }

        public String toString() {
            return "oneword";
        }
    }

    private static class UninitializedThis
    extends FrameType {
        private UninitializedThis() {
        }

        @Override
        Object getTypeOpcode(GraphLens graphLens, NamingLens namingLens) {
            return Opcodes.UNINITIALIZED_THIS;
        }

        public String toString() {
            return "uninitialized this";
        }

        @Override
        public boolean isUninitializedThis() {
            return true;
        }
    }

    private static class UninitializedNew
    extends FrameType {
        private final CfLabel label;
        private final DexType type;

        private UninitializedNew(CfLabel label, DexType type) {
            this.label = label;
            this.type = type;
        }

        public String toString() {
            return "uninitialized new";
        }

        @Override
        Object getTypeOpcode(GraphLens graphLens, NamingLens namingLens) {
            return this.label.getLabel();
        }

        @Override
        public boolean isUninitializedNew() {
            return true;
        }

        @Override
        public CfLabel getUninitializedLabel() {
            return this.label;
        }

        @Override
        public DexType getUninitializedNewType() {
            return this.type;
        }
    }

    private static class Top
    extends FrameType {
        private static final Top SINGLETON = new Top();

        private Top() {
        }

        public String toString() {
            return "top";
        }

        @Override
        Object getTypeOpcode(GraphLens graphLens, NamingLens namingLens) {
            return Opcodes.TOP;
        }

        @Override
        public boolean isTop() {
            return true;
        }
    }

    private static class InitializedType
    extends FrameType {
        private final DexType type;

        private InitializedType(DexType type) {
            assert (type != null);
            this.type = type;
        }

        public String toString() {
            return "Initialized(" + this.type.toString() + ")";
        }

        @Override
        Object getTypeOpcode(GraphLens graphLens, NamingLens namingLens) {
            DexType rewrittenType = graphLens.lookupType(this.type);
            if (rewrittenType == DexItemFactory.nullValueType) {
                return Opcodes.NULL;
            }
            switch (rewrittenType.toShorty()) {
                case 'L': {
                    return namingLens.lookupInternalName(rewrittenType);
                }
                case 'I': {
                    return Opcodes.INTEGER;
                }
                case 'F': {
                    return Opcodes.FLOAT;
                }
                case 'J': {
                    return Opcodes.LONG;
                }
                case 'D': {
                    return Opcodes.DOUBLE;
                }
            }
            throw new Unreachable("Unexpected value type: " + rewrittenType);
        }

        @Override
        public boolean isWide() {
            return this.type.isPrimitiveType() && (this.type.toShorty() == 'J' || this.type.toShorty() == 'D');
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public DexType getInitializedType() {
            return this.type;
        }
    }

    public static abstract class FrameType {
        public static FrameType initialized(DexType type) {
            return new InitializedType(type);
        }

        public static FrameType uninitializedNew(CfLabel label, DexType typeToInitialize) {
            return new UninitializedNew(label, typeToInitialize);
        }

        public static FrameType uninitializedThis() {
            return new UninitializedThis();
        }

        public static FrameType top() {
            return Top.SINGLETON;
        }

        public static FrameType oneWord() {
            return OneWord.SINGLETON;
        }

        public static FrameType twoWord() {
            return TwoWord.SINGLETON;
        }

        private FrameType() {
        }

        public static FrameType fromMemberType(MemberType memberType, DexItemFactory factory) {
            switch (memberType) {
                case OBJECT: {
                    return FrameType.initialized(factory.objectType);
                }
                case BOOLEAN_OR_BYTE: {
                    return FrameType.initialized(factory.intType);
                }
                case CHAR: {
                    return FrameType.initialized(factory.intType);
                }
                case SHORT: {
                    return FrameType.initialized(factory.intType);
                }
                case INT: {
                    return FrameType.initialized(factory.intType);
                }
                case FLOAT: {
                    return FrameType.initialized(factory.floatType);
                }
                case LONG: {
                    return FrameType.initialized(factory.longType);
                }
                case DOUBLE: {
                    return FrameType.initialized(factory.doubleType);
                }
                case INT_OR_FLOAT: {
                    return FrameType.oneWord();
                }
                case LONG_OR_DOUBLE: {
                    return FrameType.twoWord();
                }
            }
            throw new Unreachable("Unexpected MemberType: " + (Object)((Object)memberType));
        }

        public static FrameType fromNumericType(NumericType numericType, DexItemFactory factory) {
            return FrameType.initialized(numericType.dexTypeFor(factory));
        }

        abstract Object getTypeOpcode(GraphLens var1, NamingLens var2);

        public boolean isWide() {
            return false;
        }

        public boolean isUninitializedNew() {
            return false;
        }

        public CfLabel getUninitializedLabel() {
            return null;
        }

        public boolean isUninitializedThis() {
            return false;
        }

        public boolean isInitialized() {
            return false;
        }

        public DexType getInitializedType() {
            return null;
        }

        public DexType getUninitializedNewType() {
            return null;
        }

        public boolean isTop() {
            return false;
        }

        public boolean isOneWord() {
            return false;
        }

        public boolean isTwoWord() {
            return false;
        }

        FrameType map(Function<DexType, DexType> func) {
            DexType newType;
            DexType type;
            if (this.isInitialized() && (type = this.getInitializedType()) != (newType = func.apply(type))) {
                return FrameType.initialized(newType);
            }
            if (this.isUninitializedNew() && (type = this.getUninitializedNewType()) != (newType = func.apply(type))) {
                return FrameType.uninitializedNew(this.getUninitializedLabel(), newType);
            }
            return this;
        }
    }
}

