/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.Arrays;
import java.util.ListIterator;

public class CfInvoke
extends CfInstruction {
    private final DexMethod method;
    private final int opcode;
    private final boolean itf;

    private static void specify(StructuralSpecification<CfInvoke, ?> spec) {
        ((StructuralSpecification)spec.withBool(CfInvoke::isInterface)).withItem(CfInvoke::getMethod);
    }

    public CfInvoke(int opcode, DexMethod method, boolean itf) {
        assert (182 <= opcode && opcode <= 185);
        assert (opcode != 182 || !itf) : "InvokeVirtual on interface type";
        assert (opcode != 185 || itf) : "InvokeInterface on class type";
        this.opcode = opcode;
        this.method = method;
        this.itf = itf;
    }

    private Invoke.Type computeInvokeTypeForInvokeSpecial(AppView<?> appView, DexMethod method, ProgramMethod context, DexType originalHolder) {
        if (appView.dexItemFactory().isConstructor(method)) {
            return Invoke.Type.DIRECT;
        }
        if (originalHolder != method.getHolderType()) {
            return Invoke.Type.SUPER;
        }
        return this.invokeTypeForInvokeSpecialToNonInitMethodOnHolder(context, appView.graphLens());
    }

    private Invoke.Type invokeTypeForInvokeSpecialToNonInitMethodOnHolder(ProgramMethod context, GraphLens graphLens) {
        GraphLens.MethodLookupResult lookupResult = graphLens.lookupMethod(this.method, (DexMethod)context.getReference(), Invoke.Type.DIRECT);
        DexEncodedMethod definition = context.getHolder().lookupMethod((DexMethod)lookupResult.getReference());
        if (definition == null) {
            return Invoke.Type.SUPER;
        }
        if (context.getHolder().isInterface()) {
            if (definition.belongsToVirtualPool()) {
                return Invoke.Type.SUPER;
            }
        } else assert (definition.isPrivate() || lookupResult.getType().isVirtual());
        return Invoke.Type.DIRECT;
    }

    @Override
    public int getCompareToId() {
        return this.getOpcode();
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        CfInvoke otherInvoke = other.asInvoke();
        return visitor.visit(this, otherInvoke, CfInvoke::specify);
    }

    public DexMethod getMethod() {
        return this.method;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public boolean isInterface() {
        return this.itf;
    }

    @Override
    public CfInvoke asInvoke() {
        return this;
    }

    @Override
    public boolean isInvoke() {
        return true;
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        Invoke.Type invokeType = Invoke.Type.fromCfOpcode(this.opcode, this.method, context, appView);
        GraphLens.MethodLookupResult lookup = graphLens.lookupMethod(this.method, (DexMethod)context.getReference(), invokeType);
        DexMethod rewrittenMethod = (DexMethod)lookup.getReference();
        String owner = namingLens.lookupInternalName(rewrittenMethod.holder);
        String name = namingLens.lookupName(rewrittenMethod).toString();
        String desc = rewrittenMethod.proto.toDescriptorString(namingLens);
        visitor.visitMethodInsn(lookup.getType().getCfOpcode(), owner, name, desc, this.itf);
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    void internalRegisterUse(UseRegistry<?> registry, DexClassAndMethod context, ListIterator<CfInstruction> iterator2) {
        switch (this.opcode) {
            case 185: {
                registry.registerInvokeInterface(this.method);
                break;
            }
            case 183: {
                registry.registerInvokeSpecial(this.method, this.itf);
                break;
            }
            case 184: {
                registry.registerInvokeStatic(this.method, this.itf);
                break;
            }
            case 182: {
                registry.registerInvokeVirtual(this.method);
                break;
            }
            default: {
                throw new Unreachable("Unknown CfInvoke opcode " + this.opcode);
            }
        }
    }

    public boolean isInvokeConstructor(DexItemFactory dexItemFactory) {
        return this.getMethod().isInstanceInitializer(dexItemFactory);
    }

    @Deprecated
    public boolean isInvokeSuper(DexType clazz) {
        return this.opcode == 183 && this.method.holder != clazz && !this.method.name.toString().equals("<init>");
    }

    @Override
    public boolean isInvokeSpecial() {
        return this.opcode == 183;
    }

    @Override
    public boolean isInvokeStatic() {
        return this.opcode == 184;
    }

    @Override
    public boolean isInvokeVirtual() {
        return this.opcode == 182;
    }

    @Override
    public boolean isInvokeInterface() {
        return this.opcode == 185;
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        Invoke.Type type;
        DexMethod canonicalMethod;
        DexProto callSiteProto = null;
        switch (this.opcode) {
            case 185: {
                canonicalMethod = this.method;
                type = Invoke.Type.INTERFACE;
                break;
            }
            case 182: {
                canonicalMethod = builder.dexItemFactory().polymorphicMethods.canonicalize(this.method);
                if (canonicalMethod == null) {
                    type = Invoke.Type.VIRTUAL;
                    canonicalMethod = this.method;
                    break;
                }
                type = Invoke.Type.POLYMORPHIC;
                callSiteProto = this.method.proto;
                break;
            }
            case 183: {
                AppView<?> appView = builder.appView;
                ProgramMethod context = builder.getProgramMethod();
                canonicalMethod = this.method;
                type = Invoke.Type.fromInvokeSpecial(this.method, context, appView, builder.getCodeLens());
                break;
            }
            case 184: {
                canonicalMethod = this.method;
                type = Invoke.Type.STATIC;
                break;
            }
            default: {
                throw new Unreachable("unknown CfInvoke opcode " + this.opcode);
            }
        }
        int parameterCount = this.method.getParameters().size();
        if (type != Invoke.Type.STATIC) {
            ++parameterCount;
        }
        ValueType[] types = new ValueType[parameterCount];
        Integer[] registers = new Integer[parameterCount];
        for (int i = parameterCount - 1; i >= 0; --i) {
            CfState.Slot slot = state.pop();
            types[i] = slot.type;
            registers[i] = slot.register;
        }
        builder.addInvoke(type, canonicalMethod, callSiteProto, Arrays.asList(types), Arrays.asList(registers), this.itf);
        if (!this.method.getReturnType().isVoidType()) {
            builder.addMoveResult(state.push((DexType)this.method.getReturnType()).register);
        }
        assert (type == Invoke.Type.fromCfOpcode(this.opcode, this.method, builder.getProgramMethod(), builder.appView, builder.getCodeLens()));
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        Invoke.Type type;
        GraphLens graphLens = inliningConstraints.getGraphLens();
        AppView<AppInfoWithLiveness> appView = inliningConstraints.getAppView();
        DexMethod target = this.method;
        switch (this.opcode) {
            case 185: {
                type = graphLens.lookupMethod(target, (DexMethod)context.getReference(), Invoke.Type.INTERFACE).getType();
                assert (type == Invoke.Type.INTERFACE || type == Invoke.Type.VIRTUAL);
                break;
            }
            case 183: {
                Invoke.Type actualInvokeType = this.computeInvokeTypeForInvokeSpecial(appView, this.method, context, code.getOriginalHolder());
                type = graphLens.lookupMethod(target, (DexMethod)context.getReference(), actualInvokeType).getType();
                break;
            }
            case 184: {
                GraphLens.MethodLookupResult lookup = graphLens.lookupMethod(target, (DexMethod)context.getReference(), Invoke.Type.STATIC);
                target = (DexMethod)lookup.getReference();
                type = lookup.getType();
                break;
            }
            case 182: {
                DexClass clazz;
                type = Invoke.Type.VIRTUAL;
                if (target.holder == context.getHolderType() && (clazz = appView.definitionFor(target.holder)) != null && clazz.lookupDirectMethod(target) != null) {
                    type = Invoke.Type.DIRECT;
                }
                GraphLens.MethodLookupResult lookup = graphLens.lookupMethod(target, (DexMethod)context.getReference(), type);
                target = (DexMethod)lookup.getReference();
                type = lookup.getType();
                break;
            }
            default: {
                throw new Unreachable("Unexpected opcode " + this.opcode);
            }
        }
        return inliningConstraints.forInvoke(target, type, context);
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
        frameBuilder.popAndDiscardInitialized(this.method.proto.parameters.values);
        if (this.opcode == 183 && (this.method.isInstanceInitializer(dexItemFactory) || this.method.mustBeInlinedIntoInstanceInitializer(appView))) {
            frameBuilder.popAndInitialize(context.getHolderType(), this.method.holder);
        } else if (this.opcode != 184) {
            frameBuilder.popInitialized(this.method.holder);
        }
        if (!this.method.getReturnType().isVoidType()) {
            frameBuilder.push(this.method.getReturnType());
        }
    }
}

