/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.utils.structural.CompareToVisitor;

public class CfLoad
extends CfInstruction {
    private final int var;
    private final ValueType type;

    public CfLoad(ValueType type, int var) {
        this.var = var;
        this.type = type;
    }

    private int getLoadType() {
        switch (this.type) {
            case OBJECT: {
                return 25;
            }
            case INT: {
                return 21;
            }
            case FLOAT: {
                return 23;
            }
            case LONG: {
                return 22;
            }
            case DOUBLE: {
                return 24;
            }
        }
        throw new Unreachable("Unexpected type " + this.type);
    }

    @Override
    public int getCompareToId() {
        return this.getLoadType();
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        return visitor.visitInt(this.var, other.asLoad().var);
    }

    @Override
    public CfLoad asLoad() {
        return this;
    }

    @Override
    public boolean isLoad() {
        return true;
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        visitor.visitVarInsn(this.getLoadType(), this.var);
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    public ValueType getType() {
        return this.type;
    }

    public int getLocalIndex() {
        return this.var;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        CfState.Slot local = state.read(this.var);
        CfState.Slot stack = state.push(local);
        builder.addMove(local.type, stack.register, local.register);
    }

    @Override
    public boolean emitsIR() {
        return false;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        return inliningConstraints.forLoad();
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
        frameBuilder.push(frameBuilder.readLocal(this.getLocalIndex(), this.type.isObject() ? dexItemFactory.objectType : this.type.toPrimitiveType().toDexType(dexItemFactory)));
    }
}

