/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.utils.structural.CompareToVisitor;

public class CfLogicalBinop
extends CfInstruction {
    private final Opcode opcode;
    private final NumericType type;

    public CfLogicalBinop(Opcode opcode, NumericType type) {
        assert (opcode != null);
        assert (type != null);
        assert (type != NumericType.FLOAT && type != NumericType.DOUBLE);
        this.opcode = opcode;
        this.type = type;
    }

    public static CfLogicalBinop fromAsm(int opcode) {
        switch (opcode) {
            case 120: {
                return new CfLogicalBinop(Opcode.Shl, NumericType.INT);
            }
            case 121: {
                return new CfLogicalBinop(Opcode.Shl, NumericType.LONG);
            }
            case 122: {
                return new CfLogicalBinop(Opcode.Shr, NumericType.INT);
            }
            case 123: {
                return new CfLogicalBinop(Opcode.Shr, NumericType.LONG);
            }
            case 124: {
                return new CfLogicalBinop(Opcode.Ushr, NumericType.INT);
            }
            case 125: {
                return new CfLogicalBinop(Opcode.Ushr, NumericType.LONG);
            }
            case 126: {
                return new CfLogicalBinop(Opcode.And, NumericType.INT);
            }
            case 127: {
                return new CfLogicalBinop(Opcode.And, NumericType.LONG);
            }
            case 128: {
                return new CfLogicalBinop(Opcode.Or, NumericType.INT);
            }
            case 129: {
                return new CfLogicalBinop(Opcode.Or, NumericType.LONG);
            }
            case 130: {
                return new CfLogicalBinop(Opcode.Xor, NumericType.INT);
            }
            case 131: {
                return new CfLogicalBinop(Opcode.Xor, NumericType.LONG);
            }
        }
        throw new Unreachable("Wrong ASM opcode for CfLogicalBinop " + opcode);
    }

    @Override
    public int getCompareToId() {
        return this.getAsmOpcode();
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        return CfCompareHelper.compareIdUniquelyDeterminesEquality(this, other);
    }

    public NumericType getType() {
        return this.type;
    }

    public Opcode getOpcode() {
        return this.opcode;
    }

    public int getAsmOpcode() {
        switch (this.opcode) {
            case Shl: {
                return this.type.isWide() ? 121 : 120;
            }
            case Shr: {
                return this.type.isWide() ? 123 : 122;
            }
            case Ushr: {
                return this.type.isWide() ? 125 : 124;
            }
            case And: {
                return this.type.isWide() ? 127 : 126;
            }
            case Or: {
                return this.type.isWide() ? 129 : 128;
            }
            case Xor: {
                return this.type.isWide() ? 131 : 130;
            }
        }
        throw new Unreachable("CfLogicalBinop has unknown opcode " + (Object)((Object)this.opcode));
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        visitor.visitInsn(this.getAsmOpcode());
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        int right = state.pop().register;
        int left = state.pop().register;
        int dest = state.push((ValueType)ValueType.fromNumericType((NumericType)this.type)).register;
        switch (this.opcode) {
            case Shl: {
                builder.addShl(this.type, dest, left, right);
                break;
            }
            case Shr: {
                builder.addShr(this.type, dest, left, right);
                break;
            }
            case Ushr: {
                builder.addUshr(this.type, dest, left, right);
                break;
            }
            case And: {
                builder.addAnd(this.type, dest, left, right);
                break;
            }
            case Or: {
                builder.addOr(this.type, dest, left, right);
                break;
            }
            case Xor: {
                builder.addXor(this.type, dest, left, right);
                break;
            }
            default: {
                throw new Unreachable("CfLogicalBinop has unknown opcode " + (Object)((Object)this.opcode));
            }
        }
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        return inliningConstraints.forBinop();
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
        CfFrame.FrameType value2Type;
        CfFrame.FrameType value1Type = CfFrame.FrameType.fromNumericType(this.type, dexItemFactory);
        switch (this.opcode) {
            case And: 
            case Or: 
            case Xor: {
                value2Type = value1Type;
                break;
            }
            default: {
                value2Type = CfFrame.FrameType.initialized(dexItemFactory.intType);
            }
        }
        frameBuilder.popAndDiscard(value1Type, value2Type).push(value1Type);
    }

    public static enum Opcode {
        Shl,
        Shr,
        Ushr,
        And,
        Or,
        Xor;

    }
}

