/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfTypeInstruction;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.ListIterator;

public class CfMultiANewArray
extends CfInstruction
implements CfTypeInstruction {
    private final DexType type;
    private final int dimensions;

    private static void specify(StructuralSpecification<CfMultiANewArray, ?> spec) {
        ((StructuralSpecification)spec.withInt(CfMultiANewArray::getDimensions)).withItem(CfMultiANewArray::getType);
    }

    public CfMultiANewArray(DexType type, int dimensions) {
        this.type = type;
        this.dimensions = dimensions;
    }

    @Override
    public CfTypeInstruction asTypeInstruction() {
        return this;
    }

    @Override
    public boolean isTypeInstruction() {
        return true;
    }

    @Override
    public DexType getType() {
        return this.type;
    }

    @Override
    public CfInstruction withType(DexType newType) {
        return new CfMultiANewArray(newType, this.dimensions);
    }

    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public int getCompareToId() {
        return 197;
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        return visitor.visit(this, (CfMultiANewArray)other, CfMultiANewArray::specify);
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        DexType rewrittenType = graphLens.lookupType(this.getType());
        visitor.visitMultiANewArrayInsn(namingLens.lookupInternalName(rewrittenType), this.dimensions);
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    void internalRegisterUse(UseRegistry<?> registry, DexClassAndMethod context, ListIterator<CfInstruction> iterator2) {
        registry.registerTypeReference(this.type);
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        InternalOptions options = builder.appView.options();
        assert (!options.isGeneratingDex());
        int[] dimensions = state.popReverse(this.dimensions);
        builder.addMultiNewArray(this.type, state.push((DexType)this.type).register, dimensions);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        return inliningConstraints.forInvokeMultiNewArray(this.type, context);
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
        for (int i = 0; i < this.dimensions; ++i) {
            frameBuilder.popInitialized(dexItemFactory.intType);
        }
        frameBuilder.push(this.type);
    }
}

