/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.utils.structural.CompareToVisitor;

public class CfStackInstruction
extends CfInstruction {
    private final Opcode opcode;

    public static CfStackInstruction fromAsm(int opcode) {
        switch (opcode) {
            case 87: {
                return new CfStackInstruction(Opcode.Pop);
            }
            case 88: {
                return new CfStackInstruction(Opcode.Pop2);
            }
            case 89: {
                return new CfStackInstruction(Opcode.Dup);
            }
            case 90: {
                return new CfStackInstruction(Opcode.DupX1);
            }
            case 91: {
                return new CfStackInstruction(Opcode.DupX2);
            }
            case 92: {
                return new CfStackInstruction(Opcode.Dup2);
            }
            case 93: {
                return new CfStackInstruction(Opcode.Dup2X1);
            }
            case 94: {
                return new CfStackInstruction(Opcode.Dup2X2);
            }
            case 95: {
                return new CfStackInstruction(Opcode.Swap);
            }
        }
        throw new Unreachable("Invalid opcode for CfStackInstruction");
    }

    public static CfStackInstruction popType(ValueType type) {
        return new CfStackInstruction(type.isWide() ? Opcode.Pop2 : Opcode.Pop);
    }

    public CfStackInstruction(Opcode opcode) {
        this.opcode = opcode;
    }

    private void dup1x1(IRBuilder builder, CfState state, CfState.Slot inValue1, CfState.Slot inValue2) {
        CfState.Slot outValue1 = state.push(inValue1);
        CfState.Slot outValue2 = state.push(inValue2);
        CfState.Slot outValue1Copy = state.push(inValue1);
        builder.addMove(inValue1.type, outValue1Copy.register, inValue1.register);
        builder.addMove(inValue2.type, outValue2.register, inValue2.register);
        builder.addMove(outValue1Copy.type, outValue1.register, outValue1Copy.register);
    }

    private void dup1x2(IRBuilder builder, CfState state, CfState.Slot inValue1, CfState.Slot inValue2, CfState.Slot inValue3) {
        CfState.Slot outValue1 = state.push(inValue1);
        CfState.Slot outValue3 = state.push(inValue3);
        CfState.Slot outValue2 = state.push(inValue2);
        CfState.Slot outValue1Copy = state.push(inValue1);
        builder.addMove(inValue1.type, outValue1Copy.register, inValue1.register);
        builder.addMove(inValue2.type, outValue2.register, inValue2.register);
        builder.addMove(inValue3.type, outValue3.register, inValue3.register);
        builder.addMove(outValue1Copy.type, outValue1.register, outValue1Copy.register);
    }

    private void dup2x1(IRBuilder builder, CfState state, CfState.Slot inValue1, CfState.Slot inValue2, CfState.Slot inValue3) {
        CfState.Slot outValue2 = state.push(inValue2);
        CfState.Slot outValue1 = state.push(inValue1);
        CfState.Slot outValue3 = state.push(inValue3);
        CfState.Slot outValue2Copy = state.push(inValue2);
        CfState.Slot outValue1Copy = state.push(inValue1);
        builder.addMove(inValue1.type, outValue1Copy.register, inValue1.register);
        builder.addMove(inValue2.type, outValue2Copy.register, inValue2.register);
        builder.addMove(inValue3.type, outValue3.register, inValue3.register);
        builder.addMove(inValue1.type, outValue1.register, outValue1Copy.register);
        builder.addMove(inValue2.type, outValue2.register, outValue2Copy.register);
    }

    private void dup2x2(IRBuilder builder, CfState state, CfState.Slot inValue1, CfState.Slot inValue2, CfState.Slot inValue3, CfState.Slot inValue4) {
        CfState.Slot outValue2 = state.push(inValue2);
        CfState.Slot outValue1 = state.push(inValue1);
        CfState.Slot outValue4 = state.push(inValue4);
        CfState.Slot outValue3 = state.push(inValue3);
        CfState.Slot outValue2Copy = state.push(inValue2);
        CfState.Slot outValue1Copy = state.push(inValue1);
        builder.addMove(inValue1.type, outValue1Copy.register, inValue1.register);
        builder.addMove(inValue2.type, outValue2Copy.register, inValue2.register);
        builder.addMove(inValue3.type, outValue3.register, inValue3.register);
        builder.addMove(inValue4.type, outValue4.register, inValue4.register);
        builder.addMove(outValue1Copy.type, outValue1.register, outValue1Copy.register);
        builder.addMove(outValue2Copy.type, outValue2.register, outValue2Copy.register);
    }

    @Override
    public int getCompareToId() {
        return this.opcode.opcode;
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        return CfCompareHelper.compareIdUniquelyDeterminesEquality(this, other);
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        visitor.visitInsn(this.opcode.opcode);
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    public Opcode getOpcode() {
        return this.opcode;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        switch (this.opcode) {
            case Pop: {
                CfState.Slot pop = state.pop();
                assert (!pop.type.isWide());
                break;
            }
            case Pop2: {
                CfState.Slot pop1 = state.pop();
                if (pop1.type.isWide()) break;
                CfState.Slot pop2 = state.pop();
                assert (!pop2.type.isWide());
                break;
            }
            case Dup: {
                CfState.Slot dupValue = state.peek();
                assert (!dupValue.type.isWide());
                builder.addMove(dupValue.type, state.push((CfState.Slot)dupValue).register, dupValue.register);
                break;
            }
            case DupX1: {
                CfState.Slot value1 = state.pop();
                CfState.Slot value2 = state.pop();
                assert (!value1.type.isWide());
                assert (!value2.type.isWide());
                this.dup1x1(builder, state, value1, value2);
                break;
            }
            case DupX2: {
                CfState.Slot value1 = state.pop();
                CfState.Slot value2 = state.pop();
                assert (!value1.type.isWide());
                if (value2.type.isWide()) {
                    this.dup1x1(builder, state, value1, value2);
                    break;
                }
                CfState.Slot value3 = state.pop();
                assert (!value3.type.isWide());
                this.dup1x2(builder, state, value1, value2, value3);
                break;
            }
            case Dup2: {
                CfState.Slot value1 = state.peek();
                if (value1.type.isWide()) {
                    builder.addMove(value1.type, state.push((CfState.Slot)value1).register, value1.register);
                    break;
                }
                CfState.Slot value2 = state.peek(1);
                builder.addMove(value2.type, state.push((CfState.Slot)value2).register, value2.register);
                builder.addMove(value1.type, state.push((CfState.Slot)value1).register, value1.register);
                break;
            }
            case Dup2X1: {
                CfState.Slot value1 = state.pop();
                CfState.Slot value2 = state.pop();
                assert (!value2.type.isWide());
                if (value1.type.isWide()) {
                    this.dup1x1(builder, state, value1, value2);
                    break;
                }
                CfState.Slot value3 = state.pop();
                assert (!value3.type.isWide());
                this.dup2x1(builder, state, value1, value2, value3);
                break;
            }
            case Dup2X2: {
                CfState.Slot value1 = state.pop();
                CfState.Slot value2 = state.pop();
                if (value1.type.isWide() && value2.type.isWide()) {
                    this.dup1x1(builder, state, value1, value2);
                    break;
                }
                CfState.Slot value3 = state.pop();
                if (value1.type.isWide()) {
                    if (value3.type.isWide()) {
                        throw new CompilationError("Invalid dup2x2 with types: wide, single, wide");
                    }
                    this.dup1x2(builder, state, value1, value2, value3);
                    break;
                }
                if (value2.type.isWide()) {
                    throw new CompilationError("Invalid dup2x2 with types: ..., wide, single");
                }
                if (value3.type.isWide()) {
                    this.dup2x1(builder, state, value1, value2, value3);
                    break;
                }
                CfState.Slot value4 = state.pop();
                if (value4.type.isWide()) {
                    throw new CompilationError("Invalid dup2x2 with types: wide, single, single, single");
                }
                this.dup2x2(builder, state, value1, value2, value3, value4);
                break;
            }
            case Swap: {
                CfState.Slot value1 = state.pop();
                CfState.Slot value2 = state.pop();
                assert (!value1.type.isWide());
                assert (!value2.type.isWide());
                this.dup1x1(builder, state, value1, value2);
                state.pop();
                break;
            }
        }
    }

    @Override
    public boolean emitsIR() {
        return false;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
        switch (this.opcode) {
            case Pop: {
                frameBuilder.pop(CfFrame.FrameType.oneWord());
                return;
            }
            case Pop2: {
                CfFrame.FrameType pop = frameBuilder.pop();
                if (!pop.isWide()) {
                    frameBuilder.checkIsAssignable(pop, CfFrame.FrameType.oneWord());
                    frameBuilder.pop(CfFrame.FrameType.oneWord());
                }
                return;
            }
            case Dup: {
                CfFrame.FrameType topValue = frameBuilder.pop(CfFrame.FrameType.oneWord());
                frameBuilder.push(topValue).push(topValue);
                return;
            }
            case DupX1: {
                CfFrame.FrameType value1 = frameBuilder.pop(CfFrame.FrameType.oneWord());
                CfFrame.FrameType value2 = frameBuilder.pop(CfFrame.FrameType.oneWord());
                frameBuilder.push(value1).push(value2).push(value1);
                return;
            }
            case DupX2: {
                CfFrame.FrameType value1 = frameBuilder.pop(CfFrame.FrameType.oneWord());
                CfFrame.FrameType value2 = frameBuilder.pop();
                if (!value2.isWide()) {
                    frameBuilder.checkIsAssignable(value2, CfFrame.FrameType.oneWord());
                    CfFrame.FrameType value3 = frameBuilder.pop(CfFrame.FrameType.oneWord());
                    frameBuilder.push(value1).push(value3);
                } else {
                    frameBuilder.push(value1);
                }
                frameBuilder.push(value2).push(value1);
                return;
            }
            case Dup2: {
                CfFrame.FrameType value1 = frameBuilder.pop();
                if (!value1.isWide()) {
                    frameBuilder.checkIsAssignable(value1, CfFrame.FrameType.oneWord());
                    CfFrame.FrameType value2 = frameBuilder.pop(CfFrame.FrameType.oneWord());
                    frameBuilder.push(value2).push(value1).push(value2);
                } else {
                    frameBuilder.push(value1);
                }
                frameBuilder.push(value1);
                return;
            }
            case Dup2X1: {
                CfFrame.FrameType value1 = frameBuilder.pop();
                CfFrame.FrameType value2 = frameBuilder.pop(CfFrame.FrameType.oneWord());
                if (!value1.isWide()) {
                    frameBuilder.checkIsAssignable(value1, CfFrame.FrameType.oneWord());
                    CfFrame.FrameType value3 = frameBuilder.pop(CfFrame.FrameType.oneWord());
                    frameBuilder.push(value2).push(value1).push(value3);
                } else {
                    frameBuilder.push(value1);
                }
                frameBuilder.push(value2);
                frameBuilder.push(value1);
                return;
            }
            case Dup2X2: {
                CfFrame.FrameType value1 = frameBuilder.pop();
                CfFrame.FrameType value2 = frameBuilder.pop();
                if (!value1.isWide()) {
                    CfFrame.FrameType value3 = frameBuilder.pop();
                    if (!value3.isWide()) {
                        frameBuilder.checkIsAssignable(value1, CfFrame.FrameType.oneWord());
                        frameBuilder.checkIsAssignable(value2, CfFrame.FrameType.oneWord());
                        frameBuilder.checkIsAssignable(value3, CfFrame.FrameType.oneWord());
                        CfFrame.FrameType value4 = frameBuilder.pop(CfFrame.FrameType.oneWord());
                        frameBuilder.push(value2).push(value1).push(value4).push(value3).push(value2).push(value1);
                    } else {
                        frameBuilder.checkIsAssignable(value1, CfFrame.FrameType.oneWord());
                        frameBuilder.checkIsAssignable(value2, CfFrame.FrameType.oneWord());
                        frameBuilder.push(value2).push(value1).push(value3).push(value2).push(value1);
                    }
                } else if (!value2.isWide()) {
                    frameBuilder.checkIsAssignable(value2, CfFrame.FrameType.oneWord());
                    CfFrame.FrameType value3 = frameBuilder.pop(CfFrame.FrameType.oneWord());
                    frameBuilder.push(value1).push(value3).push(value2).push(value1);
                } else {
                    assert (value2.isWide());
                    frameBuilder.push(value1).push(value2).push(value1);
                }
                return;
            }
            case Swap: {
                CfFrame.FrameType value1 = frameBuilder.pop(CfFrame.FrameType.oneWord());
                CfFrame.FrameType value2 = frameBuilder.pop(CfFrame.FrameType.oneWord());
                frameBuilder.push(value1).push(value2);
                return;
            }
        }
        throw new Unreachable("Invalid opcode for CfStackInstruction");
    }

    public static enum Opcode {
        Pop(87),
        Pop2(88),
        Dup(89),
        DupX1(90),
        DupX2(91),
        Dup2(92),
        Dup2X1(93),
        Dup2X2(94),
        Swap(95);

        private final int opcode;

        private Opcode(int opcode) {
            this.opcode = opcode;
        }
    }
}

