/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.Label;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.List;

public class CfSwitch
extends CfInstruction {
    private final Kind kind;
    private final CfLabel defaultTarget;
    private final int[] keys;
    private final List<CfLabel> targets;

    public CfSwitch(Kind kind, CfLabel defaultTarget, int[] keys2, List<CfLabel> targets) {
        this.kind = kind;
        this.defaultTarget = defaultTarget;
        this.keys = keys2;
        this.targets = targets;
        assert (kind != Kind.LOOKUP || keys2.length == targets.size());
        assert (kind != Kind.TABLE || keys2.length == 1);
    }

    @Override
    public int getCompareToId() {
        return this.kind == Kind.LOOKUP ? 171 : 170;
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        assert (this.kind == ((CfSwitch)other).kind);
        return visitor.visit(this, (CfSwitch)other, spec -> ((StructuralSpecification)((StructuralSpecification)spec.withCustomItem(CfSwitch::getDefaultTarget, helper.labelAcceptor())).withIntArray(i -> i.keys)).withCustomItemCollection(CfSwitch::getSwitchTargets, helper.labelAcceptor()));
    }

    public Kind getKind() {
        return this.kind;
    }

    public CfLabel getDefaultTarget() {
        return this.defaultTarget;
    }

    public List<Integer> getKeys() {
        return new IntArrayList(this.keys);
    }

    public List<CfLabel> getSwitchTargets() {
        return this.targets;
    }

    @Override
    public CfSwitch asSwitch() {
        return this;
    }

    @Override
    public boolean isSwitch() {
        return true;
    }

    @Override
    public boolean isJump() {
        return true;
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        Label[] labels = new Label[this.targets.size()];
        for (int i = 0; i < this.targets.size(); ++i) {
            labels[i] = this.targets.get(i).getLabel();
        }
        switch (this.kind) {
            case LOOKUP: {
                visitor.visitLookupSwitchInsn(this.defaultTarget.getLabel(), this.keys, labels);
                break;
            }
            case TABLE: {
                int min2 = this.keys[0];
                int max = min2 + this.targets.size() - 1;
                visitor.visitTableSwitchInsn(min2, max, this.defaultTarget.getLabel(), labels);
            }
        }
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        int[] labelOffsets = new int[this.targets.size()];
        for (int i = 0; i < this.targets.size(); ++i) {
            labelOffsets[i] = code.getLabelOffset(this.targets.get(i));
        }
        CfState.Slot value = state.pop();
        builder.addSwitch(value.register, this.keys, code.getLabelOffset(this.defaultTarget), labelOffsets);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        return inliningConstraints.forJumpInstruction();
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
        frameBuilder.popInitialized(dexItemFactory.intType);
        frameBuilder.checkTarget(this.defaultTarget);
        for (CfLabel target : this.targets) {
            frameBuilder.checkTarget(target);
        }
        frameBuilder.setNoFrame();
    }

    public static enum Kind {
        LOOKUP,
        TABLE;

    }
}

