/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Format21h;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.WideConstant;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.StringUtils;

public class ConstWideHigh16
extends Format21h
implements WideConstant {
    public static final int OPCODE = 25;
    public static final String NAME = "ConstWideHigh16";
    public static final String SMALI_NAME = "const-wide/high16";

    ConstWideHigh16(int high, BytecodeStream stream) {
        super(high, stream);
    }

    public ConstWideHigh16(int dest, int constantHighBits) {
        super(dest, constantHighBits);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getSmaliName() {
        return SMALI_NAME;
    }

    @Override
    public int getOpcode() {
        return 25;
    }

    @Override
    public long decodedValue() {
        return (long)this.BBBB << 48;
    }

    @Override
    public String toString(ClassNameMapper naming) {
        return this.formatString("v" + this.AA + ", " + StringUtils.hexString(this.decodedValue(), 16) + " (" + this.decodedValue() + ")");
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        return this.formatSmaliString("v" + this.AA + ", " + StringUtils.hexString(this.decodedValue(), 16) + "L  # " + this.decodedValue());
    }

    @Override
    public void buildIR(IRBuilder builder) {
        builder.addConst(TypeElement.getWide(), this.AA, this.decodedValue());
    }
}

