/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.Base2Format;
import com.android.tools.r8.code.DexCompareHelper;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.FieldMemberType;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.nio.ShortBuffer;

public class DexInitClass
extends Base2Format {
    public static final int OPCODE = 96;
    public static final String NAME = "InitClass";
    public static final String SMALI_NAME = "initclass";
    private final int dest;
    private final DexType clazz;

    private static void specify(StructuralSpecification<DexInitClass, ?> spec) {
        ((StructuralSpecification)spec.withInt(i -> i.dest)).withItem(i -> i.clazz);
    }

    public DexInitClass(int dest, DexType clazz) {
        assert (clazz.isClassType());
        this.dest = dest;
        this.clazz = clazz;
    }

    private int getOpcode(DexField field) {
        FieldMemberType type = FieldMemberType.fromDexType(field.type);
        switch (type) {
            case INT: 
            case FLOAT: {
                return 96;
            }
            case LONG: 
            case DOUBLE: {
                return 97;
            }
            case OBJECT: {
                return 98;
            }
            case BOOLEAN: {
                return 99;
            }
            case BYTE: {
                return 100;
            }
            case CHAR: {
                return 101;
            }
            case SHORT: {
                return 102;
            }
        }
        throw new Unreachable("Unexpected type: " + (Object)((Object)type));
    }

    @Override
    public void buildIR(IRBuilder builder) {
        builder.addInitClass(this.dest, this.clazz);
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, ProgramMethod context, GraphLens graphLens, LensCodeRewriterUtils rewriter) {
        DexType rewrittenClass = graphLens.lookupType(this.clazz);
        DexField clinitField = indexedItems.getInitClassLens().getInitClassField(rewrittenClass);
        clinitField.collectIndexedItems(indexedItems);
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getSmaliName() {
        return SMALI_NAME;
    }

    @Override
    public int getOpcode() {
        throw new Unreachable();
    }

    @Override
    int getCompareToId() {
        return DexCompareHelper.INIT_CLASS_COMPARE_ID;
    }

    @Override
    public void registerUse(UseRegistry<?> registry) {
        registry.registerInitClass(this.clazz);
    }

    @Override
    public void write(ShortBuffer buffer, ProgramMethod context, GraphLens graphLens, ObjectToOffsetMapping mapping, LensCodeRewriterUtils rewriter) {
        DexType rewrittenClass = graphLens.lookupType(this.clazz);
        DexField clinitField = mapping.getClinitField(rewrittenClass);
        this.writeFirst(this.dest, buffer, this.getOpcode(clinitField));
        this.write16BitReference(clinitField, buffer, mapping);
    }

    @Override
    public int hashCode() {
        return (this.clazz.hashCode() << 8 | this.dest) ^ this.getClass().hashCode();
    }

    @Override
    final int internalAcceptCompareTo(Instruction other, CompareToVisitor visitor) {
        return visitor.visit(this, (DexInitClass)other, DexInitClass::specify);
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        return this.formatSmaliString("v" + this.dest + ", " + this.clazz.toSmaliString());
    }

    @Override
    public String toString(ClassNameMapper naming) {
        StringBuilder builder = new StringBuilder("v").append(this.dest).append(", ");
        if (naming == null) {
            builder.append(this.clazz.toSourceString());
        } else {
            builder.append(naming.originalNameOf(this.clazz));
        }
        return this.formatString(builder.toString());
    }
}

