/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.Base2Format;
import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.ValueTypeConstraint;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.nio.ShortBuffer;

public abstract class Format21t
extends Base2Format {
    public final short AA;
    public short BBBB;

    private static void specify(StructuralSpecification<Format21t, ?> spec) {
        ((StructuralSpecification)spec.withInt(i -> i.AA)).withInt(i -> i.BBBB);
    }

    Format21t(int high, BytecodeStream stream) {
        super(stream);
        this.AA = (short)high;
        this.BBBB = Format21t.readSigned16BitValue(stream);
    }

    Format21t(int register, int offset) {
        assert (Short.MIN_VALUE <= offset && offset <= Short.MAX_VALUE);
        assert (0 <= register && register <= 255);
        this.AA = (short)register;
        this.BBBB = (short)offset;
    }

    @Override
    public void write(ShortBuffer dest, ProgramMethod context, GraphLens graphLens, ObjectToOffsetMapping mapping, LensCodeRewriterUtils rewriter) {
        this.writeFirst(this.AA, dest);
        this.write16BitValue(this.BBBB, dest);
    }

    @Override
    public final int hashCode() {
        return (this.BBBB << 8 | this.AA) ^ this.getClass().hashCode();
    }

    @Override
    final int internalAcceptCompareTo(Instruction other, CompareToVisitor visitor) {
        return visitor.visit(this, (Format21t)other, Format21t::specify);
    }

    public abstract If.Type getType();

    protected abstract ValueTypeConstraint getOperandTypeConstraint();

    @Override
    public int[] getTargets() {
        return new int[]{this.BBBB, this.getSize()};
    }

    @Override
    public void buildIR(IRBuilder builder) {
        int offset = this.getOffset();
        int size = this.getSize();
        builder.addIfZero(this.getType(), this.getOperandTypeConstraint(), (int)this.AA, offset + this.BBBB, offset + size);
    }

    @Override
    public String toString(ClassNameMapper naming) {
        return this.formatString("v" + this.AA + ", " + this.formatRelativeOffset(this.BBBB));
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        return this.formatSmaliString("v" + this.AA + ", :label_" + (this.getOffset() + this.BBBB));
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, ProgramMethod context, GraphLens graphLens, LensCodeRewriterUtils rewriter) {
    }
}

