/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.graph.CachedHashValueDexItem;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.function.BiPredicate;

public abstract class Format35c<T extends IndexedDexItem>
extends Base3Format {
    public final byte A;
    public final byte C;
    public final byte D;
    public final byte E;
    public final byte F;
    public final byte G;
    public T BBBB;

    private static <T extends IndexedDexItem> void specify(StructuralSpecification<Format35c<T>, ?> spec) {
        ((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)spec.withInt(i -> i.A)).withInt(i -> i.C)).withInt(i -> i.D)).withInt(i -> i.E)).withInt(i -> i.F)).withInt(i -> i.G)).withItem(i -> i.BBBB);
    }

    Format35c(int high, BytecodeStream stream, T[] map) {
        super(stream);
        this.G = (byte)(high & 0xF);
        this.A = (byte)(high >> 4 & 0xF);
        this.BBBB = map[Format35c.read16BitValue(stream)];
        short next = Format35c.read8BitValue(stream);
        this.E = (byte)(next & 0xF);
        this.F = (byte)(next >> 4 & 0xF);
        next = Format35c.read8BitValue(stream);
        this.C = (byte)(next & 0xF);
        this.D = (byte)(next >> 4 & 0xF);
    }

    Format35c(int A2, T BBBB, int C2, int D, int E, int F, int G) {
        assert (0 <= A2 && A2 <= 15);
        assert (0 <= C2 && C2 <= 15);
        assert (0 <= D && D <= 15);
        assert (0 <= E && E <= 15);
        assert (0 <= F && F <= 15);
        assert (0 <= G && G <= 15);
        this.A = (byte)A2;
        this.BBBB = BBBB;
        this.C = (byte)C2;
        this.D = (byte)D;
        this.E = (byte)E;
        this.F = (byte)F;
        this.G = (byte)G;
    }

    private void appendRegisterArguments(StringBuilder builder, String separator) {
        builder.append("{ ");
        int[] values2 = new int[]{this.C, this.D, this.E, this.F, this.G};
        for (int i = 0; i < this.A; ++i) {
            if (i != 0) {
                builder.append(separator);
            }
            builder.append("v").append(values2[i]);
        }
        builder.append(" }");
    }

    @Override
    public final int hashCode() {
        return (((CachedHashValueDexItem)this.BBBB).hashCode() << 24 | this.A << 20 | this.C << 16 | this.D << 12 | this.E << 8 | this.F << 4 | this.G) ^ this.getClass().hashCode();
    }

    @Override
    final int internalAcceptCompareTo(Instruction other, CompareToVisitor visitor) {
        return visitor.visit(this, (Format35c)other, Format35c::specify);
    }

    @Override
    public String toString(ClassNameMapper naming) {
        StringBuilder builder = new StringBuilder();
        this.appendRegisterArguments(builder, " ");
        builder.append(" ");
        if (naming == null) {
            builder.append(((DexItem)this.BBBB).toSmaliString());
        } else {
            builder.append(naming.originalNameOf((IndexedDexItem)this.BBBB));
        }
        return this.formatString(builder.toString());
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        StringBuilder builder = new StringBuilder();
        this.appendRegisterArguments(builder, ", ");
        builder.append(", ");
        builder.append(((DexItem)this.BBBB).toSmaliString());
        return this.formatSmaliString(builder.toString());
    }

    @Override
    public boolean equals(Instruction other, BiPredicate<IndexedDexItem, IndexedDexItem> equality) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Format35c o = (Format35c)other;
        return o.A == this.A && o.C == this.C && o.D == this.D && o.E == this.E && o.F == this.F && o.G == this.G && equality.test((IndexedDexItem)this.BBBB, (IndexedDexItem)o.BBBB);
    }
}

