/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.graph.CachedHashValueDexItem;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.function.BiPredicate;

public abstract class Format3rc<T extends IndexedDexItem>
extends Base3Format {
    public final short AA;
    public final char CCCC;
    public T BBBB;

    private static <T extends IndexedDexItem> void specify(StructuralSpecification<Format3rc<T>, ?> spec) {
        ((StructuralSpecification)((StructuralSpecification)spec.withInt(i -> i.AA)).withInt(i -> i.CCCC)).withItem(i -> i.BBBB);
    }

    Format3rc(int high, BytecodeStream stream, T[] map) {
        super(stream);
        this.AA = (short)high;
        this.BBBB = map[Format3rc.read16BitValue(stream)];
        this.CCCC = Format3rc.read16BitValue(stream);
    }

    Format3rc(int firstArgumentRegister, int argumentCount, T dexItem) {
        assert (0 <= firstArgumentRegister && firstArgumentRegister <= 65535);
        assert (0 <= argumentCount && argumentCount <= 255);
        this.CCCC = (char)firstArgumentRegister;
        this.AA = (short)argumentCount;
        this.BBBB = dexItem;
    }

    private void appendRegisterRange(StringBuilder builder) {
        char firstRegister = this.CCCC;
        builder.append("{ ");
        builder.append("v").append((int)firstRegister);
        if (this.AA != 1) {
            builder.append(" .. v").append(firstRegister + this.AA - 1);
        }
        builder.append(" }");
    }

    public T getItem() {
        return this.BBBB;
    }

    @Override
    public final int hashCode() {
        return (this.CCCC << 24 | ((CachedHashValueDexItem)this.BBBB).hashCode() << 4 | this.AA) ^ this.getClass().hashCode();
    }

    @Override
    final int internalAcceptCompareTo(Instruction other, CompareToVisitor visitor) {
        return visitor.visit(this, (Format3rc)other, Format3rc::specify);
    }

    @Override
    public String toString(ClassNameMapper naming) {
        StringBuilder builder = new StringBuilder();
        this.appendRegisterRange(builder);
        builder.append(" ");
        if (naming == null) {
            builder.append(((DexItem)this.BBBB).toSmaliString());
        } else {
            builder.append(naming.originalNameOf((IndexedDexItem)this.BBBB));
        }
        return this.formatString(builder.toString());
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        StringBuilder builder = new StringBuilder();
        this.appendRegisterRange(builder);
        builder.append(", ");
        builder.append(((DexItem)this.BBBB).toSmaliString());
        return this.formatSmaliString(builder.toString());
    }

    @Override
    public boolean equals(Instruction other, BiPredicate<IndexedDexItem, IndexedDexItem> equality) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Format3rc o = (Format3rc)other;
        return o.AA == this.AA && o.CCCC == this.CCCC && equality.test((IndexedDexItem)this.BBBB, (IndexedDexItem)o.BBBB);
    }
}

