/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.com.google.common.collect;

import com.android.tools.r8.com.google.common.annotations.GwtCompatible;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.List;

@GwtCompatible(serializable=true)
final class ExplicitOrdering<T>
extends Ordering<T>
implements Serializable {
    private static final long serialVersionUID = 0L;
    final ImmutableMap<T, Integer> rankMap;

    ExplicitOrdering(List<T> valuesInOrder) {
        this(Maps.indexMap(valuesInOrder));
    }

    ExplicitOrdering(ImmutableMap<T, Integer> rankMap) {
        this.rankMap = rankMap;
    }

    private int rank(T value) {
        Integer rank = this.rankMap.get(value);
        if (rank == null) {
            throw new Ordering.IncomparableValueException(value);
        }
        return rank;
    }

    @Override
    public int compare(T left, T right) {
        return this.rank(left) - this.rank(right);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ExplicitOrdering) {
            ExplicitOrdering that = (ExplicitOrdering)object;
            return this.rankMap.equals(that.rankMap);
        }
        return false;
    }

    public int hashCode() {
        return this.rankMap.hashCode();
    }

    public String toString() {
        String string = String.valueOf(this.rankMap.keySet());
        return new StringBuilder(19 + String.valueOf(string).length()).append("Ordering.explicit(").append(string).append(")").toString();
    }
}

