/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.compatproguard;

import com.android.tools.r8.InputDependencyGraphConsumer;
import com.android.tools.r8.origin.Origin;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class DepsFileWriter
implements InputDependencyGraphConsumer {
    private final Path dependentFile;
    private final String dependencyOutput;
    private final Set<Path> dependencies = new HashSet<Path>();

    public DepsFileWriter(Path dependentFile, String dependencyOutput) {
        this.dependentFile = dependentFile;
        this.dependencyOutput = dependencyOutput;
    }

    public static String escape(String filepath) {
        return filepath.replace(" ", "\\ ");
    }

    @Override
    public void accept(Origin dependent, Path dependency) {
        this.dependencies.add(dependency);
    }

    @Override
    public void finished() {
        block14: {
            ArrayList<Path> sorted2 = new ArrayList<Path>(this.dependencies);
            sorted2.sort(Path::compareTo);
            Path output = Paths.get(this.dependencyOutput, new String[0]);
            try {
                BufferedWriter writer;
                block15: {
                    writer = Files.newBufferedWriter(output, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    Throwable throwable = null;
                    try {
                        writer.write(DepsFileWriter.escape(this.dependentFile.toString()));
                        writer.write(":");
                        for (Path path : sorted2) {
                            writer.write(" ");
                            writer.write(DepsFileWriter.escape(path.toString()));
                        }
                        writer.write("\n");
                        if (writer == null) break block14;
                        if (throwable == null) break block15;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (writer != null) {
                                if (throwable != null) {
                                    try {
                                        ((Writer)writer).close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    ((Writer)writer).close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                    try {
                        ((Writer)writer).close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    break block14;
                }
                ((Writer)writer).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

