/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.debuginfo;

import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.dex.VirtualFile;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntIterators;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LebUtils;
import com.android.tools.r8.utils.LineNumberOptimizer;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;

public class DebugRepresentation {
    private final Int2ReferenceMap<CostSummary> paramToInfo;

    public static DebugRepresentationPredicate none(InternalOptions options) {
        assert (!options.canUseDexPc2PcAsDebugInformation());
        return (holder, method) -> false;
    }

    public static DebugRepresentationPredicate fromFiles(List<VirtualFile> files, InternalOptions options) {
        if (!options.canUseDexPc2PcAsDebugInformation()) {
            return DebugRepresentation.none(options);
        }
        if (options.canUseNativeDexPcInsteadOfDebugInfo() || options.testing.forcePcBasedEncoding) {
            return (holder, method) -> true;
        }
        IdentityHashMap classMapping = new IdentityHashMap();
        for (VirtualFile file : files) {
            file.classes().forEach(c -> classMapping.put(c, file));
        }
        return (holder, method) -> {
            if (!DebugRepresentation.isPcCandidate(method)) {
                return false;
            }
            VirtualFile file = (VirtualFile)classMapping.get(holder);
            DebugRepresentation cutoffs = file.getDebugRepresentation();
            return cutoffs.usesPcEncoding(method);
        };
    }

    private DebugRepresentation(Int2ReferenceMap<CostSummary> paramToInfo) {
        this.paramToInfo = paramToInfo;
    }

    public static void computeForFile(VirtualFile file, GraphLens graphLens, NamingLens namingLens, InternalOptions options) {
        if (!options.canUseDexPc2PcAsDebugInformation() || options.canUseNativeDexPcInsteadOfDebugInfo() || options.testing.forcePcBasedEncoding) {
            return;
        }
        Int2ReferenceOpenHashMap<CostSummary> paramCountToCosts = new Int2ReferenceOpenHashMap<CostSummary>();
        for (DexProgramClass clazz : file.classes()) {
            IdentityHashMap<DexString, List<ProgramMethod>> overloads = LineNumberOptimizer.groupMethodsByRenamedName(graphLens, namingLens, clazz);
            for (List<ProgramMethod> methods : overloads.values()) {
                ProgramMethod method;
                DexEncodedMethod definition;
                if (methods.size() != 1 || !DebugRepresentation.isPcCandidate(definition = (DexEncodedMethod)(method = methods.get(0)).getDefinition())) continue;
                DexCode code = definition.getCode().asDexCode();
                DexDebugInfo debugInfo = code.getDebugInfo();
                Instruction lastInstruction = DebugRepresentation.getLastExecutableInstruction(code);
                if (lastInstruction == null) continue;
                int lastPc = lastInstruction.getOffset();
                int debugInfoCost = DebugRepresentation.estimatedDebugInfoSize(debugInfo);
                paramCountToCosts.computeIfAbsent(debugInfo.getParameterCount(), x$0 -> new CostSummary((int)x$0)).addCost(lastPc, debugInfoCost);
            }
        }
        paramCountToCosts.forEach((ignored, summary) -> ((CostSummary)summary).computeConversionCosts());
        file.setDebugRepresentation(new DebugRepresentation(paramCountToCosts));
    }

    private boolean usesPcEncoding(DexEncodedMethod method) {
        DexCode code = method.getCode().asDexCode();
        DexDebugInfo debugInfo = code.getDebugInfo();
        int paramCount = debugInfo.getParameterCount();
        CostSummary conversionInfo = (CostSummary)this.paramToInfo.get(paramCount);
        if (conversionInfo.cutoff < 0) {
            return false;
        }
        Instruction lastInstruction = DebugRepresentation.getLastExecutableInstruction(code);
        if (lastInstruction == null) {
            return false;
        }
        int maxPc = lastInstruction.getOffset();
        return maxPc <= conversionInfo.cutoff;
    }

    private static boolean isPcCandidate(DexEncodedMethod method) {
        if (!method.hasCode() || !method.getCode().isDexCode()) {
            return false;
        }
        DexCode code = method.getCode().asDexCode();
        return LineNumberOptimizer.doesContainPositions(code);
    }

    private static Instruction getLastExecutableInstruction(DexCode code) {
        Instruction lastInstruction = null;
        for (Instruction instruction : code.instructions) {
            if (instruction.isPayload()) continue;
            lastInstruction = instruction;
        }
        return lastInstruction;
    }

    private static int estimatedDebugInfoSize(DexDebugInfo info) {
        if (info.isPcBasedInfo()) {
            return info.asPcBasedInfo().estimatedWriteSize();
        }
        int parameterCount = info.getParameterCount();
        int eventCount = info.asEventBasedInfo().events.length;
        return LebUtils.sizeAsUleb128(0) + LebUtils.sizeAsUleb128(parameterCount) + LebUtils.sizeAsUleb128(0) * parameterCount + eventCount + 1;
    }

    public String toString() {
        ArrayList<CostSummary> sorted2 = new ArrayList<CostSummary>(this.paramToInfo.values());
        sorted2.sort(Comparator.comparing(i -> ((CostSummary)i).paramCount));
        return StringUtils.join("\n", sorted2, CostSummary::toString);
    }

    private static class CostSummary {
        private final int paramCount;
        private final Int2ReferenceMap<PcNormalCost> pcToCost = new Int2ReferenceOpenHashMap<PcNormalCost>();
        private int minPc = Integer.MAX_VALUE;
        private int maxPc = Integer.MIN_VALUE;
        private int cutoff;
        private int normalPreCutoffCost;
        private int normalPostCutoffCost;

        private CostSummary(int paramCount) {
            assert (paramCount >= 0);
            this.paramCount = paramCount;
        }

        private void addCost(int pc, int cost) {
            assert (pc >= 0);
            this.pcToCost.computeIfAbsent(pc, PcNormalCost::new).add(cost);
            this.minPc = Math.min(this.minPc, pc);
            this.maxPc = Math.max(this.maxPc, pc);
        }

        private void computeConversionCosts() {
            assert (!this.pcToCost.isEmpty());
            int currentConvertedPc = -1;
            int normalConvertedCost = 0;
            int normalOutstandingCost = 0;
            int[] sortedPcs = new int[this.pcToCost.size()];
            IntIterators.unwrap(this.pcToCost.keySet().iterator(), sortedPcs);
            Arrays.sort(sortedPcs);
            for (int currentPc : sortedPcs) {
                PcNormalCost pcSummary = (PcNormalCost)this.pcToCost.get(currentPc);
                int costToConvert = currentPc - currentConvertedPc;
                if ((normalOutstandingCost += pcSummary.cost) <= costToConvert) continue;
                normalConvertedCost += normalOutstandingCost;
                normalOutstandingCost = 0;
                currentConvertedPc = currentPc;
            }
            this.cutoff = currentConvertedPc;
            this.normalPreCutoffCost = normalConvertedCost;
            this.normalPostCutoffCost = normalOutstandingCost;
            assert (this.cutoff >= -1);
            assert (this.normalPreCutoffCost >= 0);
            assert (this.normalPostCutoffCost >= 0);
            assert (this.preCutoffPcCost() >= 0);
            assert (this.postCutoffPcCost() >= 0);
        }

        private int preCutoffPcCost() {
            return this.cutoff > 0 ? DexDebugInfo.PcBasedDebugInfo.estimatedWriteSize(this.paramCount, this.cutoff) : 0;
        }

        private int postCutoffPcCost() {
            return this.cutoff < this.maxPc ? DexDebugInfo.PcBasedDebugInfo.estimatedWriteSize(this.paramCount, this.maxPc - this.cutoff) : 0;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("p:").append(this.paramCount).append(", c:").append(this.cutoff).append(", m:").append(this.maxPc);
            if (this.cutoff > 0) {
                builder.append(", preCutNormal:").append(this.normalPreCutoffCost).append(", preCutPC:").append(this.preCutoffPcCost());
            }
            if (this.cutoff < this.maxPc) {
                builder.append(", postCutNormal:").append(this.normalPostCutoffCost).append(", postCutPC:").append(this.postCutoffPcCost());
            }
            return builder.toString();
        }
    }

    private static class PcNormalCost {
        final int pc;
        int cost;
        int methods;

        public PcNormalCost(int pc) {
            assert (pc >= 0);
            this.pc = pc;
        }

        void add(int cost) {
            assert (cost >= 0);
            ++this.methods;
            this.cost += cost;
        }
    }

    public static interface DebugRepresentationPredicate {
        public boolean useDexPcEncoding(DexProgramClass var1, DexEncodedMethod var2);
    }
}

