/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.desugar.desugaredlibrary;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineDesugaredLibrarySpecification;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.references.ArrayReference;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.PackageReference;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.tracereferences.TraceReferencesConsumer;
import com.android.tools.r8.tracereferences.TraceReferencesKeepRules;
import com.android.tools.r8.tracereferences.Tracer;
import com.android.tools.r8.tracereferences.internal.TracedClassImpl;
import com.android.tools.r8.tracereferences.internal.TracedFieldImpl;
import com.android.tools.r8.tracereferences.internal.TracedMethodImpl;
import com.android.tools.r8.utils.ClassReferenceUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.NopDiagnosticsHandler;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.TypeReferenceUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public class DesugaredLibraryKeepRuleGenerator {
    private final AppView<AppInfoWithClassHierarchy> appView;
    private final NamingLens namingLens;
    private final InternalOptions options;

    public DesugaredLibraryKeepRuleGenerator(AppView<AppInfoWithClassHierarchy> appView, NamingLens namingLens) {
        this.appView = appView;
        this.namingLens = namingLens;
        this.options = appView.options();
    }

    private boolean shouldRun() {
        if (this.options.isDesugaredLibraryCompilation() || this.options.desugaredLibraryKeepRuleConsumer == null || !this.options.testing.enableExperimentalDesugaredLibraryKeepRuleGenerator) {
            return false;
        }
        return this.namingLens.hasPrefixRewritingLogic() || this.options.machineDesugaredLibrarySpecification.hasEmulatedInterfaces();
    }

    private void run() {
        Tracer tracer = new Tracer(this.appView, new NopDiagnosticsHandler(), this.createTargetPredicate());
        tracer.run(this.createTraceReferencesConsumer());
    }

    private Predicate<DexType> createTargetPredicate() {
        MachineDesugaredLibrarySpecification desugaredLibrarySpecification = this.options.machineDesugaredLibrarySpecification;
        byte[] synthesizedLibraryClassesPackageDescriptorPrefix = DexString.encodeToMutf8("L" + desugaredLibrarySpecification.getSynthesizedLibraryClassesPackagePrefix());
        return type -> this.namingLens.prefixRewrittenType((DexType)type) != null || desugaredLibrarySpecification.isEmulatedInterfaceRewrittenType((DexType)type) || desugaredLibrarySpecification.isCustomConversionRewrittenType((DexType)type) || type.getDescriptor().startsWith(synthesizedLibraryClassesPackageDescriptorPrefix);
    }

    private KeepRuleGenerator createTraceReferencesConsumer() {
        return new KeepRuleGenerator(this.appView, this.namingLens);
    }

    public void runIfNecessary(Timing timing) {
        if (this.shouldRun()) {
            timing.begin("Desugared library keep rule generator");
            this.run();
            timing.end();
        }
    }

    private static class KeepRuleGenerator
    extends TraceReferencesConsumer.ForwardingConsumer {
        private final DexItemFactory factory;
        private final NamingLens namingLens;
        private final Map<ClassReference, ClassReference> classRewritingCache = new ConcurrentHashMap<ClassReference, ClassReference>();
        private final Map<FieldReference, FieldReference> fieldRewritingCache = new ConcurrentHashMap<FieldReference, FieldReference>();
        private final Map<MethodReference, MethodReference> methodRewritingCache = new ConcurrentHashMap<MethodReference, MethodReference>();
        private final Map<TypeReference, DexType> typeConversionCache = new ConcurrentHashMap<TypeReference, DexType>();

        private KeepRuleGenerator(AppView<? extends AppInfoWithClassHierarchy> appView, NamingLens namingLens) {
            super(TraceReferencesKeepRules.builder().setOutputConsumer(appView.options().desugaredLibraryKeepRuleConsumer).build());
            this.factory = appView.dexItemFactory();
            this.namingLens = namingLens;
        }

        private DexType convertClassReference(ClassReference classReference) {
            return this.typeConversionCache.computeIfAbsent(classReference, key -> ClassReferenceUtils.toDexType(key.asClass(), this.factory));
        }

        private DexProto convertProto(List<TypeReference> formalTypes, TypeReference returnType) {
            return TypeReferenceUtils.toDexProto(formalTypes, returnType, this.factory, this::convertClassReference);
        }

        private DexType convertTypeReference(TypeReference typeReference) {
            return this.typeConversionCache.computeIfAbsent(typeReference, key -> TypeReferenceUtils.toDexType(key, this.factory, this::convertClassReference));
        }

        private ClassReference rewrittenWithLens(ClassReference classReference) {
            ClassReference cached = this.classRewritingCache.get(classReference);
            if (cached != null) {
                return cached;
            }
            return this.internalRewrittenWithLens(classReference, this.convertClassReference(classReference));
        }

        private ClassReference rewrittenWithLens(ClassReference classReference, DexType type) {
            ClassReference cached = this.classRewritingCache.get(classReference);
            if (cached != null) {
                return cached;
            }
            return this.internalRewrittenWithLens(classReference, type);
        }

        private ClassReference internalRewrittenWithLens(ClassReference classReference, DexType type) {
            DexString rewrittenDescriptor = this.namingLens.lookupClassDescriptor(type);
            return this.addCacheEntry(classReference, rewrittenDescriptor != type.getDescriptor() ? Reference.classFromDescriptor(rewrittenDescriptor.toString()) : classReference, this.classRewritingCache);
        }

        private FieldReference rewrittenWithLens(FieldReference fieldReference) {
            TypeReference rewrittenFieldType;
            String rewrittenFieldName;
            FieldReference cached = this.fieldRewritingCache.get(fieldReference);
            if (cached != null) {
                return cached;
            }
            DexField field = this.factory.createField(this.convertClassReference(fieldReference.getHolderClass()), this.convertTypeReference(fieldReference.getFieldType()), fieldReference.getFieldName());
            ClassReference rewrittenFieldHolder = this.rewrittenWithLens(fieldReference.getHolderClass(), field.getHolderType());
            FieldReference rewrittenFieldReference = Reference.field(rewrittenFieldHolder, rewrittenFieldName = this.namingLens.lookupName(field).toString(), rewrittenFieldType = this.rewrittenWithLens(fieldReference.getFieldType(), field.getType()));
            return this.addCacheEntry(fieldReference, rewrittenFieldReference.equals(fieldReference) ? fieldReference : rewrittenFieldReference, this.fieldRewritingCache);
        }

        private MethodReference rewrittenWithLens(MethodReference methodReference) {
            TypeReference rewrittenMethodReturnType;
            MethodReference cached = this.methodRewritingCache.get(methodReference);
            if (cached != null) {
                return cached;
            }
            DexMethod method = this.factory.createMethod(this.convertClassReference(methodReference.getHolderClass()), this.convertProto(methodReference.getFormalTypes(), methodReference.getReturnType()), methodReference.getMethodName());
            ClassReference rewrittenMethodHolder = this.rewrittenWithLens(methodReference.getHolderClass(), method.getHolderType());
            String rewrittenMethodName = this.namingLens.lookupName(method).toString();
            Iterator<DexType> parameterIterator = method.getParameters().iterator();
            List<TypeReference> rewrittenMethodFormalTypes = ListUtils.mapOrElse(methodReference.getFormalTypes(), formalType -> this.rewrittenWithLens((TypeReference)formalType, (DexType)parameterIterator.next()), methodReference.getFormalTypes());
            MethodReference rewrittenMethodReference = Reference.method(rewrittenMethodHolder, rewrittenMethodName, rewrittenMethodFormalTypes, rewrittenMethodReturnType = this.rewrittenWithLens(methodReference.getReturnType(), method.getReturnType()));
            return this.addCacheEntry(methodReference, rewrittenMethodReference.equals(methodReference) ? methodReference : rewrittenMethodReference, this.methodRewritingCache);
        }

        private TypeReference rewrittenWithLens(TypeReference typeReference, DexType type) {
            if (typeReference == null || typeReference.isPrimitive()) {
                return typeReference;
            }
            if (typeReference.isArray()) {
                ArrayReference arrayReference = typeReference.asArray();
                TypeReference baseType = arrayReference.getBaseType();
                if (baseType.isPrimitive()) {
                    return typeReference;
                }
                assert (baseType.isClass());
                ClassReference rewrittenBaseType = this.rewrittenWithLens(baseType.asClass());
                return rewrittenBaseType != baseType ? Reference.array(rewrittenBaseType, arrayReference.getDimensions()) : typeReference;
            }
            assert (typeReference.isClass());
            return this.rewrittenWithLens(typeReference.asClass(), type);
        }

        private <T> T addCacheEntry(T reference, T rewrittenReference, Map<T, T> rewritingCache) {
            rewritingCache.put(reference, rewrittenReference);
            return rewrittenReference;
        }

        @Override
        public void acceptType(TraceReferencesConsumer.TracedClass tracedClass, DiagnosticsHandler handler) {
            ClassReference rewrittenReference = this.rewrittenWithLens((ClassReference)tracedClass.getReference());
            super.acceptType(rewrittenReference != tracedClass.getReference() ? new TracedClassImpl(rewrittenReference, tracedClass.getReferencedFromContext(), (TraceReferencesConsumer.ClassAccessFlags)tracedClass.getAccessFlags()) : tracedClass, handler);
        }

        @Override
        public void acceptField(TraceReferencesConsumer.TracedField tracedField, DiagnosticsHandler handler) {
            FieldReference rewrittenReference = this.rewrittenWithLens((FieldReference)tracedField.getReference());
            super.acceptField(rewrittenReference != tracedField.getReference() ? new TracedFieldImpl(rewrittenReference, tracedField.getReferencedFromContext(), (TraceReferencesConsumer.FieldAccessFlags)tracedField.getAccessFlags()) : tracedField, handler);
        }

        @Override
        public void acceptMethod(TraceReferencesConsumer.TracedMethod tracedMethod, DiagnosticsHandler handler) {
            MethodReference rewrittenReference = this.rewrittenWithLens((MethodReference)tracedMethod.getReference());
            super.acceptMethod(rewrittenReference != tracedMethod.getReference() ? new TracedMethodImpl(rewrittenReference, tracedMethod.getReferencedFromContext(), (TraceReferencesConsumer.MethodAccessFlags)tracedMethod.getAccessFlags()) : tracedMethod, handler);
        }

        @Override
        public void acceptPackage(PackageReference pkg, DiagnosticsHandler handler) {
            super.acceptPackage(pkg, handler);
        }
    }
}

