/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.StringResource;
import com.android.tools.r8.dex.DexParser;
import com.android.tools.r8.dex.DexReader;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.UnsupportedMainDexListUsageDiagnostic;
import com.android.tools.r8.graph.ApplicationReaderMap;
import com.android.tools.r8.graph.ClassKind;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexApplicationReadFlags;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.JarClassFileReader;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.MainDexInfo;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.ClassProvider;
import com.android.tools.r8.utils.ClasspathClassCollection;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.DexVersion;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LibraryClassCollection;
import com.android.tools.r8.utils.MainDexListParser;
import com.android.tools.r8.utils.ProgramClassCollection;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class ApplicationReader {
    private final InternalOptions options;
    private final DexItemFactory itemFactory;
    private final Timing timing;
    private final AndroidApp inputApp;
    private DexApplicationReadFlags flags;

    public ApplicationReader(AndroidApp inputApp, InternalOptions options, Timing timing) {
        this.options = options;
        this.itemFactory = options.itemFactory;
        this.timing = timing;
        this.inputApp = inputApp;
    }

    private void dumpApplication() throws IOException {
        Path dumpOutput = null;
        boolean cleanDump = false;
        if (this.options.dumpInputToFile != null) {
            dumpOutput = Paths.get(this.options.dumpInputToFile, new String[0]);
        } else if (this.options.dumpInputToDirectory != null) {
            dumpOutput = Paths.get(this.options.dumpInputToDirectory, new String[0]).resolve("dump" + System.nanoTime() + ".zip");
        } else if (this.options.testing.dumpAll) {
            cleanDump = true;
            dumpOutput = Paths.get("/tmp", new String[0]).resolve("dump" + System.nanoTime() + ".zip");
        }
        if (dumpOutput != null) {
            this.timing.begin("ApplicationReader.dump");
            this.inputApp.dump(dumpOutput, this.options.dumpOptions, this.options.reporter, this.options.dexItemFactory());
            if (cleanDump) {
                Files.delete(dumpOutput);
            }
            this.timing.end();
            StringDiagnostic message = new StringDiagnostic("Dumped compilation inputs to: " + dumpOutput);
            if (this.options.dumpInputToFile != null) {
                throw this.options.reporter.fatalError(message);
            }
            if (!cleanDump) {
                this.options.reporter.info(message);
            }
        }
    }

    private MainDexInfo readMainDexClasses(DexApplication app, boolean emitDeprecatedDiagnostics) {
        MainDexInfo.Builder builder = MainDexInfo.none().builder();
        if (this.inputApp.hasMainDexList()) {
            for (StringResource resource : this.inputApp.getMainDexListResources()) {
                if (emitDeprecatedDiagnostics) {
                    this.options.reporter.warning(new UnsupportedMainDexListUsageDiagnostic(resource.getOrigin()));
                }
                this.addToMainDexClasses(app, builder, MainDexListParser.parseList(resource, this.itemFactory));
            }
            if (!this.inputApp.getMainDexClasses().isEmpty()) {
                if (emitDeprecatedDiagnostics) {
                    this.options.reporter.warning(new UnsupportedMainDexListUsageDiagnostic(Origin.unknown()));
                }
                this.addToMainDexClasses(app, builder, this.inputApp.getMainDexClasses().stream().map(clazz -> this.itemFactory.createType(DescriptorUtils.javaTypeToDescriptor(clazz))).collect(Collectors.toList()));
            }
        }
        return builder.buildList();
    }

    private void addToMainDexClasses(DexApplication app, MainDexInfo.Builder builder, Iterable<DexType> types) {
        for (DexType type : types) {
            DexProgramClass clazz = app.programDefinitionFor(type);
            if (clazz != null) {
                builder.addList(clazz);
                continue;
            }
            if (this.options.ignoreMainDexMissingClasses) continue;
            this.options.reporter.warning(new StringDiagnostic("Application does not contain `" + type.toSourceString() + "` as referenced in main-dex-list."));
        }
    }

    private static boolean verifyMainDexOptionsCompatible(AndroidApp inputApp, InternalOptions options) {
        if (!options.isGeneratingDex()) {
            return true;
        }
        AndroidApiLevel nativeMultiDex = AndroidApiLevel.L;
        if (options.getMinApiLevel().isLessThan(nativeMultiDex)) {
            return true;
        }
        assert (options.mainDexKeepRules.isEmpty());
        assert (options.mainDexListConsumer == null);
        assert (!inputApp.hasMainDexList());
        return true;
    }

    private AndroidApiLevel validateOrComputeMinApiLevel(AndroidApiLevel computedMinApiLevel, DexReader dexReader) {
        DexVersion version = dexReader.getDexVersion();
        if (this.options.getMinApiLevel() == AndroidApiLevel.getDefault()) {
            computedMinApiLevel = computedMinApiLevel.max(AndroidApiLevel.getMinAndroidApiLevel(version));
        } else if (!version.matchesApiLevel(this.options.getMinApiLevel())) {
            throw new CompilationError("Dex file with version '" + version.getIntValue() + "' cannot be used with min sdk level '" + this.options.getMinApiLevel() + "'.");
        }
        return computedMinApiLevel;
    }

    private void readProguardMap(StringResource map, DexApplication.Builder<?> builder, ExecutorService executorService, List<Future<?>> futures) {
        if (map == null) {
            return;
        }
        futures.add(executorService.submit(() -> {
            try {
                String content = map.getString();
                builder.setProguardMap(ClassNameMapper.mapperFromString(content, this.options.reporter, false, this.options.testing.enableExperimentalMapFileVersion));
            }
            catch (ResourceException | IOException e) {
                throw new CompilationError("Failure to read proguard map file", e, map.getOrigin());
            }
        }));
    }

    public LazyLoadedDexApplication read() throws IOException {
        return this.read((StringResource)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyLoadedDexApplication read(StringResource proguardMap) throws IOException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            LazyLoadedDexApplication lazyLoadedDexApplication = this.read(proguardMap, executor);
            return lazyLoadedDexApplication;
        }
        finally {
            executor.shutdown();
        }
    }

    public final LazyLoadedDexApplication read(ExecutorService executorService) throws IOException {
        return this.read(this.inputApp.getProguardMapInputData(), executorService, ProgramClassCollection.defaultConflictResolver(this.options.reporter));
    }

    public final LazyLoadedDexApplication readWithoutDumping(ExecutorService executorService) throws IOException {
        return this.read(this.inputApp.getProguardMapInputData(), executorService, ProgramClassCollection.defaultConflictResolver(this.options.reporter), false);
    }

    public final LazyLoadedDexApplication read(StringResource proguardMap, ExecutorService executorService) throws IOException {
        return this.read(proguardMap, executorService, ProgramClassCollection.defaultConflictResolver(this.options.reporter));
    }

    public final LazyLoadedDexApplication read(StringResource proguardMap, ExecutorService executorService, ProgramClassConflictResolver resolver) throws IOException {
        return this.read(proguardMap, executorService, resolver, true);
    }

    public final LazyLoadedDexApplication read(StringResource proguardMap, ExecutorService executorService, ProgramClassConflictResolver resolver, boolean shouldDump) throws IOException {
        assert (ApplicationReader.verifyMainDexOptionsCompatible(this.inputApp, this.options));
        if (shouldDump) {
            this.dumpApplication();
        }
        if (this.options.testing.verifyInputs) {
            this.inputApp.validateInputs();
        }
        this.timing.begin("DexApplication.read");
        LazyLoadedDexApplication.Builder builder = DexApplication.builder(this.options, this.timing, resolver);
        try {
            ArrayList futures = new ArrayList();
            this.readProguardMap(proguardMap, builder, executorService, futures);
            ClassReader classReader = new ClassReader(executorService, futures);
            classReader.readSources();
            ThreadUtils.awaitFutures(futures);
            this.flags = classReader.getDexApplicationReadFlags();
            builder.setFlags(this.flags);
            classReader.initializeLazyClassCollection(builder);
            for (ProgramResourceProvider provider : this.inputApp.getProgramResourceProviders()) {
                DataResourceProvider dataResourceProvider = provider.getDataResourceProvider();
                if (dataResourceProvider == null) continue;
                builder.addDataResourceProvider(dataResourceProvider);
            }
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.unwrapExecutionException(e);
        }
        catch (ResourceException e) {
            throw this.options.reporter.fatalError(new StringDiagnostic(e.getMessage(), e.getOrigin()));
        }
        finally {
            this.timing.end();
        }
        return builder.build();
    }

    public MainDexInfo readMainDexClasses(DexApplication app) {
        return this.readMainDexClasses(app, this.flags.hasReadProgramClassFromCf());
    }

    public MainDexInfo readMainDexClassesForR8(DexApplication app) {
        return this.readMainDexClasses(app, true);
    }

    private final class ClassReader {
        private final ExecutorService executorService;
        private final List<Future<?>> futures;
        private final Queue<DexProgramClass> programClasses = new ConcurrentLinkedQueue<DexProgramClass>();
        private final Queue<DexClasspathClass> classpathClasses = new ConcurrentLinkedQueue<DexClasspathClass>();
        private final Queue<DexLibraryClass> libraryClasses = new ConcurrentLinkedQueue<DexLibraryClass>();
        private final JarApplicationReader application = new JarApplicationReader(ApplicationReader.access$000(ApplicationReader.this));
        private boolean hasReadProgramResourceFromCf = false;
        private boolean hasReadProgramResourceFromDex = false;

        ClassReader(ExecutorService executorService, List<Future<?>> futures) {
            this.executorService = executorService;
            this.futures = futures;
        }

        private void readDexSources(List<ProgramResource> dexSources, Queue<DexProgramClass> classes) throws IOException, ResourceException {
            if (dexSources.isEmpty()) {
                return;
            }
            this.hasReadProgramResourceFromDex = true;
            ArrayList<DexParser<DexProgramClass>> dexParsers = new ArrayList<DexParser<DexProgramClass>>(dexSources.size());
            AndroidApiLevel computedMinApiLevel = ApplicationReader.this.options.getMinApiLevel();
            for (ProgramResource programResource : dexSources) {
                DexReader dexReader = new DexReader(programResource);
                if (((ApplicationReader)ApplicationReader.this).options.passthroughDexCode) {
                    computedMinApiLevel = ApplicationReader.this.validateOrComputeMinApiLevel(computedMinApiLevel, dexReader);
                }
                dexParsers.add(new DexParser<DexProgramClass>(dexReader, ClassKind.PROGRAM, ApplicationReader.this.options));
            }
            ApplicationReader.this.options.setMinApiLevel(computedMinApiLevel);
            for (DexParser dexParser : dexParsers) {
                dexParser.populateIndexTables();
            }
            if (!((ApplicationReader)ApplicationReader.this).options.skipReadingDexCode) {
                ApplicationReaderMap applicationReaderMap = ApplicationReaderMap.getInstance(ApplicationReader.this.options);
                for (DexParser dexParser : dexParsers) {
                    this.futures.add(this.executorService.submit(() -> dexParser.addClassDefsTo(classes::add, applicationReaderMap)));
                }
            }
        }

        private boolean includeAnnotationClass(DexProgramClass clazz) {
            if (!((ApplicationReader)ApplicationReader.this).options.pruneNonVissibleAnnotationClasses) {
                return true;
            }
            DexAnnotation retentionAnnotation = clazz.annotations().getFirstMatching(((ApplicationReader)ApplicationReader.this).itemFactory.retentionType);
            if (retentionAnnotation == null) {
                return DexAnnotation.retainCompileTimeAnnotation(clazz.getType(), this.application.options);
            }
            return retentionAnnotation.annotation.toString().contains("RUNTIME");
        }

        private void readClassSources(List<ProgramResource> classSources, Queue<DexProgramClass> classes) {
            if (classSources.isEmpty()) {
                return;
            }
            this.hasReadProgramResourceFromCf = true;
            JarClassFileReader<DexProgramClass> reader = new JarClassFileReader<DexProgramClass>(this.application, clazz -> {
                if (clazz.isAnnotation() && !this.includeAnnotationClass((DexProgramClass)clazz)) {
                    return;
                }
                classes.add((DexProgramClass)clazz);
            }, ClassKind.PROGRAM);
            for (ProgramResource input : classSources) {
                this.futures.add(this.executorService.submit(() -> {
                    reader.read(input);
                    return null;
                }));
            }
        }

        private <T extends DexClass> ClassProvider<T> buildClassProvider(ClassKind<T> classKind, Queue<T> preloadedClasses, List<ClassFileResourceProvider> resourceProviders, JarApplicationReader reader) {
            ArrayList providers = new ArrayList();
            if (!preloadedClasses.isEmpty()) {
                providers.add(ClassProvider.forPreloadedClasses(classKind, preloadedClasses));
            }
            for (ClassFileResourceProvider provider : resourceProviders) {
                providers.add(ClassProvider.forClassFileResources(classKind, provider, reader));
            }
            if (providers.isEmpty()) {
                return null;
            }
            return providers.size() == 1 ? (ClassProvider)providers.get(0) : ClassProvider.combine(classKind, providers);
        }

        public DexApplicationReadFlags getDexApplicationReadFlags() {
            return new DexApplicationReadFlags(this.hasReadProgramResourceFromDex, this.hasReadProgramResourceFromCf, this.application.hasReadRecordReferenceFromProgramClass());
        }

        void readSources() throws IOException, ResourceException {
            Collection<ProgramResource> resources = ApplicationReader.this.inputApp.computeAllProgramResources();
            ArrayList<ProgramResource> dexResources = new ArrayList<ProgramResource>(resources.size());
            ArrayList<ProgramResource> cfResources = new ArrayList<ProgramResource>(resources.size());
            for (ProgramResource resource : resources) {
                if (resource.getKind() == ProgramResource.Kind.DEX) {
                    dexResources.add(resource);
                    continue;
                }
                assert (resource.getKind() == ProgramResource.Kind.CF);
                cfResources.add(resource);
            }
            this.readDexSources(dexResources, this.programClasses);
            this.readClassSources(cfResources, this.programClasses);
        }

        void initializeLazyClassCollection(LazyLoadedDexApplication.Builder builder) {
            ClassProvider<DexLibraryClass> libraryClassProvider;
            for (DexProgramClass clazz : this.programClasses) {
                builder.addProgramClass(clazz.asProgramClass());
            }
            ClassProvider<DexClasspathClass> classpathClassProvider = this.buildClassProvider(ClassKind.CLASSPATH, this.classpathClasses, ApplicationReader.this.inputApp.getClasspathResourceProviders(), this.application);
            if (classpathClassProvider != null) {
                builder.setClasspathClassCollection(new ClasspathClassCollection(classpathClassProvider));
            }
            if ((libraryClassProvider = this.buildClassProvider(ClassKind.LIBRARY, this.libraryClasses, ApplicationReader.this.inputApp.getLibraryResourceProviders(), this.application)) != null) {
                builder.setLibraryClassCollection(new LibraryClassCollection(libraryClassProvider));
            }
        }
    }

    public static interface ProgramClassConflictResolver {
        public DexProgramClass resolveClassConflict(DexProgramClass var1, DexProgramClass var2);
    }
}

