/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.ByteBufferProvider;
import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.DataDirectoryResource;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DataResourceConsumer;
import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.SourceFileEnvironment;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ObjectArrays;
import com.android.tools.r8.debuginfo.DebugRepresentation;
import com.android.tools.r8.dex.ClassesChecksum;
import com.android.tools.r8.dex.CodeToKeep;
import com.android.tools.r8.dex.FileWriter;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.dex.ResourceAdapter;
import com.android.tools.r8.dex.VirtualFile;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.features.FeatureSplitConfiguration;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationDirectory;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexDebugInfoForWriting;
import com.android.tools.r8.graph.DexEncodedArray;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.DexWritableCode;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.ProguardMapSupplier;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.MainDexInfo;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.Box;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LineNumberOptimizer;
import com.android.tools.r8.utils.OriginalSourceFiles;
import com.android.tools.r8.utils.PredicateUtils;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.structural.StructuralItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ApplicationWriter {
    public final AppView<?> appView;
    public final NamingLens namingLens;
    public final InternalOptions options;
    private final CodeToKeep desugaredLibraryCodeToKeep;
    private final Predicate<DexType> isTypeMissing;
    public List<Marker> markers;
    public List<DexString> markerStrings;
    public DexIndexedConsumer programConsumer;

    public ApplicationWriter(AppView<?> appView, List<Marker> markers, NamingLens namingLens) {
        this(appView, markers, namingLens, null);
    }

    public ApplicationWriter(AppView<?> appView, List<Marker> markers, NamingLens namingLens, DexIndexedConsumer consumer) {
        this.appView = appView;
        this.options = appView.options();
        this.desugaredLibraryCodeToKeep = CodeToKeep.createCodeToKeep(this.options, namingLens);
        this.markers = markers;
        this.namingLens = namingLens;
        this.programConsumer = consumer;
        this.isTypeMissing = PredicateUtils.isNull(arg_0 -> appView.appInfo().definitionForWithoutExistenceAssert(arg_0));
    }

    private List<VirtualFile> distribute(ExecutorService executorService) throws ExecutionException, IOException {
        VirtualFile.Distributor distributor = this.options.isGeneratingDexFilePerClassFile() ? new VirtualFile.FilePerInputClassDistributor(this, this.options.getDexFilePerClassFileConsumer().combineSyntheticClassesWithPrimaryClass()) : (!this.options.canUseMultidex() && this.options.mainDexKeepRules.isEmpty() && ((AppInfo)this.appView.appInfo()).getMainDexInfo().isEmpty() && this.options.enableMainDexListCheck ? new VirtualFile.MonoDexDistributor(this, this.options) : new VirtualFile.FillFilesDistributor(this, this.options, executorService));
        return ((VirtualFile.Distributor)distributor).run();
    }

    private void encodeChecksums(Iterable<VirtualFile> files) {
        Collection<DexProgramClass> classes = ((AppInfo)this.appView.appInfo()).classes();
        Reference2LongOpenHashMap<DexString> inputChecksums = new Reference2LongOpenHashMap<DexString>(classes.size());
        for (DexProgramClass clazz : classes) {
            inputChecksums.put(this.namingLens.lookupDescriptor(clazz.getType()), clazz.getChecksum());
        }
        for (VirtualFile file : files) {
            ClassesChecksum toWrite = new ClassesChecksum();
            for (DexProgramClass clazz : file.classes()) {
                DexString desc = this.namingLens.lookupDescriptor(clazz.type);
                toWrite.addChecksum(desc.toString(), inputChecksums.getLong(desc));
            }
            file.injectString(this.appView.dexItemFactory().createString(toWrite.toJsonString()));
        }
    }

    private boolean willComputeProguardMap() {
        return this.options.proguardMapConsumer != null;
    }

    private void computeMarkerStrings(final Box<ProguardMapSupplier.ProguardMapId> delayedProguardMapId, List<LazyDexString> lazyDexStrings) {
        if (this.markers != null && !this.markers.isEmpty()) {
            int firstNonLazyMarker = 0;
            if (this.willComputeProguardMap()) {
                ++firstNonLazyMarker;
                lazyDexStrings.add(new LazyDexString(){

                    @Override
                    public DexString internalCompute() {
                        Marker marker = ApplicationWriter.this.markers.get(0);
                        marker.setPgMapId(((ProguardMapSupplier.ProguardMapId)delayedProguardMapId.get()).getId());
                        return marker.toDexString(ApplicationWriter.this.appView.dexItemFactory());
                    }
                });
            }
            this.markerStrings = new ArrayList<DexString>(this.markers.size() - firstNonLazyMarker);
            for (int i = firstNonLazyMarker; i < this.markers.size(); ++i) {
                this.markerStrings.add(this.markers.get(i).toDexString(this.appView.dexItemFactory()));
            }
        }
    }

    private OriginalSourceFiles computeSourceFileString(final Box<ProguardMapSupplier.ProguardMapId> delayedProguardMapId, List<LazyDexString> lazyDexStrings) {
        if (this.options.sourceFileProvider == null) {
            return OriginalSourceFiles.fromClasses();
        }
        if (!this.willComputeProguardMap()) {
            this.rewriteSourceFile(null);
            return OriginalSourceFiles.unreachable();
        }
        Collection<DexProgramClass> classes = ((AppInfo)this.appView.appInfo()).classes();
        HashMap<DexType, DexString> originalSourceFiles = new HashMap<DexType, DexString>(classes.size());
        for (DexProgramClass clazz : classes) {
            DexString originalSourceFile = clazz.getSourceFile();
            if (originalSourceFile == null) continue;
            originalSourceFiles.put(clazz.getType(), originalSourceFile);
            clazz.setSourceFile(null);
        }
        lazyDexStrings.add(new LazyDexString(){

            @Override
            public DexString internalCompute() {
                return ApplicationWriter.this.rewriteSourceFile((ProguardMapSupplier.ProguardMapId)delayedProguardMapId.get());
            }
        });
        return OriginalSourceFiles.fromMap(originalSourceFiles);
    }

    public static SourceFileEnvironment createSourceFileEnvironment(final ProguardMapSupplier.ProguardMapId proguardMapId) {
        if (proguardMapId == null) {
            return new SourceFileEnvironment(){

                @Override
                public String getMapId() {
                    return null;
                }

                @Override
                public String getMapHash() {
                    return null;
                }
            };
        }
        return new SourceFileEnvironment(){

            @Override
            public String getMapId() {
                return proguardMapId.getId();
            }

            @Override
            public String getMapHash() {
                return proguardMapId.getHash();
            }
        };
    }

    private DexString rewriteSourceFile(ProguardMapSupplier.ProguardMapId proguardMapId) {
        assert (this.options.sourceFileProvider != null);
        SourceFileEnvironment environment = ApplicationWriter.createSourceFileEnvironment(proguardMapId);
        String sourceFile = this.options.sourceFileProvider.get(environment);
        DexString dexSourceFile = sourceFile == null ? null : this.options.itemFactory.createString(sourceFile);
        ((AppInfo)this.appView.appInfo()).classes().forEach(clazz -> clazz.setSourceFile(dexSourceFile));
        return dexSourceFile;
    }

    private void computeOffsetMappingAndRewriteJumboStrings(VirtualFile virtualFile, List<LazyDexString> lazyDexStrings, Timing timing) {
        if (virtualFile.isEmpty()) {
            return;
        }
        timing.begin("Compute object offset mapping");
        virtualFile.computeMapping(this.appView, this.namingLens, lazyDexStrings.size(), timing);
        timing.end();
        timing.begin("Rewrite jumbo strings");
        this.rewriteCodeWithJumboStrings(virtualFile.getObjectMapping(), virtualFile.classes(), ((AppInfo)this.appView.appInfo()).app());
        timing.end();
    }

    private void writeVirtualFile(VirtualFile virtualFile, Timing timing, List<DexString> forcedStrings) {
        ProgramConsumer byteBufferProvider;
        ProgramConsumer consumer;
        if (virtualFile.isEmpty()) {
            return;
        }
        if (this.programConsumer != null) {
            consumer = this.programConsumer;
            byteBufferProvider = this.programConsumer;
        } else if (virtualFile.getPrimaryClassDescriptor() != null) {
            consumer = this.options.getDexFilePerClassFileConsumer();
            byteBufferProvider = this.options.getDexFilePerClassFileConsumer();
        } else if (virtualFile.getFeatureSplit() != null) {
            ProgramConsumer featureConsumer = virtualFile.getFeatureSplit().getProgramConsumer();
            assert (featureConsumer instanceof DexIndexedConsumer);
            consumer = featureConsumer;
            byteBufferProvider = (DexIndexedConsumer)featureConsumer;
        } else {
            consumer = this.options.getDexIndexedConsumer();
            byteBufferProvider = this.options.getDexIndexedConsumer();
        }
        timing.begin("Reindex for lazy strings");
        ObjectToOffsetMapping objectMapping = virtualFile.getObjectMapping();
        objectMapping.computeAndReindexForLazyDexStrings(forcedStrings);
        timing.end();
        timing.begin("Write bytes");
        FileWriter.ByteBufferResult result = this.writeDexFile(objectMapping, (ByteBufferProvider)((Object)byteBufferProvider), timing);
        ByteDataView data2 = new ByteDataView(result.buffer.array(), result.buffer.arrayOffset(), result.length);
        timing.end();
        timing.begin("Pass bytes to consumer");
        if (consumer instanceof DexFilePerClassFileConsumer) {
            ((DexFilePerClassFileConsumer)consumer).accept(virtualFile.getPrimaryClassDescriptor(), data2, virtualFile.getClassDescriptors(), (DiagnosticsHandler)this.options.reporter);
        } else {
            consumer.accept(virtualFile.getId(), data2, virtualFile.getClassDescriptors(), this.options.reporter);
        }
        timing.end();
        data2.invalidate();
        byteBufferProvider.releaseByteBuffer(result.buffer.asByteBuffer());
    }

    public static void supplyAdditionalConsumers(DexApplication application, AppView<?> appView, NamingLens namingLens, InternalOptions options) {
        DataResourceConsumer dataResourceConsumer;
        if (options.configurationConsumer != null) {
            ExceptionUtils.withConsumeResourceHandler(options.reporter, options.configurationConsumer, options.getProguardConfiguration().getParsedConfiguration());
            ExceptionUtils.withFinishedResourceHandler(options.reporter, options.configurationConsumer);
        }
        if (options.mainDexListConsumer != null) {
            ExceptionUtils.withConsumeResourceHandler(options.reporter, options.mainDexListConsumer, ApplicationWriter.writeMainDexList(appView, namingLens));
            ExceptionUtils.withFinishedResourceHandler(options.reporter, options.mainDexListConsumer);
        }
        if ((dataResourceConsumer = options.dataResourceConsumer) != null) {
            ImmutableList<DataResourceProvider> dataResourceProviders = application.dataResourceProviders;
            ResourceAdapter resourceAdapter = new ResourceAdapter(appView, application.dexItemFactory, namingLens, options);
            ApplicationWriter.adaptAndPassDataResources(options, dataResourceConsumer, dataResourceProviders, resourceAdapter);
            if (!appView.appServices().isEmpty()) {
                appView.appServices().visit((service, implementations) -> {
                    String serviceName = DescriptorUtils.descriptorToJavaType(namingLens.lookupDescriptor((DexType)service).toString());
                    dataResourceConsumer.accept(DataEntryResource.fromBytes(StringUtils.lines(implementations.stream().map(namingLens::lookupDescriptor).map(DexString::toString).map(DescriptorUtils::descriptorToJavaType).collect(Collectors.toList())).getBytes(), "META-INF/services/" + serviceName, Origin.unknown()), (DiagnosticsHandler)options.reporter);
                });
            }
        }
        if (options.featureSplitConfiguration != null) {
            for (FeatureSplitConfiguration.DataResourceProvidersAndConsumer entry : options.featureSplitConfiguration.getDataResourceProvidersAndConsumers()) {
                ResourceAdapter resourceAdapter = new ResourceAdapter(appView, application.dexItemFactory, namingLens, options);
                ApplicationWriter.adaptAndPassDataResources(options, entry.getConsumer(), entry.getProviders(), resourceAdapter);
            }
        }
    }

    private static void adaptAndPassDataResources(final InternalOptions options, final DataResourceConsumer dataResourceConsumer, Collection<DataResourceProvider> dataResourceProviders, final ResourceAdapter resourceAdapter) {
        final HashSet generatedResourceNames = new HashSet();
        for (DataResourceProvider dataResourceProvider : dataResourceProviders) {
            try {
                dataResourceProvider.accept(new DataResourceProvider.Visitor(){

                    @Override
                    public void visit(DataDirectoryResource directory) {
                        DataDirectoryResource adapted = resourceAdapter.adaptIfNeeded(directory);
                        if (adapted != null) {
                            dataResourceConsumer.accept(adapted, (DiagnosticsHandler)options.reporter);
                            options.reporter.failIfPendingErrors();
                        }
                    }

                    @Override
                    public void visit(DataEntryResource file) {
                        if (resourceAdapter.isService(file)) {
                            return;
                        }
                        DataEntryResource adapted = resourceAdapter.adaptIfNeeded(file);
                        if (generatedResourceNames.add(adapted.getName())) {
                            dataResourceConsumer.accept(adapted, (DiagnosticsHandler)options.reporter);
                        } else {
                            options.reporter.warning(new StringDiagnostic("Resource '" + file.getName() + "' already exists."));
                        }
                        options.reporter.failIfPendingErrors();
                    }
                });
            }
            catch (ResourceException e) {
                throw new CompilationError(e.getMessage(), e);
            }
        }
    }

    private void insertAttributeAnnotations() {
        for (DexProgramClass clazz : ((AppInfo)this.appView.appInfo()).classes()) {
            this.insertAttributeAnnotationsForClass(clazz);
            clazz.fields().forEach(this::insertAttributeAnnotationsForField);
            clazz.methods().forEach(this::insertAttributeAnnotationsForMethod);
        }
    }

    private void insertAttributeAnnotationsForClass(DexProgramClass clazz) {
        EnclosingMethodAttribute enclosingMethod = clazz.getEnclosingMethodAttribute();
        List<InnerClassAttribute> innerClasses = clazz.getInnerClasses();
        if (enclosingMethod == null && innerClasses.isEmpty() && clazz.getClassSignature().hasNoSignature()) {
            return;
        }
        ArrayList<DexAnnotation> annotations = new ArrayList<DexAnnotation>(2 + innerClasses.size());
        if (enclosingMethod != null) {
            if (enclosingMethod.getEnclosingMethod() != null) {
                annotations.add(DexAnnotation.createEnclosingMethodAnnotation(enclosingMethod.getEnclosingMethod(), this.options.itemFactory));
            } else {
                annotations.add(DexAnnotation.createEnclosingClassAnnotation(enclosingMethod.getEnclosingClass(), this.options.itemFactory));
            }
        }
        if (!innerClasses.isEmpty()) {
            ArrayList<DexType> memberClasses = new ArrayList<DexType>(innerClasses.size());
            for (InnerClassAttribute innerClass : innerClasses) {
                if (clazz.type == innerClass.getInner()) {
                    if (enclosingMethod == null && (innerClass.getOuter() == null || innerClass.isAnonymous())) {
                        this.options.warningMissingEnclosingMember(clazz.type, clazz.origin, clazz.getInitialClassFileVersion());
                        continue;
                    }
                    annotations.add(DexAnnotation.createInnerClassAnnotation(this.namingLens.lookupInnerName(innerClass, this.options), innerClass.getAccess(), this.options.itemFactory));
                    if (innerClass.getOuter() == null || !innerClass.isNamed()) continue;
                    annotations.add(DexAnnotation.createEnclosingClassAnnotation(innerClass.getOuter(), this.options.itemFactory));
                    continue;
                }
                if (clazz.type != innerClass.getOuter() || !innerClass.isNamed()) continue;
                memberClasses.add(innerClass.getInner());
            }
            if (!memberClasses.isEmpty()) {
                annotations.add(DexAnnotation.createMemberClassesAnnotation(memberClasses, this.options.itemFactory));
            }
        }
        if (clazz.getClassSignature().hasSignature()) {
            annotations.add(DexAnnotation.createSignatureAnnotation(clazz.getClassSignature().toRenamedString(this.namingLens, this.isTypeMissing), this.options.itemFactory));
        }
        if (!annotations.isEmpty()) {
            DexAnnotation[] copy = ObjectArrays.concat(clazz.annotations().annotations, annotations.toArray(DexAnnotation.EMPTY_ARRAY), DexAnnotation.class);
            clazz.setAnnotations(DexAnnotationSet.create(copy));
        }
        clazz.clearEnclosingMethodAttribute();
        clazz.clearInnerClasses();
        clazz.clearClassSignature();
    }

    private void insertAttributeAnnotationsForField(DexEncodedField field) {
        if (field.getGenericSignature().hasNoSignature()) {
            return;
        }
        field.setAnnotations(DexAnnotationSet.create(ArrayUtils.appendSingleElement(field.annotations().annotations, DexAnnotation.createSignatureAnnotation(field.getGenericSignature().toRenamedString(this.namingLens, this.isTypeMissing), this.options.itemFactory))));
        field.clearGenericSignature();
    }

    private void insertAttributeAnnotationsForMethod(DexEncodedMethod method) {
        if (method.getGenericSignature().hasNoSignature()) {
            return;
        }
        method.setAnnotations(DexAnnotationSet.create(ArrayUtils.appendSingleElement(method.annotations().annotations, DexAnnotation.createSignatureAnnotation(method.getGenericSignature().toRenamedString(this.namingLens, this.isTypeMissing), this.options.itemFactory))));
        method.clearGenericSignature();
    }

    private void setCallSiteContexts(ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(((AppInfo)this.appView.appInfo()).classes(), this::setCallSiteContexts, executorService);
    }

    private void setCallSiteContexts(DexProgramClass clazz) {
        clazz.forEachProgramMethodMatching(DexEncodedMethod::hasCode, method -> ((DexEncodedMethod)method.getDefinition()).getCode().asDexWritableCode().setCallSiteContexts((ProgramMethod)method));
    }

    private void rewriteCodeWithJumboStrings(ObjectToOffsetMapping mapping, Collection<DexProgramClass> classes, DexApplication application) {
        if (!this.options.testing.forceJumboStringProcessing) {
            if (!mapping.hasJumboStrings()) {
                return;
            }
            if (application.highestSortingString != null && application.highestSortingString.compareTo(mapping.getFirstJumboString()) < 0) {
                return;
            }
        }
        for (DexProgramClass clazz : classes) {
            clazz.forEachProgramMethodMatching(DexEncodedMethod::hasCode, method -> {
                DexWritableCode code = ((DexEncodedMethod)method.getDefinition()).getCode().asDexWritableCode();
                DexWritableCode rewrittenCode = code.rewriteCodeWithJumboStrings((ProgramMethod)method, mapping, application.dexItemFactory, this.options.testing.forceJumboStringProcessing);
                method.setCode(rewrittenCode.asCode(), this.appView);
            });
        }
    }

    private FileWriter.ByteBufferResult writeDexFile(ObjectToOffsetMapping objectMapping, ByteBufferProvider provider, Timing timing) {
        FileWriter fileWriter = new FileWriter(provider, objectMapping, (AppInfo)this.appView.appInfo(), this.options, this.namingLens, this.desugaredLibraryCodeToKeep);
        timing.time("collect", fileWriter::collect);
        return timing.time("generate", fileWriter::generate);
    }

    private static String mapMainDexListName(DexType type, NamingLens namingLens) {
        return DescriptorUtils.descriptorToJavaType(namingLens.lookupDescriptor(type).toString()).replace('.', '/') + ".class";
    }

    private static String writeMainDexList(AppView<?> appView, NamingLens namingLens) {
        MainDexInfo mainDexInfo = ((AppInfo)appView.appInfo()).getMainDexInfo();
        StringBuilder builder = new StringBuilder();
        ArrayList list = new ArrayList(mainDexInfo.size());
        mainDexInfo.forEach(list::add);
        list.sort(StructuralItem::compareTo);
        list.forEach(type -> builder.append(ApplicationWriter.mapMainDexListName(type, namingLens)).append('\n'));
        return builder.toString();
    }

    public void write(ExecutorService executorService) throws IOException, ExecutionException {
        assert (!this.willComputeProguardMap());
        this.write(executorService, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ExecutorService executorService, AndroidApp inputApp) throws IOException, ExecutionException {
        Timing timing = ((AppInfo)this.appView.appInfo()).app().timing;
        timing.begin("DexApplication.write");
        Box<ProguardMapSupplier.ProguardMapId> delayedProguardMapId = new Box<ProguardMapSupplier.ProguardMapId>();
        ArrayList<LazyDexString> lazyDexStrings = new ArrayList<LazyDexString>();
        this.computeMarkerStrings(delayedProguardMapId, lazyDexStrings);
        OriginalSourceFiles originalSourceFiles = this.computeSourceFileString(delayedProguardMapId, lazyDexStrings);
        try {
            timing.begin("Insert Attribute Annotations");
            this.insertAttributeAnnotations();
            timing.end();
            if (this.options.isGeneratingDex()) {
                timing.begin("Set call-site contexts");
                this.setCallSiteContexts(executorService);
                timing.end();
            }
            timing.begin("Distribute");
            List<VirtualFile> virtualFiles = this.distribute(executorService);
            timing.end();
            if (this.options.encodeChecksums) {
                timing.begin("Encode checksums");
                this.encodeChecksums(virtualFiles);
                timing.end();
            }
            assert (this.markers == null || this.markers.isEmpty() || this.appView.dexItemFactory().extractMarkers() != null);
            assert (this.appView.withProtoShrinker(shrinker -> virtualFiles.stream().allMatch(shrinker::verifyDeadProtoTypesNotReferenced), true).booleanValue());
            timing.begin("Sort Annotations");
            SortAnnotations sortAnnotations = new SortAnnotations(this.namingLens);
            ((AppInfo)this.appView.appInfo()).classes().forEach(clazz -> clazz.addDependencies(sortAnnotations));
            timing.end();
            Timing.TimingMerger merger = timing.beginMerger("Pre-write phase", ThreadUtils.getNumberOfThreads(executorService));
            Collection<Timing> timings = ThreadUtils.processItemsWithResults(virtualFiles, virtualFile -> {
                Timing fileTiming = Timing.create("VirtualFile " + virtualFile.getId(), this.options);
                this.computeOffsetMappingAndRewriteJumboStrings((VirtualFile)virtualFile, (List<LazyDexString>)lazyDexStrings, fileTiming);
                DebugRepresentation.computeForFile(virtualFile, this.appView.graphLens(), this.namingLens, this.options);
                fileTiming.end();
                return fileTiming;
            }, executorService);
            merger.add(timings);
            merger.end();
            if (this.willComputeProguardMap()) {
                DebugRepresentation.DebugRepresentationPredicate representation = DebugRepresentation.fromFiles(virtualFiles, this.options);
                delayedProguardMapId.set(LineNumberOptimizer.runAndWriteMap(inputApp, this.appView, this.namingLens, timing, originalSourceFiles, representation));
            }
            timing.begin("Compute lazy strings");
            ArrayList<DexString> forcedStrings = new ArrayList<DexString>();
            for (LazyDexString lazyDexString : lazyDexStrings) {
                forcedStrings.add(lazyDexString.compute());
            }
            timing.end();
            Timing.TimingMerger merger2 = timing.beginMerger("Write files", ThreadUtils.getNumberOfThreads(executorService));
            Collection<Timing> timings2 = ThreadUtils.processItemsWithResults(virtualFiles, virtualFile -> {
                Timing fileTiming = Timing.create("VirtualFile " + virtualFile.getId(), this.options);
                this.writeVirtualFile((VirtualFile)virtualFile, fileTiming, (List<DexString>)forcedStrings);
                fileTiming.end();
                return fileTiming;
            }, executorService);
            merger2.add(timings2);
            merger2.end();
            if (this.options.desugaredLibraryKeepRuleConsumer != null && !this.desugaredLibraryCodeToKeep.isNop()) {
                assert (!this.options.isDesugaredLibraryCompilation());
                this.desugaredLibraryCodeToKeep.generateKeepRules(this.options);
            }
            this.options.reporter.failIfPendingErrors();
            ApplicationWriter.supplyAdditionalConsumers(((AppInfo)this.appView.appInfo()).app(), this.appView, this.namingLens, this.options);
        }
        finally {
            timing.end();
        }
    }

    public static abstract class LazyDexString {
        private boolean computed = false;

        public abstract DexString internalCompute();

        public final DexString compute() {
            assert (!this.computed);
            DexString value = this.internalCompute();
            this.computed = true;
            return value;
        }
    }

    private static class SortAnnotations
    extends MixedSectionCollection {
        private final NamingLens namingLens;

        public SortAnnotations(NamingLens namingLens) {
            this.namingLens = namingLens;
        }

        @Override
        public boolean add(DexAnnotationSet dexAnnotationSet) {
            dexAnnotationSet.sort(this.namingLens);
            return true;
        }

        @Override
        public boolean add(DexAnnotation annotation) {
            annotation.annotation.sort();
            return true;
        }

        @Override
        public boolean add(DexEncodedArray dexEncodedArray) {
            for (DexValue value : dexEncodedArray.values) {
                value.sort();
            }
            return true;
        }

        @Override
        public boolean add(DexProgramClass dexClassData) {
            return true;
        }

        @Override
        public boolean add(DexEncodedMethod method, DexWritableCode dexCode) {
            return true;
        }

        @Override
        public boolean add(DexDebugInfoForWriting dexDebugInfo) {
            return true;
        }

        @Override
        public boolean add(DexTypeList dexTypeList) {
            return true;
        }

        @Override
        public boolean add(ParameterAnnotationsList parameterAnnotationsList) {
            return true;
        }

        @Override
        public boolean setAnnotationsDirectoryForClass(DexProgramClass clazz, DexAnnotationDirectory annotationDirectory) {
            return true;
        }
    }
}

