/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.CollectionUtils;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class CodeToKeep {
    static CodeToKeep createCodeToKeep(InternalOptions options, NamingLens namingLens) {
        if (!namingLens.hasPrefixRewritingLogic() && !options.machineDesugaredLibrarySpecification.hasEmulatedInterfaces() || options.isDesugaredLibraryCompilation() || options.testing.enableExperimentalDesugaredLibraryKeepRuleGenerator) {
            return new NopCodeToKeep();
        }
        return new DesugaredLibraryCodeToKeep(namingLens, options);
    }

    public abstract void recordMethod(DexMethod var1);

    public abstract void recordField(DexField var1);

    public abstract void recordClass(DexType var1);

    abstract void recordClassAllAccesses(DexType var1);

    abstract void recordHierarchyOf(DexProgramClass var1);

    abstract boolean isNop();

    abstract void generateKeepRules(InternalOptions var1);

    public static class NopCodeToKeep
    extends CodeToKeep {
        @Override
        public void recordMethod(DexMethod method) {
        }

        @Override
        public void recordField(DexField field) {
        }

        @Override
        public void recordClass(DexType type) {
        }

        @Override
        void recordClassAllAccesses(DexType type) {
        }

        @Override
        void recordHierarchyOf(DexProgramClass clazz) {
        }

        @Override
        boolean isNop() {
            return true;
        }

        @Override
        void generateKeepRules(InternalOptions options) {
            throw new Unreachable("Has no keep rules to generate");
        }
    }

    public static class DesugaredLibraryCodeToKeep
    extends CodeToKeep {
        private final NamingLens namingLens;
        private final Map<DexType, KeepStruct> toKeep = new ConcurrentHashMap<DexType, KeepStruct>();
        private final InternalOptions options;

        public DesugaredLibraryCodeToKeep(NamingLens namingLens, InternalOptions options) {
            this.namingLens = namingLens;
            this.options = options;
        }

        private boolean shouldKeep(DexType type) {
            return this.namingLens.prefixRewrittenType(type) != null || this.options.machineDesugaredLibrarySpecification.isCustomConversionRewrittenType(type) || this.options.machineDesugaredLibrarySpecification.isEmulatedInterfaceRewrittenType(type) || type.toDescriptorString().startsWith("L" + this.options.machineDesugaredLibrarySpecification.getSynthesizedLibraryClassesPackagePrefix());
        }

        private void keepClass(DexType type) {
            DexType baseType = type.lookupBaseType(this.options.itemFactory);
            this.toKeep.putIfAbsent(baseType, new KeepStruct());
        }

        private String convertType(DexType type) {
            DexString rewriteType = this.namingLens.prefixRewrittenType(type);
            DexString descriptor = rewriteType != null ? rewriteType : type.descriptor;
            return DescriptorUtils.descriptorToJavaType(descriptor.toString());
        }

        private static <T extends DexReference> Comparator<T> getComparator() {
            return new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return ((DexReference)o1).compareTo((DexReference)o2);
                }
            };
        }

        @Override
        public void recordMethod(DexMethod method) {
            DexType baseType = method.holder.toBaseType(this.options.dexItemFactory());
            if (this.shouldKeep(baseType)) {
                this.keepClass(baseType);
                if (!method.holder.isArrayType()) {
                    this.toKeep.get((Object)method.holder).methods.add(method);
                }
            }
            if (this.shouldKeep(method.proto.returnType)) {
                this.keepClass(method.proto.returnType);
            }
            for (DexType type : method.proto.parameters.values) {
                if (!this.shouldKeep(type)) continue;
                this.keepClass(type);
            }
        }

        @Override
        public void recordField(DexField field) {
            DexType baseType = field.holder.toBaseType(this.options.dexItemFactory());
            if (this.shouldKeep(baseType)) {
                this.keepClass(baseType);
                if (!field.holder.isArrayType()) {
                    this.toKeep.get((Object)field.holder).fields.add(field);
                }
            }
            if (this.shouldKeep(field.type)) {
                this.keepClass(field.type);
            }
        }

        @Override
        public void recordClass(DexType type) {
            if (this.shouldKeep(type)) {
                this.keepClass(type);
            }
        }

        @Override
        void recordClassAllAccesses(DexType type) {
            if (this.shouldKeep(type)) {
                this.keepClass(type);
                this.toKeep.get((Object)type).all = true;
            }
        }

        @Override
        void recordHierarchyOf(DexProgramClass clazz) {
            this.recordClassAllAccesses(clazz.superType);
            for (DexType itf : clazz.interfaces.values) {
                this.recordClassAllAccesses(itf);
            }
        }

        @Override
        boolean isNop() {
            return false;
        }

        @Override
        void generateKeepRules(InternalOptions options) {
            StringBuilder sb = new StringBuilder();
            String cr = System.lineSeparator();
            Comparator<DexReference> comparator = new Comparator<DexReference>(){

                @Override
                public int compare(DexReference o1, DexReference o2) {
                    return o1.compareTo(o2);
                }
            };
            for (DexType type : CollectionUtils.sort(this.toKeep.keySet(), DesugaredLibraryCodeToKeep.getComparator())) {
                KeepStruct keepStruct = this.toKeep.get(type);
                sb.append("-keep class ").append(this.convertType(type));
                if (keepStruct.all) {
                    sb.append(" { *; }").append(cr);
                    continue;
                }
                if (keepStruct.fields.isEmpty() && keepStruct.methods.isEmpty()) {
                    sb.append(cr);
                    continue;
                }
                sb.append(" {").append(cr);
                for (DexField field : CollectionUtils.sort(keepStruct.fields, DesugaredLibraryCodeToKeep.getComparator())) {
                    sb.append("    ").append(this.convertType(field.type)).append(" ").append(field.name).append(";").append(cr);
                }
                for (DexMethod method : CollectionUtils.sort(keepStruct.methods, DesugaredLibraryCodeToKeep.getComparator())) {
                    sb.append("    ").append(this.convertType(method.proto.returnType)).append(" ").append(method.name).append("(");
                    for (int i = 0; i < method.getArity(); ++i) {
                        if (i != 0) {
                            sb.append(", ");
                        }
                        sb.append(this.convertType(method.proto.parameters.values[i]));
                    }
                    sb.append(");").append(cr);
                }
                sb.append("}").append(cr);
            }
            options.desugaredLibraryKeepRuleConsumer.accept(sb.toString(), options.reporter);
            options.desugaredLibraryKeepRuleConsumer.finished(options.reporter);
        }

        private static class KeepStruct {
            Set<DexField> fields = Sets.newConcurrentHashSet();
            Set<DexMethod> methods = Sets.newConcurrentHashSet();
            boolean all = false;

            private KeepStruct() {
            }
        }
    }
}

