/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.dex.BinaryReader;
import com.android.tools.r8.dex.CompatByteBuffer;
import com.android.tools.r8.dex.Constants;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.DexVersion;
import com.android.tools.r8.utils.StringUtils;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.util.Optional;

public class DexReader
extends BinaryReader {
    private final DexVersion version;

    public DexReader(ProgramResource resource) throws ResourceException, IOException {
        super(resource);
        this.version = this.parseMagic(this.buffer);
    }

    DexReader(Origin origin, byte[] bytes) {
        super(origin, bytes);
        this.version = this.parseMagic(this.buffer);
    }

    private DexVersion parseMagic(CompatByteBuffer buffer) {
        char versionByte2;
        char versionByte1;
        Optional<DexVersion> maybeVersion;
        try {
            buffer.get();
            buffer.rewind();
        }
        catch (BufferUnderflowException e) {
            throw new CompilationError("Dex file is empty", this.origin);
        }
        int index = 0;
        for (byte prefixByte : Constants.DEX_FILE_MAGIC_PREFIX) {
            byte actualByte;
            if ((actualByte = buffer.get(index++)) == prefixByte) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Dex file has invalid header, expected " + prefixByte + " got " + actualByte + ". Next bytes are ");
            for (int i = 0; i < 10; ++i) {
                if (!buffer.hasRemaining()) continue;
                stringBuilder.append(StringUtils.hexString(buffer.get(), 2));
                stringBuilder.append(",");
            }
            throw new CompilationError(stringBuilder.toString(), this.origin);
        }
        char versionByte0 = (char)buffer.get(index++);
        if (!(maybeVersion = DexVersion.getDexVersion(versionByte0, versionByte1 = (char)buffer.get(index++), versionByte2 = (char)buffer.get(index++))).isPresent()) {
            throw new CompilationError("Unsupported DEX file version: " + versionByte0 + versionByte1 + versionByte2, this.origin);
        }
        if (buffer.get(index++) != 0) {
            throw new CompilationError("Dex file has invalid header", this.origin);
        }
        return maybeVersion.get();
    }

    @Override
    void setByteOrder() {
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        int endian = this.buffer.getInt(40);
        if (endian == 2018915346) {
            this.buffer.order(ByteOrder.BIG_ENDIAN);
        } else if (endian != 305419896) {
            throw new CompilationError("Unable to determine endianess for reading dex file.");
        }
    }

    DexVersion getDexVersion() {
        return this.version;
    }
}

