/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.com.google.gson.JsonArray;
import com.android.tools.r8.com.google.gson.JsonElement;
import com.android.tools.r8.com.google.gson.JsonObject;
import com.android.tools.r8.com.google.gson.JsonParser;
import com.android.tools.r8.com.google.gson.JsonSyntaxException;
import com.android.tools.r8.errors.DesugaredLibraryMismatchDiagnostic;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Marker {
    public static final String VERSION = "version";
    public static final String MIN_API = "min-api";
    public static final String DESUGARED_LIBRARY_IDENTIFIERS = "desugared-library-identifiers";
    public static final String SHA1 = "sha-1";
    public static final String COMPILATION_MODE = "compilation-mode";
    public static final String HAS_CHECKSUMS = "has-checksums";
    public static final String BACKEND = "backend";
    public static final String PG_MAP_ID = "pg-map-id";
    public static final String R8_MODE = "r8-mode";
    private static final String NO_LIBRARY_DESUGARING = "<no-library-desugaring>";
    private static final char PREFIX_CHAR = '~';
    private static final String PREFIX = "~~";
    private static final String D8_PREFIX = "~~" + (Object)((Object)Tool.D8) + "{";
    private static final String R8_PREFIX = "~~" + (Object)((Object)Tool.R8) + "{";
    private static final String L8_PREFIX = "~~" + (Object)((Object)Tool.L8) + "{";
    private final JsonObject jsonObject;
    private final Tool tool;

    public Marker(Tool tool) {
        this(tool, new JsonObject());
    }

    private Marker(Tool tool, JsonObject jsonObject) {
        this.tool = tool;
        this.jsonObject = jsonObject;
    }

    public static void checkCompatibleDesugaredLibrary(Set<Marker> markers, Reporter reporter) {
        if (markers.size() <= 1) {
            return;
        }
        HashSet<String> desugaredLibraryIdentifiers = new HashSet<String>();
        for (Marker marker : markers) {
            if (marker.tool == Tool.L8) {
                assert (marker.getDesugaredLibraryIdentifiers().length > 0);
                assert (markers.stream().allMatch(m3 -> m3.tool == Tool.L8 || m3.getDesugaredLibraryIdentifiers().length == 0));
                continue;
            }
            String[] identifiers = marker.getDesugaredLibraryIdentifiers();
            String identifier = null;
            switch (identifiers.length) {
                case 0: {
                    if (marker.isDexBackend()) {
                        identifier = NO_LIBRARY_DESUGARING;
                        break;
                    }
                    assert (marker.isCfBackend());
                    break;
                }
                case 1: {
                    identifier = identifiers[0];
                    break;
                }
                default: {
                    throw reporter.fatalError(new StringDiagnostic("Merging program compiled with multiple desugared libraries."));
                }
            }
            if (marker.isDesugared() && identifier != null) {
                desugaredLibraryIdentifiers.add(identifier);
                continue;
            }
            assert (identifier == null || identifier.equals(NO_LIBRARY_DESUGARING));
        }
        if (desugaredLibraryIdentifiers.size() > 1) {
            reporter.error(new DesugaredLibraryMismatchDiagnostic(desugaredLibraryIdentifiers, markers));
        }
    }

    public static Marker parse(DexString dexString) {
        if (dexString.size > 2 && dexString.content[0] == 126 && dexString.content[1] == 126) {
            String str = dexString.toString();
            if (str.startsWith(D8_PREFIX)) {
                return Marker.internalParse(Tool.D8, str.substring(D8_PREFIX.length() - 1));
            }
            if (str.startsWith(R8_PREFIX)) {
                return Marker.internalParse(Tool.R8, str.substring(R8_PREFIX.length() - 1));
            }
            if (str.startsWith(L8_PREFIX)) {
                return Marker.internalParse(Tool.L8, str.substring(L8_PREFIX.length() - 1));
            }
        }
        return null;
    }

    private static Marker internalParse(Tool tool, String str) {
        try {
            JsonElement result = new JsonParser().parse(str);
            if (result.isJsonObject()) {
                return new Marker(tool, result.getAsJsonObject());
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        return null;
    }

    public Tool getTool() {
        return this.tool;
    }

    public boolean isD8() {
        return this.tool == Tool.D8;
    }

    public boolean isR8() {
        return this.tool == Tool.R8;
    }

    public boolean isL8() {
        return this.tool == Tool.L8;
    }

    public boolean isRelocator() {
        return this.tool == Tool.Relocator;
    }

    public String getVersion() {
        return this.jsonObject.get(VERSION).getAsString();
    }

    public Marker setVersion(String version) {
        assert (!this.jsonObject.has(VERSION));
        this.jsonObject.addProperty(VERSION, version);
        return this;
    }

    public boolean isDesugared() {
        return this.hasMinApi();
    }

    public boolean hasMinApi() {
        return this.jsonObject.has(MIN_API);
    }

    public Long getMinApi() {
        return this.jsonObject.get(MIN_API).getAsLong();
    }

    public Marker setMinApi(long minApi) {
        assert (!this.jsonObject.has(MIN_API));
        this.jsonObject.addProperty(MIN_API, minApi);
        return this;
    }

    public boolean hasDesugaredLibraryIdentifiers() {
        return this.jsonObject.has(DESUGARED_LIBRARY_IDENTIFIERS);
    }

    public String[] getDesugaredLibraryIdentifiers() {
        if (this.jsonObject.has(DESUGARED_LIBRARY_IDENTIFIERS)) {
            JsonArray array = this.jsonObject.get(DESUGARED_LIBRARY_IDENTIFIERS).getAsJsonArray();
            String[] identifiers = new String[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                identifiers[i] = array.get(i).getAsString();
            }
            return identifiers;
        }
        return new String[0];
    }

    public Marker setDesugaredLibraryIdentifiers(String ... identifiers) {
        assert (!this.jsonObject.has(DESUGARED_LIBRARY_IDENTIFIERS));
        JsonArray jsonIdentifiers = new JsonArray();
        for (String identifier : identifiers) {
            jsonIdentifiers.add(identifier);
        }
        this.jsonObject.add(DESUGARED_LIBRARY_IDENTIFIERS, jsonIdentifiers);
        return this;
    }

    public String getSha1() {
        return this.jsonObject.get(SHA1).getAsString();
    }

    public Marker setSha1(String sha1) {
        assert (!this.jsonObject.has(SHA1));
        this.jsonObject.addProperty(SHA1, sha1);
        return this;
    }

    public String getCompilationMode() {
        return this.jsonObject.get(COMPILATION_MODE).getAsString();
    }

    public Marker setCompilationMode(CompilationMode mode) {
        assert (!this.jsonObject.has(COMPILATION_MODE));
        this.jsonObject.addProperty(COMPILATION_MODE, mode.toString().toLowerCase());
        return this;
    }

    public boolean hasBackend() {
        return this.jsonObject.has(BACKEND);
    }

    public String getBackend() {
        if (!this.hasBackend()) {
            return this.hasMinApi() ? Backend.DEX.name().toLowerCase() : Backend.CF.name().toLowerCase();
        }
        return this.jsonObject.get(BACKEND).getAsString();
    }

    public boolean isCfBackend() {
        return this.getBackend().equals(Backend.CF.name().toLowerCase());
    }

    public boolean isDexBackend() {
        return this.getBackend().equals(Backend.DEX.name().toLowerCase());
    }

    public Marker setBackend(Backend backend) {
        assert (!this.hasBackend());
        this.jsonObject.addProperty(BACKEND, backend.name().toLowerCase());
        return this;
    }

    public boolean getHasChecksums() {
        return this.jsonObject.get(HAS_CHECKSUMS).getAsBoolean();
    }

    public Marker setHasChecksums(boolean hasChecksums) {
        assert (!this.jsonObject.has(HAS_CHECKSUMS));
        this.jsonObject.addProperty(HAS_CHECKSUMS, hasChecksums);
        return this;
    }

    public String getPgMapId() {
        return this.jsonObject.get(PG_MAP_ID).getAsString();
    }

    public Marker setPgMapId(String pgMapId) {
        assert (!this.jsonObject.has(PG_MAP_ID));
        this.jsonObject.addProperty(PG_MAP_ID, pgMapId);
        return this;
    }

    public String getR8Mode() {
        return this.jsonObject.get(R8_MODE).getAsString();
    }

    public Marker setR8Mode(String r8Mode) {
        assert (!this.jsonObject.has(R8_MODE));
        this.jsonObject.addProperty(R8_MODE, r8Mode);
        return this;
    }

    public String toString() {
        JsonObject sortedJson = new JsonObject();
        this.jsonObject.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(entry -> sortedJson.add((String)entry.getKey(), (JsonElement)entry.getValue()));
        return PREFIX + (Object)((Object)this.tool) + sortedJson;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Marker) {
            Marker other = (Marker)obj;
            return this.tool == other.tool && this.jsonObject.equals(other.jsonObject);
        }
        return false;
    }

    public int hashCode() {
        return this.tool.hashCode() + 3 * this.jsonObject.hashCode();
    }

    public DexString toDexString(DexItemFactory factory) {
        return factory.createString(this.toString());
    }

    public static enum Backend {
        CF,
        DEX;

    }

    public static enum Tool {
        D8,
        R8,
        L8,
        Relocator;


        public static Tool[] valuesR8andD8() {
            return new Tool[]{D8, R8};
        }
    }
}

