/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.DataDirectoryResource;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntStack;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardPathFilter;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.function.Function;

public class ResourceAdapter {
    private final AppView<?> appView;
    private final DexItemFactory dexItemFactory;
    private final GraphLens graphLens;
    private final NamingLens namingLens;
    private final InternalOptions options;

    public ResourceAdapter(AppView<?> appView, DexItemFactory dexItemFactory, NamingLens namingLens, InternalOptions options) {
        this.appView = appView;
        this.dexItemFactory = dexItemFactory;
        this.graphLens = appView.graphLens();
        this.namingLens = namingLens;
        this.options = options;
    }

    private boolean shouldAdapt(DataEntryResource file, InternalOptions options, Function<ProguardConfiguration, ProguardPathFilter> getFilter) {
        ProguardConfiguration proguardConfiguration = options.getProguardConfiguration();
        if (proguardConfiguration == null) {
            assert (options.testing.enableD8ResourcesPassThrough);
            return false;
        }
        ProguardPathFilter filter = getFilter.apply(proguardConfiguration);
        return filter.isEnabled() && !file.getName().toLowerCase().endsWith(".class") && filter.matches(file.getName());
    }

    private String adaptFileName(DataEntryResource file) {
        FileNameAdapter adapter;
        FileNameAdapter fileNameAdapter = adapter = file.getName().startsWith("META-INF/services/") ? new ServiceFileNameAdapter(file.getName()) : new DefaultFileNameAdapter(file.getName());
        if (adapter.run()) {
            return adapter.getResult();
        }
        return file.getName();
    }

    private String adaptDirectoryName(DataDirectoryResource file) {
        DirectoryNameAdapter adapter = new DirectoryNameAdapter(file.getName());
        if (adapter.run()) {
            return adapter.getResult();
        }
        return file.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] adaptFileContents(DataEntryResource file) {
        try {
            Throwable throwable;
            InputStream in;
            block15: {
                byte[] byArray;
                block16: {
                    in = file.getByteStream();
                    throwable = null;
                    try {
                        byte[] bytes = ByteStreams.toByteArray(in);
                        String contents = new String(bytes, Charset.defaultCharset());
                        FileContentsAdapter adapter = new FileContentsAdapter(contents);
                        if (!adapter.run()) break block15;
                        byArray = adapter.getResult().getBytes(Charset.defaultCharset());
                        if (in == null) return byArray;
                        if (throwable == null) break block16;
                    }
                    catch (Throwable throwable4) {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (in == null) throw throwable5;
                            if (throwable == null) {
                                in.close();
                                throw throwable5;
                            }
                            try {
                                in.close();
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                                throw throwable5;
                            }
                        }
                    }
                    try {
                        in.close();
                        return byArray;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return byArray;
                    }
                }
                in.close();
                return byArray;
            }
            if (in == null) return null;
            if (throwable == null) {
                in.close();
                return null;
            }
            try {
                in.close();
                return null;
            }
            catch (Throwable throwable3) {
                throwable.addSuppressed(throwable3);
                return null;
            }
        }
        catch (ResourceException e) {
            this.options.reporter.error(new StringDiagnostic("Failed to open input: " + e.getMessage(), file.getOrigin()));
            return null;
        }
        catch (Exception e) {
            this.options.reporter.error(new ExceptionDiagnostic(e, file.getOrigin()));
        }
        return null;
    }

    public DataEntryResource adaptIfNeeded(DataEntryResource file) {
        byte[] contents;
        String name;
        String string = name = this.shouldAdapt(file, this.options, ProguardConfiguration::getAdaptResourceFilenames) ? this.adaptFileName(file) : file.getName();
        assert (name != null);
        byte[] byArray = contents = this.shouldAdapt(file, this.options, ProguardConfiguration::getAdaptResourceFileContents) ? this.adaptFileContents(file) : null;
        if (contents != null) {
            return DataEntryResource.fromBytes(contents, name, file.getOrigin());
        }
        if (!name.equals(file.getName())) {
            return file.withName(name);
        }
        return file;
    }

    public DataDirectoryResource adaptIfNeeded(DataDirectoryResource directory) {
        if (this.options.getProguardConfiguration() == null) {
            assert (this.options.testing.enableD8ResourcesPassThrough);
            return null;
        }
        if (!this.options.getProguardConfiguration().getKeepDirectories().matches(directory.getName())) {
            return null;
        }
        return DataDirectoryResource.fromName(this.adaptDirectoryName(directory), directory.getOrigin());
    }

    public boolean isService(DataEntryResource file) {
        return file.getName().startsWith("META-INF/services/");
    }

    private class DirectoryNameAdapter
    extends FileNameAdapter {
        public DirectoryNameAdapter(String filename) {
            super(filename);
        }

        @Override
        public boolean isRenamingCandidate(int from, int toExclusive) {
            return from == 0;
        }
    }

    private class ServiceFileNameAdapter
    extends FileNameAdapter {
        public ServiceFileNameAdapter(String filename) {
            super(filename);
        }

        @Override
        public char getClassNameSeparator() {
            return '.';
        }

        @Override
        public boolean allowRenamingOfPrefixes() {
            return false;
        }

        @Override
        public boolean isRenamingCandidate(int from, int toExclusive) {
            return from == "META-INF/services/".length() && this.eof(toExclusive);
        }
    }

    private class DefaultFileNameAdapter
    extends FileNameAdapter {
        public DefaultFileNameAdapter(String filename) {
            super(filename);
        }

        @Override
        public boolean isRenamingCandidate(int from, int toExclusive) {
            return from == 0 && !this.eof(toExclusive);
        }
    }

    private abstract class FileNameAdapter
    extends StringAdapter {
        public FileNameAdapter(String filename) {
            super(filename);
        }

        @Override
        public char getClassNameSeparator() {
            return '/';
        }

        @Override
        public boolean allowRenamingOfPrefixes() {
            return true;
        }

        @Override
        public boolean shouldRecordPrefix(char c) {
            return !Character.isLetterOrDigit(c);
        }

        @Override
        protected boolean handlePrefix(int from, int toExclusive) {
            if (this.eof(toExclusive) || this.contents.charAt(toExclusive) == '/') {
                return this.renameJavaPackageInRange(from, toExclusive);
            }
            return this.renameJavaTypeInRange(from, toExclusive);
        }
    }

    private class FileContentsAdapter
    extends StringAdapter {
        public FileContentsAdapter(String fileContents) {
            super(fileContents);
        }

        private boolean isDashOrDot(char c) {
            return c == '.' || c == '-';
        }

        @Override
        public char getClassNameSeparator() {
            return '.';
        }

        @Override
        public boolean allowRenamingOfPrefixes() {
            return false;
        }

        @Override
        public boolean shouldRecordPrefix(char c) {
            throw new Unreachable();
        }

        @Override
        protected boolean handlePrefix(int from, int toExclusive) {
            throw new Unreachable();
        }

        @Override
        public boolean isRenamingCandidate(int from, int toExclusive) {
            return !(from > 0 && this.isDashOrDot(this.contents.charAt(from - 1)) || !this.eof(toExclusive) && this.isDashOrDot(this.contents.charAt(toExclusive)));
        }
    }

    private abstract class StringAdapter {
        protected final String contents;
        private final StringBuilder result = new StringBuilder();
        private boolean changed = false;
        private int outputFrom = 0;
        private int position = 0;
        private final IntStack prefixEndPositionsExclusive;

        public StringAdapter(String contents) {
            this.contents = contents;
            this.prefixEndPositionsExclusive = this.allowRenamingOfPrefixes() ? new IntArrayList() : null;
        }

        private void handleMisc() {
            while (!this.eof() && !Character.isJavaIdentifierPart(this.contents.charAt(this.position))) {
                ++this.position;
            }
        }

        private void handleJavaType() {
            boolean renamingSucceeded;
            if (this.eof()) {
                return;
            }
            assert (!this.allowRenamingOfPrefixes() || this.prefixEndPositionsExclusive.isEmpty());
            assert (Character.isJavaIdentifierPart(this.contents.charAt(this.position)));
            int start = this.position++;
            while (!this.eof()) {
                char currentChar = this.contents.charAt(this.position);
                if (Character.isJavaIdentifierPart(currentChar)) {
                    if (this.allowRenamingOfPrefixes() && this.shouldRecordPrefix(currentChar) && this.isRenamingCandidate(start, this.position)) {
                        this.prefixEndPositionsExclusive.push(this.position);
                    }
                    ++this.position;
                    continue;
                }
                if (currentChar != this.getClassNameSeparator() || this.eof(this.position + 1) || !Character.isJavaIdentifierPart(this.contents.charAt(this.position + 1))) break;
                if (this.allowRenamingOfPrefixes() && this.shouldRecordPrefix(currentChar) && this.isRenamingCandidate(start, this.position)) {
                    this.prefixEndPositionsExclusive.push(this.position);
                }
                this.position += 2;
            }
            if (this.allowRenamingOfPrefixes() && this.eof() && this.isRenamingCandidate(start, this.position)) {
                this.prefixEndPositionsExclusive.push(this.position);
            }
            boolean bl = renamingSucceeded = this.isRenamingCandidate(start, this.position) && this.renameJavaTypeInRange(start, this.position);
            if (!renamingSucceeded && this.allowRenamingOfPrefixes()) {
                while (!this.prefixEndPositionsExclusive.isEmpty() && !renamingSucceeded) {
                    int prefixEndExclusive = this.prefixEndPositionsExclusive.popInt();
                    assert (this.isRenamingCandidate(start, prefixEndExclusive));
                    renamingSucceeded = this.handlePrefix(start, prefixEndExclusive);
                }
            }
            if (this.allowRenamingOfPrefixes()) {
                while (!this.prefixEndPositionsExclusive.isEmpty()) {
                    this.prefixEndPositionsExclusive.popInt();
                }
            }
        }

        private void outputRangeFromInput(int from, int toExclusive) {
            if (from < toExclusive) {
                this.result.append(this.contents, from, toExclusive);
            }
        }

        private void outputJavaType(String s2) {
            this.result.append(s2);
        }

        public boolean run() {
            do {
                this.handleMisc();
                this.handleJavaType();
            } while (!this.eof());
            if (this.changed) {
                this.outputRangeFromInput(this.outputFrom, this.contents.length());
            } else {
                assert (this.outputFrom == 0);
                assert (this.result.toString().isEmpty());
            }
            return this.changed;
        }

        public String getResult() {
            assert (this.changed);
            return this.result.toString();
        }

        protected boolean renameJavaTypeInRange(int from, int toExclusive) {
            DexString renamedDescriptor;
            DexString descriptor;
            DexType dexType;
            String javaType = this.contents.substring(from, toExclusive);
            if (this.getClassNameSeparator() != '.') {
                javaType = javaType.replace(this.getClassNameSeparator(), '.');
            }
            DexType dexType2 = dexType = (descriptor = ResourceAdapter.this.dexItemFactory.lookupString(DescriptorUtils.javaTypeToDescriptorIgnorePrimitives(javaType))) != null ? ResourceAdapter.this.dexItemFactory.lookupType(descriptor) : null;
            if (dexType != null && !descriptor.equals(renamedDescriptor = ResourceAdapter.this.namingLens.lookupDescriptor(ResourceAdapter.this.graphLens.lookupType(dexType)))) {
                String renamedJavaType = DescriptorUtils.descriptorToJavaType(renamedDescriptor.toSourceString());
                this.outputRangeFromInput(this.outputFrom, from);
                this.outputJavaType(this.getClassNameSeparator() != '.' ? renamedJavaType.replace('.', this.getClassNameSeparator()) : renamedJavaType);
                this.outputFrom = toExclusive;
                this.changed = true;
                return true;
            }
            return false;
        }

        protected boolean renameJavaPackageInRange(int from, int toExclusive) {
            String javaPackage = this.contents.substring(from, toExclusive);
            if (this.getClassNameSeparator() != '/') {
                javaPackage = javaPackage.replace(this.getClassNameSeparator(), '/');
            }
            String packageName = ResourceAdapter.this.appView.graphLens().lookupPackageName(javaPackage);
            String minifiedJavaPackage = ResourceAdapter.this.namingLens.lookupPackageName(packageName);
            if (!javaPackage.equals(minifiedJavaPackage)) {
                this.outputRangeFromInput(this.outputFrom, from);
                this.outputJavaType(this.getClassNameSeparator() != '/' ? minifiedJavaPackage.replace('/', this.getClassNameSeparator()) : minifiedJavaPackage);
                this.outputFrom = toExclusive;
                this.changed = true;
                return true;
            }
            return false;
        }

        protected abstract char getClassNameSeparator();

        protected abstract boolean allowRenamingOfPrefixes();

        protected abstract boolean shouldRecordPrefix(char var1);

        protected abstract boolean handlePrefix(int var1, int var2);

        protected abstract boolean isRenamingCandidate(int var1, int var2);

        protected boolean eof() {
            return this.eof(this.position);
        }

        protected boolean eof(int position) {
            return position == this.contents.length();
        }
    }
}

