/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.FeatureSplit;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Iterators;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.debuginfo.DebugRepresentation;
import com.android.tools.r8.dex.ApplicationWriter;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.InheritanceClassInDexDistributor;
import com.android.tools.r8.errors.DexFileOverflowDiagnostic;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.features.ClassToFeatureSplitMap;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.MainDexInfo;
import com.android.tools.r8.synthesis.SyntheticNaming;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class VirtualFile {
    public static final int MAX_ENTRIES = 65536;
    private static final int MAX_PREFILL_ENTRIES = 60536;
    private final int id;
    private final VirtualFileIndexedItemCollection indexedItems;
    private final IndexedItemTransaction transaction;
    private final FeatureSplit featureSplit;
    private final DexProgramClass primaryClass;
    private DebugRepresentation debugRepresentation;
    private ObjectToOffsetMapping objectMapping = null;

    VirtualFile(int id, AppView<?> appView, NamingLens namingLens) {
        this(id, appView, namingLens, null, null);
    }

    VirtualFile(int id, AppView<?> appView, NamingLens namingLens, FeatureSplit featureSplit) {
        this(id, appView, namingLens, null, featureSplit);
    }

    private VirtualFile(int id, AppView<?> appView, NamingLens namingLens, DexProgramClass primaryClass) {
        this(id, appView, namingLens, primaryClass, null);
    }

    private VirtualFile(int id, AppView<?> appView, NamingLens namingLens, DexProgramClass primaryClass, FeatureSplit featureSplit) {
        this.id = id;
        this.indexedItems = new VirtualFileIndexedItemCollection(appView, namingLens);
        this.transaction = new IndexedItemTransaction(this.indexedItems, appView, namingLens);
        this.primaryClass = primaryClass;
        this.featureSplit = featureSplit;
    }

    public static String deriveCommonPrefixAndSanityCheck(List<String> fileNames) {
        Iterator<String> nameIterator = fileNames.iterator();
        String first = nameIterator.next();
        if (!first.toLowerCase().endsWith(".dex")) {
            throw new RuntimeException("Illegal suffix for dex file: `" + first + "`.");
        }
        String prefix = first.substring(0, first.length() - ".dex".length());
        int index = 2;
        while (nameIterator.hasNext()) {
            String next = nameIterator.next();
            if (!next.toLowerCase().endsWith(".dex")) {
                throw new RuntimeException("Illegal suffix for dex file: `" + first + "`.");
            }
            if (!next.startsWith(prefix)) {
                throw new RuntimeException("Input filenames lack common prefix.");
            }
            String numberPart = next.substring(prefix.length(), next.length() - ".dex".length());
            if (Integer.parseInt(numberPart) == index++) continue;
            throw new RuntimeException("DEX files are not numbered consecutively.");
        }
        return prefix;
    }

    private static Map<DexProgramClass, String> computeOriginalNameMapping(Collection<DexProgramClass> classes, GraphLens graphLens, ClassNameMapper proguardMap) {
        IdentityHashMap<DexProgramClass, String> originalNames = new IdentityHashMap<DexProgramClass, String>(classes.size());
        classes.forEach(clazz -> {
            DexType originalType = graphLens.getOriginalType(clazz.getType());
            originalNames.put((DexProgramClass)clazz, DescriptorUtils.descriptorToJavaType(originalType.toDescriptorString(), proguardMap));
        });
        return originalNames;
    }

    private static String extractPrefixToken(int prefixLength, String className, boolean addStar) {
        int index = 0;
        int lastIndex = 0;
        int segmentCount = 0;
        while (lastIndex != -1 && segmentCount++ < prefixLength) {
            index = lastIndex;
            lastIndex = className.indexOf(46, index + 1);
        }
        String prefix = className.substring(0, index);
        if (addStar && segmentCount >= prefixLength) {
            prefix = prefix + ".*";
        }
        return prefix;
    }

    private boolean isFilledEnough() {
        return this.isFull(65536);
    }

    public int getId() {
        return this.id;
    }

    public Set<String> getClassDescriptors() {
        HashSet<String> classDescriptors = new HashSet<String>();
        for (DexProgramClass clazz : this.indexedItems.classes) {
            boolean added = classDescriptors.add(clazz.type.descriptor.toString());
            assert (added);
        }
        return classDescriptors;
    }

    public FeatureSplit getFeatureSplit() {
        return this.featureSplit;
    }

    public String getPrimaryClassDescriptor() {
        return this.primaryClass == null ? null : this.primaryClass.type.descriptor.toString();
    }

    public void setDebugRepresentation(DebugRepresentation debugRepresentation) {
        assert (debugRepresentation != null);
        assert (this.debugRepresentation == null);
        this.debugRepresentation = debugRepresentation;
    }

    public DebugRepresentation getDebugRepresentation() {
        assert (this.debugRepresentation != null);
        return this.debugRepresentation;
    }

    public void injectString(DexString string) {
        this.transaction.addString(string);
        this.commitTransaction();
    }

    public ObjectToOffsetMapping getObjectMapping() {
        assert (this.objectMapping != null);
        return this.objectMapping;
    }

    public void computeMapping(AppView<?> appView, NamingLens namingLens, int lazyDexStringsCount, Timing timing) {
        assert (this.transaction.isEmpty());
        assert (this.objectMapping == null);
        this.objectMapping = new ObjectToOffsetMapping(appView, namingLens, this.transaction.rewriter, this.indexedItems.classes, this.indexedItems.protos, this.indexedItems.types, this.indexedItems.methods, this.indexedItems.fields, this.indexedItems.strings, this.indexedItems.callSites, this.indexedItems.methodHandles, lazyDexStringsCount, timing);
    }

    void addClass(DexProgramClass clazz) {
        this.transaction.addClassAndDependencies(clazz);
    }

    public boolean isFull(int maxEntries) {
        return this.transaction.getNumberOfMethods() > maxEntries || this.transaction.getNumberOfFields() > maxEntries;
    }

    boolean isFull() {
        return this.isFull(65536);
    }

    public int getNumberOfMethods() {
        return this.transaction.getNumberOfMethods();
    }

    public int getNumberOfFields() {
        return this.transaction.getNumberOfFields();
    }

    public int getNumberOfClasses() {
        return this.transaction.getNumberOfClasses();
    }

    void throwIfFull(boolean hasMainDexList, Reporter reporter) {
        if (!this.isFull()) {
            return;
        }
        throw reporter.fatalError(new DexFileOverflowDiagnostic(hasMainDexList, this.transaction.getNumberOfMethods(), this.transaction.getNumberOfFields()));
    }

    public void abortTransaction() {
        this.transaction.abort();
    }

    public void commitTransaction() {
        this.transaction.commit();
    }

    public boolean containsString(DexString string) {
        return this.indexedItems.strings.contains(string);
    }

    public boolean containsType(DexType type) {
        return this.indexedItems.types.contains(type);
    }

    public boolean isEmpty() {
        return this.indexedItems.classes.isEmpty();
    }

    public Collection<DexProgramClass> classes() {
        return this.indexedItems.classes;
    }

    private static class PackageSplitPopulator
    implements Callable<Map<String, Integer>> {
        private static final int MINIMUM_PREFIX_LENGTH = 4;
        private static final int MAXIMUM_PREFIX_LENGTH = 7;
        private static final int MIN_FILL_FACTOR = 5;
        private final List<DexProgramClass> classes;
        private final Map<DexProgramClass, String> originalNames;
        private final DexItemFactory dexItemFactory;
        private final InternalOptions options;
        private final VirtualFileCycler cycler;

        PackageSplitPopulator(List<VirtualFile> files, AppView<?> appView, Set<DexProgramClass> classes, Map<DexProgramClass, String> originalNames, int fileIndexOffset, NamingLens namingLens, InternalOptions options) {
            this.classes = new ArrayList<DexProgramClass>(classes);
            this.originalNames = originalNames;
            this.dexItemFactory = appView.dexItemFactory();
            this.options = options;
            this.cycler = new VirtualFileCycler(files, appView, namingLens, fileIndexOffset);
        }

        static boolean coveredByPrefix(String originalName, String currentPrefix) {
            if (currentPrefix == null) {
                return false;
            }
            if (currentPrefix.endsWith(".*")) {
                return originalName.startsWith(currentPrefix.substring(0, currentPrefix.length() - 2));
            }
            return originalName.startsWith(currentPrefix) && originalName.lastIndexOf(46) == currentPrefix.length();
        }

        private String getOriginalName(DexProgramClass clazz) {
            return this.originalNames != null ? this.originalNames.get(clazz) : clazz.toString();
        }

        private boolean isFullEnough(VirtualFile current, InternalOptions options) {
            if (options.testing.limitNumberOfClassesPerDex > 0 && current.getNumberOfClasses() > options.testing.limitNumberOfClassesPerDex) {
                return true;
            }
            return current.isFull();
        }

        private void addNonPackageClasses(VirtualFileCycler cycler, List<DexProgramClass> nonPackageClasses) {
            cycler.restart();
            VirtualFile current = cycler.next();
            for (DexProgramClass clazz : nonPackageClasses) {
                if (current.isFull()) {
                    current = this.getVirtualFile(cycler);
                }
                current.addClass(clazz);
                while (current.isFull()) {
                    current.abortTransaction();
                    current = this.getVirtualFile(cycler);
                    boolean wasEmpty = current.isEmpty();
                    current.addClass(clazz);
                    if (!wasEmpty || !current.isFull()) continue;
                    throw new InternalCompilerError("Class " + clazz.toString() + " does not fit into a single dex file.");
                }
                current.commitTransaction();
            }
        }

        private VirtualFile getVirtualFile(VirtualFileCycler cycler) {
            VirtualFile current = null;
            while (cycler.hasNext() && this.isFullEnough(current = cycler.next(), this.options)) {
            }
            if (current == null || this.isFullEnough(current, this.options)) {
                current = cycler.addFile();
            }
            return current;
        }

        @Override
        public Map<String, Integer> call() throws IOException {
            int prefixLength = 4;
            int transactionStartIndex = 0;
            int fileStartIndex = 0;
            String currentPrefix = null;
            LinkedHashMap<String, Integer> newPackageAssignments = new LinkedHashMap<String, Integer>();
            VirtualFile current = this.cycler.next();
            ArrayList<DexProgramClass> nonPackageClasses = new ArrayList<DexProgramClass>();
            for (int classIndex = 0; classIndex < this.classes.size(); ++classIndex) {
                DexProgramClass clazz = this.classes.get(classIndex);
                String originalName = this.getOriginalName(clazz);
                if (!PackageSplitPopulator.coveredByPrefix(originalName, currentPrefix)) {
                    String newPrefix;
                    if (currentPrefix != null) {
                        current.commitTransaction();
                        this.cycler.restart();
                        assert (!newPackageAssignments.containsKey(currentPrefix));
                        newPackageAssignments.put(currentPrefix, current.id);
                        prefixLength = 3;
                    }
                    do {
                        newPrefix = VirtualFile.extractPrefixToken(++prefixLength, originalName, false);
                    } while (currentPrefix != null && currentPrefix.startsWith(newPrefix));
                    if (!newPrefix.equals("")) {
                        currentPrefix = VirtualFile.extractPrefixToken(prefixLength, originalName, true);
                    }
                    transactionStartIndex = classIndex;
                }
                if (currentPrefix != null) {
                    assert (clazz.superType != null || clazz.type == this.dexItemFactory.objectType);
                } else {
                    assert (clazz.superType != null);
                    assert (current.transaction.classes.isEmpty());
                    nonPackageClasses.add(clazz);
                    continue;
                }
                current.addClass(clazz);
                if (!this.isFullEnough(current, this.options)) continue;
                current.abortTransaction();
                if (classIndex - transactionStartIndex > (classIndex - fileStartIndex) / 5 && prefixLength < 7) {
                    ++prefixLength;
                } else {
                    fileStartIndex = transactionStartIndex;
                    if (!this.cycler.hasNext()) {
                        if (current.transaction.getNumberOfClasses() == 0) {
                            for (int j = transactionStartIndex; j <= classIndex; ++j) {
                                nonPackageClasses.add(this.classes.get(j));
                            }
                            transactionStartIndex = classIndex + 1;
                        }
                        this.cycler.addFile();
                    }
                    current = this.cycler.next();
                }
                currentPrefix = null;
                classIndex = transactionStartIndex - 1;
                assert (current != null);
            }
            current.commitTransaction();
            assert (!newPackageAssignments.containsKey(currentPrefix));
            if (currentPrefix != null) {
                newPackageAssignments.put(currentPrefix, current.id);
            }
            if (nonPackageClasses.size() > 0) {
                this.addNonPackageClasses(this.cycler, nonPackageClasses);
            }
            return newPackageAssignments;
        }
    }

    static class VirtualFileCycler {
        private final List<VirtualFile> files;
        private final AppView<?> appView;
        private final NamingLens namingLens;
        private int nextFileId;
        private Iterator<VirtualFile> allFilesCyclic;
        private Iterator<VirtualFile> activeFiles;
        private FeatureSplit featuresplit;

        VirtualFileCycler(List<VirtualFile> files, AppView<?> appView, NamingLens namingLens, int fileIndexOffset) {
            this.files = files;
            this.appView = appView;
            this.namingLens = namingLens;
            this.nextFileId = files.size() + fileIndexOffset;
            if (files.size() > 0) {
                this.featuresplit = files.get(0).getFeatureSplit();
            }
            this.reset();
        }

        void reset() {
            this.allFilesCyclic = Iterators.cycle(this.files);
            this.restart();
        }

        boolean hasNext() {
            return this.activeFiles.hasNext();
        }

        VirtualFile next() {
            return this.activeFiles.next();
        }

        VirtualFile nextOrCreate() {
            if (this.hasNext()) {
                return this.activeFiles.next();
            }
            VirtualFile newFile = new VirtualFile(this.nextFileId++, this.appView, this.namingLens, this.featuresplit);
            this.files.add(newFile);
            this.allFilesCyclic = Iterators.cycle(this.files);
            return newFile;
        }

        VirtualFile nextOrCreate(Predicate<? super VirtualFile> filter) {
            VirtualFile dex;
            do {
                if (!(dex = this.nextOrCreate()).isEmpty()) continue;
                assert (filter.test(dex));
                return dex;
            } while (!filter.test(dex));
            return dex;
        }

        void restart() {
            this.activeFiles = Iterators.limit(this.allFilesCyclic, this.files.size());
        }

        VirtualFile addFile() {
            VirtualFile newFile = new VirtualFile(this.nextFileId++, this.appView, this.namingLens, this.featuresplit);
            this.files.add(newFile);
            this.reset();
            return newFile;
        }
    }

    public static class IndexedItemTransaction
    implements IndexedItemCollection {
        private final AppView<?> appView;
        private final VirtualFileIndexedItemCollection base;
        private final InitClassLens initClassLens;
        private final NamingLens namingLens;
        private final LensCodeRewriterUtils rewriter;
        private final Set<DexProgramClass> classes = new LinkedHashSet<DexProgramClass>();
        private final Set<DexField> fields = new LinkedHashSet<DexField>();
        private final Set<DexMethod> methods = new LinkedHashSet<DexMethod>();
        private final Set<DexType> types = new LinkedHashSet<DexType>();
        private final Set<DexProto> protos = new LinkedHashSet<DexProto>();
        private final Set<DexString> strings = new LinkedHashSet<DexString>();
        private final Set<DexCallSite> callSites = new LinkedHashSet<DexCallSite>();
        private final Set<DexMethodHandle> methodHandles = new LinkedHashSet<DexMethodHandle>();

        private IndexedItemTransaction(VirtualFileIndexedItemCollection base, AppView<?> appView, NamingLens namingLens) {
            this.appView = appView;
            this.base = base;
            this.initClassLens = appView.initClassLens();
            this.namingLens = namingLens;
            this.rewriter = new LensCodeRewriterUtils(appView, true);
        }

        private <T extends DexItem> boolean maybeInsert(T item, Set<T> set, Set<T> baseSet) {
            if (baseSet.contains(item) || set.contains(item)) {
                return false;
            }
            set.add(item);
            return true;
        }

        private <T extends DexItem> void commitItemsIn(Set<T> set, Function<T, Boolean> hook) {
            set.forEach(item -> {
                boolean newlyAdded = (Boolean)hook.apply(item);
                assert (newlyAdded);
            });
            set.clear();
        }

        void addClassAndDependencies(DexProgramClass clazz) {
            clazz.collectIndexedItems(this, this.getGraphLens(), this.rewriter);
        }

        @Override
        public boolean addClass(DexProgramClass dexProgramClass) {
            return this.maybeInsert(dexProgramClass, this.classes, this.base.classes);
        }

        @Override
        public boolean addField(DexField field) {
            return this.maybeInsert(field, this.fields, this.base.fields);
        }

        @Override
        public boolean addMethod(DexMethod method) {
            return this.maybeInsert(method, this.methods, this.base.methods);
        }

        @Override
        public boolean addString(DexString string) {
            return this.maybeInsert(string, this.strings, this.base.strings);
        }

        @Override
        public boolean addProto(DexProto proto) {
            return this.maybeInsert(proto, this.protos, this.base.protos);
        }

        @Override
        public boolean addType(DexType type) {
            assert (SyntheticNaming.verifyNotInternalSynthetic(type));
            return this.maybeInsert(type, this.types, this.base.types);
        }

        @Override
        public boolean addCallSite(DexCallSite callSite) {
            return this.maybeInsert(callSite, this.callSites, this.base.callSites);
        }

        @Override
        public boolean addMethodHandle(DexMethodHandle methodHandle) {
            return this.maybeInsert(methodHandle, this.methodHandles, this.base.methodHandles);
        }

        @Override
        public GraphLens getGraphLens() {
            return this.appView.graphLens();
        }

        @Override
        public InitClassLens getInitClassLens() {
            return this.initClassLens;
        }

        @Override
        public DexString getRenamedDescriptor(DexType type) {
            return this.namingLens.lookupDescriptor(type);
        }

        @Override
        public DexString getRenamedName(DexMethod method) {
            assert (this.namingLens.verifyRenamingConsistentWithResolution(method));
            return this.namingLens.lookupName(method);
        }

        @Override
        public DexString getRenamedName(DexField field) {
            return this.namingLens.lookupName(field);
        }

        int getNumberOfMethods() {
            return this.methods.size() + this.base.getNumberOfMethods();
        }

        int getNumberOfClasses() {
            return this.classes.size() + this.base.classes.size();
        }

        int getNumberOfFields() {
            return this.fields.size() + this.base.getNumberOfFields();
        }

        void commit() {
            this.commitItemsIn(this.classes, this.base::addClass);
            this.commitItemsIn(this.fields, this.base::addField);
            this.commitItemsIn(this.methods, this.base::addMethod);
            this.commitItemsIn(this.protos, this.base::addProto);
            this.commitItemsIn(this.types, this.base::addType);
            this.commitItemsIn(this.strings, this.base::addString);
            this.commitItemsIn(this.callSites, this.base::addCallSite);
            this.commitItemsIn(this.methodHandles, this.base::addMethodHandle);
        }

        void abort() {
            this.classes.clear();
            this.fields.clear();
            this.methods.clear();
            this.protos.clear();
            this.types.clear();
            this.strings.clear();
        }

        public boolean isEmpty() {
            return this.classes.isEmpty() && this.fields.isEmpty() && this.methods.isEmpty() && this.protos.isEmpty() && this.types.isEmpty() && this.strings.isEmpty();
        }
    }

    private static class VirtualFileIndexedItemCollection
    implements IndexedItemCollection {
        private final GraphLens graphLens;
        private final InitClassLens initClassLens;
        private final NamingLens namingLens;
        private final Set<DexProgramClass> classes = Sets.newIdentityHashSet();
        private final Set<DexProto> protos = Sets.newIdentityHashSet();
        private final Set<DexType> types = Sets.newIdentityHashSet();
        private final Set<DexMethod> methods = Sets.newIdentityHashSet();
        private final Set<DexField> fields = Sets.newIdentityHashSet();
        private final Set<DexString> strings = Sets.newIdentityHashSet();
        private final Set<DexCallSite> callSites = Sets.newIdentityHashSet();
        private final Set<DexMethodHandle> methodHandles = Sets.newIdentityHashSet();

        public VirtualFileIndexedItemCollection(AppView<?> appView, NamingLens namingLens) {
            this.graphLens = appView.graphLens();
            this.initClassLens = appView.initClassLens();
            this.namingLens = namingLens;
        }

        @Override
        public boolean addClass(DexProgramClass clazz) {
            return this.classes.add(clazz);
        }

        @Override
        public boolean addField(DexField field) {
            return this.fields.add(field);
        }

        @Override
        public boolean addMethod(DexMethod method) {
            return this.methods.add(method);
        }

        @Override
        public boolean addString(DexString string) {
            return this.strings.add(string);
        }

        @Override
        public boolean addProto(DexProto proto) {
            return this.protos.add(proto);
        }

        @Override
        public boolean addType(DexType type) {
            assert (SyntheticNaming.verifyNotInternalSynthetic(type));
            return this.types.add(type);
        }

        @Override
        public boolean addCallSite(DexCallSite callSite) {
            return this.callSites.add(callSite);
        }

        @Override
        public boolean addMethodHandle(DexMethodHandle methodHandle) {
            return this.methodHandles.add(methodHandle);
        }

        int getNumberOfMethods() {
            return this.methods.size();
        }

        int getNumberOfFields() {
            return this.fields.size();
        }

        int getNumberOfStrings() {
            return this.strings.size();
        }

        @Override
        public GraphLens getGraphLens() {
            return this.graphLens;
        }

        @Override
        public InitClassLens getInitClassLens() {
            return this.initClassLens;
        }

        @Override
        public DexString getRenamedDescriptor(DexType type) {
            return this.namingLens.lookupDescriptor(type);
        }

        @Override
        public DexString getRenamedName(DexMethod method) {
            DexMethod mappedMethod = this.graphLens.lookupMethod(method);
            assert (this.namingLens.verifyRenamingConsistentWithResolution(mappedMethod));
            return this.namingLens.lookupName(mappedMethod);
        }

        @Override
        public DexString getRenamedName(DexField field) {
            return this.namingLens.lookupName(this.graphLens.lookupField(field));
        }
    }

    public static class MonoDexDistributor
    extends DistributorBase {
        MonoDexDistributor(ApplicationWriter writer, InternalOptions options) {
            super(writer, options);
        }

        @Override
        public List<VirtualFile> run() throws ExecutionException, IOException {
            Map<FeatureSplit, Set<DexProgramClass>> featureSplitClasses = this.removeFeatureSplitClassesGetMapping();
            for (DexProgramClass programClass : this.classes) {
                this.mainDexFile.addClass(programClass);
            }
            this.mainDexFile.commitTransaction();
            this.mainDexFile.throwIfFull(false, this.options.reporter);
            if (this.options.featureSplitConfiguration != null && !featureSplitClasses.isEmpty()) {
                this.addFeatureSplitFiles(featureSplitClasses);
            }
            return this.virtualFiles;
        }
    }

    public static class FillFilesDistributor
    extends DistributorBase {
        private final ExecutorService executorService;

        FillFilesDistributor(ApplicationWriter writer, InternalOptions options, ExecutorService executorService) {
            super(writer, options);
            this.executorService = executorService;
        }

        @Override
        public List<VirtualFile> run() throws IOException {
            boolean multidexLegacy;
            int totalClassNumber = this.classes.size();
            this.fillForMainDexList(this.classes);
            if (this.classes.isEmpty()) {
                return this.virtualFiles;
            }
            List<VirtualFile> filesForDistribution = this.virtualFiles;
            int fileIndexOffset = 0;
            boolean bl = multidexLegacy = !this.mainDexFile.isEmpty();
            if (this.options.minimalMainDex && multidexLegacy) {
                assert (!((VirtualFile)this.virtualFiles.get(0)).isEmpty());
                assert (this.virtualFiles.size() == 1);
                this.virtualFiles.add(new VirtualFile(1, this.writer.appView, this.writer.namingLens));
                filesForDistribution = this.virtualFiles.subList(1, this.virtualFiles.size());
                fileIndexOffset = 1;
            }
            Map<FeatureSplit, Set<DexProgramClass>> featureSplitClasses = this.removeFeatureSplitClassesGetMapping();
            if (multidexLegacy && this.options.enableInheritanceClassInDexDistributor) {
                new InheritanceClassInDexDistributor(this.mainDexFile, filesForDistribution, this.classes, fileIndexOffset, this.writer.namingLens, this.writer.appView, this.executorService).distribute();
            } else {
                this.classes = this.sortClassesByPackage(this.classes, this.originalNames);
                new PackageSplitPopulator(filesForDistribution, this.appView, this.classes, this.originalNames, fileIndexOffset, this.writer.namingLens, this.options).call();
            }
            this.addFeatureSplitFiles(featureSplitClasses);
            assert (totalClassNumber == this.virtualFiles.stream().mapToInt(dex -> dex.classes().size()).sum());
            return this.virtualFiles;
        }
    }

    public static abstract class DistributorBase
    extends Distributor {
        protected Set<DexProgramClass> classes;
        protected Map<DexProgramClass, String> originalNames;
        protected final VirtualFile mainDexFile;
        protected final InternalOptions options;

        DistributorBase(ApplicationWriter writer, InternalOptions options) {
            super(writer);
            this.options = options;
            this.mainDexFile = new VirtualFile(0, writer.appView, writer.namingLens);
            assert (this.virtualFiles.isEmpty());
            this.virtualFiles.add(this.mainDexFile);
            this.addMarkers(this.mainDexFile);
            this.classes = SetUtils.newIdentityHashSet(((AppInfo)this.appView.appInfo()).classes());
            this.originalNames = VirtualFile.computeOriginalNameMapping(this.classes, this.appView.graphLens(), ((AppInfo)this.appView.appInfo()).app().getProguardMap());
        }

        private void addMarkers(VirtualFile virtualFile) {
            if (this.writer.markerStrings != null && !this.writer.markerStrings.isEmpty()) {
                for (DexString markerString : this.writer.markerStrings) {
                    virtualFile.transaction.addString(markerString);
                }
                virtualFile.commitTransaction();
            }
        }

        protected void fillForMainDexList(Set<DexProgramClass> classes) {
            MainDexInfo mainDexInfo = ((AppInfo)this.appView.appInfo()).getMainDexInfo();
            if (mainDexInfo.isEmpty()) {
                return;
            }
            VirtualFile mainDexFile = (VirtualFile)this.virtualFiles.get(0);
            mainDexInfo.forEach(type -> {
                DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(((AppInfo)this.appView.appInfo()).definitionFor((DexType)type));
                if (clazz != null) {
                    mainDexFile.addClass(clazz);
                    classes.remove(clazz);
                }
                mainDexFile.commitTransaction();
            });
            if (Log.ENABLED) {
                Log.info(VirtualFile.class, "Main dex classes: " + mainDexFile.transaction.getNumberOfClasses(), new Object[0]);
                Log.info(VirtualFile.class, "Main dex methods: " + mainDexFile.transaction.getNumberOfMethods(), new Object[0]);
                Log.info(VirtualFile.class, "Main dex fields: " + mainDexFile.transaction.getNumberOfFields(), new Object[0]);
            }
            mainDexFile.throwIfFull(true, this.options.reporter);
        }

        TreeSet<DexProgramClass> sortClassesByPackage(Set<DexProgramClass> classes, Map<DexProgramClass, String> originalNames) {
            TreeSet<DexProgramClass> sortedClasses = new TreeSet<DexProgramClass>((a, b) -> {
                String prefixB;
                String originalA = (String)originalNames.get(a);
                String originalB = (String)originalNames.get(b);
                int indexA = originalA.lastIndexOf(46);
                int indexB = originalB.lastIndexOf(46);
                if (indexA == -1 && indexB == -1) {
                    return originalA.compareTo(originalB);
                }
                if (indexA == -1) {
                    return -1;
                }
                if (indexB == -1) {
                    return 1;
                }
                String prefixA = originalA.substring(0, indexA);
                int result = prefixA.compareTo(prefixB = originalB.substring(0, indexB));
                if (result != 0) {
                    return result;
                }
                return originalA.compareTo(originalB);
            });
            sortedClasses.addAll(classes);
            return sortedClasses;
        }

        protected Map<FeatureSplit, Set<DexProgramClass>> removeFeatureSplitClassesGetMapping() {
            assert (((AppInfo)this.appView.appInfo()).hasClassHierarchy() == this.appView.enableWholeProgramOptimizations());
            if (!((AppInfo)this.appView.appInfo()).hasClassHierarchy()) {
                return ImmutableMap.of();
            }
            ClassToFeatureSplitMap classToFeatureSplitMap = ((AppInfo)this.appView.appInfo()).withClassHierarchy().getClassToFeatureSplitMap();
            if (classToFeatureSplitMap.isEmpty()) {
                return ImmutableMap.of();
            }
            Map<FeatureSplit, Set<DexProgramClass>> featureSplitClasses = classToFeatureSplitMap.getFeatureSplitClasses(this.classes, this.appView.getSyntheticItems());
            if (featureSplitClasses.size() > 0) {
                for (Set<DexProgramClass> featureClasses : featureSplitClasses.values()) {
                    this.classes.removeAll(featureClasses);
                }
            }
            return featureSplitClasses;
        }

        protected void addFeatureSplitFiles(Map<FeatureSplit, Set<DexProgramClass>> featureSplitClasses) throws IOException {
            if (featureSplitClasses.isEmpty()) {
                return;
            }
            for (Map.Entry<FeatureSplit, Set<DexProgramClass>> featureSplitSetEntry : featureSplitClasses.entrySet()) {
                VirtualFile featureFile = new VirtualFile(0, this.writer.appView, this.writer.namingLens, featureSplitSetEntry.getKey());
                this.virtualFiles.add(featureFile);
                this.addMarkers(featureFile);
                TreeSet<DexProgramClass> featureClasses = this.sortClassesByPackage(featureSplitSetEntry.getValue(), this.originalNames);
                List<VirtualFile> filesForDistribution = this.virtualFiles.subList(this.virtualFiles.size() - 1, this.virtualFiles.size());
                new PackageSplitPopulator(filesForDistribution, this.appView, featureClasses, this.originalNames, 0, this.writer.namingLens, this.options).call();
            }
        }
    }

    public static class FilePerInputClassDistributor
    extends Distributor {
        private final boolean combineSyntheticClassesWithPrimaryClass;

        FilePerInputClassDistributor(ApplicationWriter writer, boolean combineSyntheticClassesWithPrimaryClass) {
            super(writer);
            this.combineSyntheticClassesWithPrimaryClass = combineSyntheticClassesWithPrimaryClass;
        }

        @Override
        public List<VirtualFile> run() {
            HashMap<DexProgramClass, VirtualFile> files = new HashMap<DexProgramClass, VirtualFile>();
            ArrayList<DexProgramClass> synthetics = new ArrayList<DexProgramClass>();
            for (DexProgramClass clazz : ((AppInfo)this.appView.appInfo()).classes()) {
                if (!this.combineSyntheticClassesWithPrimaryClass || !this.appView.getSyntheticItems().isSyntheticClass(clazz)) {
                    VirtualFile file = new VirtualFile(this.virtualFiles.size(), (AppView)this.writer.appView, this.writer.namingLens, clazz);
                    this.virtualFiles.add(file);
                    file.addClass(clazz);
                    files.put(clazz, file);
                    file.commitTransaction();
                    continue;
                }
                synthetics.add(clazz);
            }
            for (DexProgramClass synthetic : synthetics) {
                Collection<DexType> synthesizingContexts = this.appView.getSyntheticItems().getSynthesizingContextTypes(synthetic.getType());
                assert (synthesizingContexts.size() == 1);
                DexProgramClass inputType = this.appView.definitionForProgramType(synthesizingContexts.iterator().next());
                VirtualFile file = (VirtualFile)files.get(inputType);
                file.addClass(synthetic);
                file.commitTransaction();
            }
            return this.virtualFiles;
        }
    }

    public static abstract class Distributor {
        protected final AppView<?> appView;
        protected final ApplicationWriter writer;
        protected final List<VirtualFile> virtualFiles = new ArrayList<VirtualFile>();

        Distributor(ApplicationWriter writer) {
            this.appView = writer.appView;
            this.writer = writer;
        }

        public abstract List<VirtualFile> run() throws ExecutionException, IOException;
    }
}

