/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.diagnostic.internal;

import com.android.tools.r8.diagnostic.DefinitionClassContext;
import com.android.tools.r8.diagnostic.DefinitionContext;
import com.android.tools.r8.diagnostic.DefinitionFieldContext;
import com.android.tools.r8.diagnostic.DefinitionMethodContext;
import com.android.tools.r8.diagnostic.MissingClassInfo;
import com.android.tools.r8.diagnostic.MissingDefinitionInfo;
import com.android.tools.r8.diagnostic.MissingFieldInfo;
import com.android.tools.r8.diagnostic.MissingMethodInfo;
import com.android.tools.r8.diagnostic.internal.DefinitionContextUtils;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.utils.Box;
import com.android.tools.r8.utils.ClassReferenceUtils;
import com.android.tools.r8.utils.FieldReferenceUtils;
import com.android.tools.r8.utils.MethodReferenceUtils;
import java.util.Comparator;
import java.util.function.Consumer;

public class MissingDefinitionInfoUtils {
    private static final Comparator<MissingDefinitionInfo> COMPARATOR = (info, other) -> {
        if (info.isMissingClass()) {
            ClassReference classReference = info.asMissingClass().getClassReference();
            if (other.isMissingClass()) {
                return ClassReferenceUtils.compare(classReference, other.asMissingClass().getClassReference());
            }
            if (other.isMissingField()) {
                return ClassReferenceUtils.compare(classReference, other.asMissingField().getFieldReference());
            }
            return ClassReferenceUtils.compare(classReference, other.asMissingMethod().getMethodReference());
        }
        if (info.isMissingField()) {
            FieldReference fieldReference = info.asMissingField().getFieldReference();
            if (other.isMissingClass()) {
                return FieldReferenceUtils.compare(fieldReference, other.asMissingClass().getClassReference());
            }
            if (other.isMissingField()) {
                return FieldReferenceUtils.compare(fieldReference, other.asMissingField().getFieldReference());
            }
            return FieldReferenceUtils.compare(fieldReference, other.asMissingMethod().getMethodReference());
        }
        MethodReference methodReference = info.asMissingMethod().getMethodReference();
        if (other.isMissingClass()) {
            return MethodReferenceUtils.compare(methodReference, other.asMissingClass().getClassReference());
        }
        if (other.isMissingField()) {
            return MethodReferenceUtils.compare(methodReference, other.asMissingField().getFieldReference());
        }
        return MethodReferenceUtils.compare(methodReference, other.asMissingMethod().getMethodReference());
    };

    public static void accept(MissingDefinitionInfo missingDefinitionInfo, Consumer<MissingClassInfo> missingClassInfoConsumer, Consumer<MissingFieldInfo> missingFieldInfoConsumer, Consumer<MissingMethodInfo> missingMethodInfoConsumer) {
        if (missingDefinitionInfo.isMissingClass()) {
            missingClassInfoConsumer.accept(missingDefinitionInfo.asMissingClass());
        } else if (missingDefinitionInfo.isMissingField()) {
            missingFieldInfoConsumer.accept(missingDefinitionInfo.asMissingField());
        } else {
            assert (missingDefinitionInfo.isMissingMethod());
            missingMethodInfoConsumer.accept(missingDefinitionInfo.asMissingMethod());
        }
    }

    public static Comparator<MissingDefinitionInfo> getComparator() {
        return COMPARATOR;
    }

    public static void writeDiagnosticMessage(StringBuilder builder, MissingDefinitionInfo missingDefinitionInfo) {
        MissingDefinitionInfoUtils.accept(missingDefinitionInfo, missingClassInfo -> builder.append("Missing class ").append(missingClassInfo.getClassReference().getTypeName()), missingFieldInfo -> builder.append("Missing field ").append(FieldReferenceUtils.toSourceString(missingFieldInfo.getFieldReference())), missingMethodInfo -> builder.append("Missing method ").append(MethodReferenceUtils.toSourceString(missingMethodInfo.getMethodReference())));
        MissingDefinitionInfoUtils.writeReferencedFromSuffix(builder, missingDefinitionInfo);
    }

    private static void writeReferencedFromSuffix(StringBuilder builder, MissingDefinitionInfo missingDefinitionInfo) {
        Box classContext = new Box();
        Box fieldContext = new Box();
        Box methodContext = new Box();
        for (DefinitionContext missingDefinitionContext : missingDefinitionInfo.getReferencedFromContexts()) {
            DefinitionContextUtils.accept(missingDefinitionContext, (DefinitionClassContext missingDefinitionClassContext) -> classContext.setMin(missingDefinitionClassContext.getClassReference(), ClassReferenceUtils.getClassReferenceComparator()), (DefinitionFieldContext missingDefinitionFieldContext) -> fieldContext.setMin(missingDefinitionFieldContext.getFieldReference(), FieldReferenceUtils.getFieldReferenceComparator()), (DefinitionMethodContext missingDefinitionMethodContext) -> methodContext.setMin(missingDefinitionMethodContext.getMethodReference(), MethodReferenceUtils.getMethodReferenceComparator()));
        }
        if (fieldContext.isSet()) {
            MissingDefinitionInfoUtils.writeReferencedFromSuffix(builder, missingDefinitionInfo, FieldReferenceUtils.toSourceString((FieldReference)fieldContext.get()));
        } else if (methodContext.isSet()) {
            MissingDefinitionInfoUtils.writeReferencedFromSuffix(builder, missingDefinitionInfo, MethodReferenceUtils.toSourceString((MethodReference)methodContext.get()));
        } else if (classContext.isSet()) {
            MissingDefinitionInfoUtils.writeReferencedFromSuffix(builder, missingDefinitionInfo, ((ClassReference)classContext.get()).getTypeName());
        }
    }

    private static void writeReferencedFromSuffix(StringBuilder builder, MissingDefinitionInfo missingDefinitionInfo, String referencedFrom) {
        int numberOfOtherContexts = missingDefinitionInfo.getReferencedFromContexts().size() - 1;
        assert (numberOfOtherContexts >= 0);
        builder.append(" (referenced from: ").append(referencedFrom);
        if (numberOfOtherContexts >= 1) {
            builder.append(" and ").append(numberOfOtherContexts).append(" other context");
            if (numberOfOtherContexts >= 2) {
                builder.append("s");
            }
        }
        builder.append(")");
    }
}

