/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.diagnostic.internal;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.diagnostic.MissingDefinitionInfo;
import com.android.tools.r8.diagnostic.MissingDefinitionsDiagnostic;
import com.android.tools.r8.diagnostic.internal.MissingDefinitionInfoUtils;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class MissingDefinitionsDiagnosticImpl
implements MissingDefinitionsDiagnostic {
    private final Collection<MissingDefinitionInfo> missingDefinitions;

    private MissingDefinitionsDiagnosticImpl(Collection<MissingDefinitionInfo> missingDefinitions) {
        assert (!missingDefinitions.isEmpty());
        this.missingDefinitions = missingDefinitions;
    }

    public static Builder builder() {
        return new Builder();
    }

    private Collection<MissingDefinitionInfo> getMissingDefinitionsWithDeterministicOrder() {
        ArrayList<MissingDefinitionInfo> missingDefinitionsWithDeterministicOrder = new ArrayList<MissingDefinitionInfo>(this.missingDefinitions);
        missingDefinitionsWithDeterministicOrder.sort(MissingDefinitionInfoUtils.getComparator());
        return missingDefinitionsWithDeterministicOrder;
    }

    @Override
    public Collection<MissingDefinitionInfo> getMissingDefinitions() {
        return this.getMissingDefinitionsWithDeterministicOrder();
    }

    @Override
    public Origin getOrigin() {
        return Origin.unknown();
    }

    @Override
    public Position getPosition() {
        return Position.UNKNOWN;
    }

    @Override
    public String getDiagnosticMessage() {
        StringBuilder builder = new StringBuilder();
        Iterator<MissingDefinitionInfo> missingDefinitionsIterator = this.getMissingDefinitionsWithDeterministicOrder().iterator();
        assert (missingDefinitionsIterator.hasNext());
        MissingDefinitionInfoUtils.writeDiagnosticMessage(builder, missingDefinitionsIterator.next());
        missingDefinitionsIterator.forEachRemaining(missingDefinition -> MissingDefinitionInfoUtils.writeDiagnosticMessage(builder.append(System.lineSeparator()), missingDefinition));
        return builder.toString();
    }

    public static class Builder {
        private ImmutableList.Builder<MissingDefinitionInfo> missingDefinitionsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public Builder addMissingDefinitionInfo(MissingDefinitionInfo missingDefinition) {
            this.missingDefinitionsBuilder.add((Object)missingDefinition);
            return this;
        }

        public MissingDefinitionsDiagnostic build() {
            return new MissingDefinitionsDiagnosticImpl(this.missingDefinitionsBuilder.build());
        }
    }
}

