/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dump;

import java.util.function.Consumer;

public class ProguardConfigSanitizer {
    private Consumer<String> cleanLineCallback = line -> ProguardConfigSanitizer.unhandled();
    private Consumer<String> commentCallback = comment -> this.cleanLineCallback.accept((String)comment);
    private Consumer<String> printDirectivesCallback = line -> ProguardConfigSanitizer.unhandled();
    private Runnable dontShrinkCallback = ProguardConfigSanitizer::unhandled;
    private Runnable dontOptimizeCallback = ProguardConfigSanitizer::unhandled;
    private Runnable dontObfuscateCallback = ProguardConfigSanitizer::unhandled;

    private static void unhandled() {
        throw new AssertionError((Object)"Unhandled");
    }

    public static ProguardConfigSanitizer createUnhandled() {
        return new ProguardConfigSanitizer();
    }

    public static ProguardConfigSanitizer createDefaultForward(Consumer<String> callback) {
        ProguardConfigSanitizer sanitizer = new ProguardConfigSanitizer();
        return sanitizer.onCleanLine(callback).onDontShrink(() -> sanitizer.cleanLineCallback.accept("-dontshrink")).onDontOptimize(() -> sanitizer.cleanLineCallback.accept("-dontoptimize")).onDontObfuscate(() -> sanitizer.cleanLineCallback.accept("-dontobfuscate")).onPrintDirective(sanitizer.cleanLineCallback);
    }

    public ProguardConfigSanitizer onCleanLine(Consumer<String> callback) {
        this.cleanLineCallback = callback;
        return this;
    }

    public ProguardConfigSanitizer onDontShrink(Runnable callback) {
        this.dontShrinkCallback = callback;
        return this;
    }

    public ProguardConfigSanitizer onDontOptimize(Runnable callback) {
        this.dontOptimizeCallback = callback;
        return this;
    }

    public ProguardConfigSanitizer onDontObfuscate(Runnable callback) {
        this.dontObfuscateCallback = callback;
        return this;
    }

    public ProguardConfigSanitizer onComment(Consumer<String> callback) {
        this.commentCallback = callback;
        return this;
    }

    public ProguardConfigSanitizer onPrintDirective(Consumer<String> callback) {
        this.printDirectivesCallback = callback;
        return this;
    }

    public void sanitize(String line) {
        String trimmed = line.trim();
        if (trimmed.equals("-dontobfuscate")) {
            this.dontObfuscateCallback.run();
        } else if (trimmed.equals("-dontoptimize")) {
            this.dontOptimizeCallback.run();
        } else if (trimmed.equals("-dontshrink")) {
            this.dontShrinkCallback.run();
        } else if (trimmed.startsWith("-print")) {
            this.printDirectivesCallback.accept(line);
        } else if (trimmed.startsWith("#")) {
            this.commentCallback.accept(line);
        } else {
            this.cleanLineCallback.accept(line);
        }
    }
}

